/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class GZip
extends Task {
    private File zipFile;
    private File source;

    public void setZipfile(String string) {
        this.zipFile = this.project.resolveFile(string);
    }

    public void setSrc(String string) {
        this.source = this.project.resolveFile(string);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws BuildException {
        if (this.zipFile == null) {
            throw new BuildException("zipfile attribute is required", this.location);
        }
        if (this.source == null) {
            throw new BuildException("src attribute is required", this.location);
        }
        this.log("Building gzip: " + this.zipFile.getAbsolutePath());
        GZIPOutputStream gZIPOutputStream = null;
        try {
            try {
                gZIPOutputStream = new GZIPOutputStream(new FileOutputStream(this.zipFile));
                if (this.source.isDirectory()) {
                    this.log("Cannot Gzip a directory!", 0);
                } else {
                    this.zipFile(this.source, gZIPOutputStream);
                }
            }
            catch (IOException iOException) {
                String string = "Problem creating gzip " + iOException.getMessage();
                throw new BuildException(string, iOException, this.location);
            }
            Object var5_2 = null;
            if (gZIPOutputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var5_3 = null;
            if (gZIPOutputStream == null) throw throwable;
            try {
                gZIPOutputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        gZIPOutputStream.close();
        return;
    }

    private void zipFile(InputStream inputStream, GZIPOutputStream gZIPOutputStream) throws IOException {
        byte[] byArray = new byte[8192];
        int n = 0;
        do {
            gZIPOutputStream.write(byArray, 0, n);
        } while ((n = inputStream.read(byArray, 0, byArray.length)) != -1);
    }

    private void zipFile(File file, GZIPOutputStream gZIPOutputStream) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            this.zipFile(fileInputStream, gZIPOutputStream);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            fileInputStream.close();
            throw throwable;
        }
        fileInputStream.close();
    }
}

