/*
 * Decompiled with CFR 0.152.
 */
package org.apache.java.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Random;
import java.util.Vector;
import org.apache.java.lang.Bytes;
import org.apache.java.net.AuthenticationException;
import org.apache.java.security.MessageDigest;

public class AuthenticatedServerSocket
extends ServerSocket {
    private byte[] secret;
    private long seed;
    private MessageDigest md;
    private Random random;
    private int challengeSize;
    private int maxConnections;
    private Vector filterList;

    public Socket accept() throws AuthenticationException {
        InetAddress inetAddress;
        Socket socket;
        while (true) {
            try {
                socket = super.accept();
                inetAddress = socket.getInetAddress();
            }
            catch (IOException iOException) {
                continue;
            }
            break;
        }
        try {
            if (this.filterList == null || this.filterList != null && this.filterList.contains(inetAddress)) {
                if (this.isAuthenticated(socket)) {
                    return socket;
                }
                socket.close();
                throw new AuthenticationException("Connection from " + inetAddress + " refused due to authentication failure");
            }
            throw new AuthenticationException("Connections from " + inetAddress + " are not allowed");
        }
        catch (IOException iOException) {
            if (iOException instanceof AuthenticationException) {
                throw (AuthenticationException)iOException;
            }
            throw new AuthenticationException("Connection from " + inetAddress + " refused due to IO problems: " + iOException.getMessage());
        }
    }

    private boolean isAuthenticated(Socket socket) {
        if (this.md == null) {
            return true;
        }
        try {
            OutputStream outputStream = socket.getOutputStream();
            InputStream inputStream = socket.getInputStream();
            byte[] byArray = new byte[this.challengeSize];
            this.random.nextBytes(byArray);
            long l = System.currentTimeMillis();
            byte[] byArray2 = Bytes.toBytes(l);
            byArray = Bytes.append(byArray, byArray2);
            byte[] byArray3 = Bytes.toBytes(byArray.length);
            outputStream.write(byArray3);
            outputStream.write(byArray);
            byte[] byArray4 = this.md.digest(Bytes.append(byArray, this.secret));
            byte[] byArray5 = new byte[16];
            inputStream.read(byArray5);
            return Bytes.areEqual(byArray4, byArray5);
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public Vector getFilterList() {
        return this.filterList;
    }

    public int getChallengeSize() {
        return this.challengeSize;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public AuthenticatedServerSocket(int n, int n2, Vector vector) throws IOException {
        this(n, n2, vector, null, null, 0, InetAddress.getLocalHost());
    }

    public AuthenticatedServerSocket(int n, int n2, Vector vector, InetAddress inetAddress) throws IOException {
        this(n, n2, vector, null, null, 0, inetAddress);
    }

    public AuthenticatedServerSocket(int n, int n2, Vector vector, MessageDigest messageDigest, byte[] byArray, int n3, InetAddress inetAddress) throws IOException {
        super(n, n2, inetAddress);
        this.maxConnections = n2;
        this.filterList = vector;
        this.md = messageDigest;
        this.secret = byArray;
        this.random = new Random(System.currentTimeMillis());
        this.challengeSize = n3 < 5 ? 5 : n3;
    }
}

