import com.clarkware.junitperf.*;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

/**
 * The <code>ExampleTimedTest</code> is a <code>TestCase</code> 
 * that demonstrates how to decorate a <code>Test</code>
 * as a <code>TimedTest</code>.
 *
 * @author <a href="mailto:mike@clarkware.com">Mike Clark</a>
 * @author <a href="http://www.clarkware.com">Clarkware Consulting, Inc.</a>
 *
 * @see junit.framework.TestCase
 * @see com.clarkware.junitperf.TimedTest
 */

public class ExampleTimedTest extends TestCase {

	public static final long tolerance = 100;
	
	/**
	 * Constructs an <code>ExampleTimedTest</code>
	 * with the specified name.
	 *
	 * @param name Test name.
	 */
	public ExampleTimedTest(String name) {
		super(name);
	}

	/**
	 * Assembles and returns a test suite.
	 *
	 * @return A non-null <code>Test</code> instance.
	 */
	public static Test suite() {
		TestSuite suite = new TestSuite();

		long maxElapsedTime = 1000 + tolerance;

		Test testCase = new ExampleTestCase("testOneSecondResponse");
		Test timedTest = new TimedTest(testCase, maxElapsedTime);

		suite.addTest(timedTest);

		return suite;
	}

	/**
	 * Main.
	 */
	public static void main(String args[]) {
		junit.textui.TestRunner.run(suite());
	}
}
