AC_DEFUN(AC_FIND_FILE, [
  $3=NO
  for i in $2; do
    for j in $1; do
      if test -r "$i/$j"; then
        $3=$i
        break 2
      fi
    done
  done
])



AC_DEFUN(AC_PATH_QT_LIB, [
  AC_REQUIRE_CPP()
  AC_REQUIRE([AC_PATH_X])
  AC_MSG_CHECKING(for QT libraries)

  ac_qt_libraries="no"

  AC_ARG_WITH(qt-libraries,
    [  --with-qt-libraries     location of QT libraries ],
    [  ac_qt_libraries="$withval" ])

  AC_CACHE_VAL(ac_cv_lib_qtlib, [
    if test "$ac_qt_libraries" = no; then
      qt_library_dirs="\
        /usr/lib/qt2/lib \
        /usr/local/lib \
        /usr/lib \
        /usr/lib/qt \
        /usr/lib/qt2 \
        /usr/lib/qt/lib \
        /usr/lib/qt2/lib \
        /usr/local/lib/qt \
        /usr/local/lib/qt2 \
        /usr/local/qt/lib \
        /usr/local/qt2/lib \
        /usr/X11R6/lib \
        /usr/X11R6/lib/qt \
        /usr/X11R6/lib/qt2 \
        /usr/X11/lib \
        /usr/X11/lib/qt \
        /usr/X11/lib/qt2"

      if test "x$QTDIR" != x; then
        qt_library_dirs="$QTDIR/lib $qt_library_dirs"
      fi
      if test "x$QTLIB" != x; then
        qt_library_dirs="$QTLIB $qt_library_dirs"
      fi
      for qt_dir in $qt_library_dirs; do
        if (test -r "$qt_dir/libqt.so.2") || (test -r "$qt_dir/libqt2.so"); then
          ac_qt_libraries=$qt_dir
          break
        fi
      done
    fi

    ac_cv_lib_qtlib=$ac_qt_libraries
  ])

  if test "$ac_cv_lib_qtlib" = no; then
    have_qt_lib="no"
  else
    have_qt_lib="yes"

    if test -r "$ac_cv_lib_qtlib/libqt2.so"; then
      QT_LQT="-lqt2"
      qtlib_file_name="$ac_cv_lib_qtlib/libqt2.so"
    else
      QT_LQT="-lqt"
      qtlib_file_name="$ac_cv_lib_qtlib/libqt.so"
    fi

    output=`eval "strings $qtlib_file_name | grep -l QCString"`
    if test -z "$output"; then
      AC_MSG_ERROR([The Qt lib directory $ac_cv_lib_qtlib found by
        configure does not contain a Qt 2.0 or higher lib
        Use the --with-qt-libraries option if ./configure found
        the wrong Qt lib version.
      ])
    fi
  fi

  AC_MSG_RESULT([$ac_cv_lib_qtlib])
  QT_LDFLAGS="-L$ac_cv_lib_qtlib"
  QT_LIBDIR="$ac_cv_lib_qtlib"
  AC_SUBST(QT_LDFLAGS)
  AC_SUBST(QT_LIBDIR)
  AC_SUBST(QT_LQT)
])



AC_DEFUN(AC_PATH_QT_INC, [
  AC_REQUIRE_CPP()
  AC_REQUIRE([AC_PATH_X])
  AC_MSG_CHECKING(for QT includes)

  ac_qt_includes="no"

  AC_ARG_WITH(qt-includes,
    [  --with-qt-includes      location of QT headers ],
    [  ac_qt_includes="$withval" ])

  AC_CACHE_VAL(ac_cv_header_qtinc, [
    if test "$ac_qt_includes" = no; then
      qt_include_dirs="\
        /usr/lib/qt2/include \
        /usr/lib/qt/include \
        /usr/include/qt \
        /usr/include/qt2 \
        /usr/local/qt/include \
        /usr/local/qt2/include \
        /usr/local/include/qt \
        /usr/local/include/qt2 \
        /usr/X11/include/qt \
        /usr/X11/include/qt2 \
        /usr/X11R6/include/qt \
        /usr/X11R6/include/qt2 \
        /usr/X11R6/include/X11/qt \
        /usr/X11R6/include/X11/qt2 \
        /usr/X11/include/X11/qt \
        /usr/X11/include/X11/qt2 \
        /usr/X11R6/include \
        /usr/X11/lib/qt2/include \
        /usr/X11/lib/qt/include"

      if test -n "$QTDIR"; then
        qt_include_dirs="$QTDIR/include $qt_include_dirs"
      fi
      if test -n "$QTINC"; then
        qt_include_dirs="$QTINC $qt_include_dirs"
      fi
      for qt_dir in $qt_include_dirs; do
        if test -r "$qt_dir/qcstring.h"; then
          ac_qt_includes=$qt_dir
          break
        fi
      done
    fi

    ac_cv_header_qtinc=$ac_qt_includes
  ])

  if test "$ac_cv_header_qtinc" = no; then
    have_qt_inc="no"
  else
    have_qt_inc="yes"
  fi

  AC_MSG_RESULT([$ac_cv_header_qtinc])
  QT_INCLUDES="-I$ac_cv_header_qtinc"
  QT_INCDIR="$ac_cv_header_qtinc"
  AC_SUBST(QT_INCLUDES)
  AC_SUBST(QT_INCDIR)
])



AC_DEFUN(AC_PATH_QT_MOC, [
  ac_qt_moc="no"

  AC_ARG_WITH(qt-moc,
    [  --with-qt-moc           location of QT moc ],
    [  ac_qt_moc="$withval" ])

  if test "$ac_qt_moc" = "no"; then
    if test -z "$QTDIR"; then
      AC_MSG_WARN(environment variable QTDIR is not set, moc might not be found)
    fi

    AC_PATH_PROG(
      MOC,
      moc,
      $QTDIR/bin/moc,
      $QTDIR/bin:/usr/lib/qt2/bin:/usr/bin:/usr/lib/qt/bin:/usr/local/qt/bin:/usr/X11R6/bin:$PATH
    )
    if !(test -r "$MOC"); then
      AC_MSG_WARN(missing moc $MOC)
      AC_PATH_PROG(
        MOC2,
        moc2,
        $QTDIR/bin/moc2,
        $QTDIR/bin:/usr/lib/qt2/bin:/usr/bin:/usr/lib/qt/bin:/usr/local/qt/bin:/usr/X11R6/bin:$PATH
      )
      MOC="$MOC2"
      if !(test -r "$MOC"); then
        AC_MSG_ERROR(cannot find QT moc. Please use --with-qt-moc)
      fi
    fi

  else
    AC_MSG_CHECKING(for moc)

    if test -f $ac_qt_moc && test -x $ac_qt_moc; then
      MOC=$ac_qt_moc
    else
      AC_MSG_ERROR(--with-qt-moc expects path and name of the moc)
    fi

    AC_MSG_RESULT($MOC)
  fi

  if test -z "$MOC"; then
    AC_MSG_ERROR(cannot find QT moc. Please use --with-qt-moc)
  fi

  output=`eval "strings $MOC | grep -l QCString"`
  if test -z "$output"; then
    AC_MSG_ERROR([The QT moc $MOC found by configure is not the version of QT 2.0 or higher])
  fi

  AC_SUBST(MOC)
])



AC_DEFUN(AC_ENABLE_DEBUG, [
  AC_ARG_ENABLE(debug,
    [  --enable-debug          enable debug],
    [ with_debug="$enableval"], [with_debug="no"])
  if test "$with_debug" = "no"; then
    CXXFLAGS="`echo $CXXFLAGS | sed s/-g//`"
    CFLAGS="`echo $CFLAGS | sed s/-g//`"
  fi
])



AC_DEFUN(AC_GET_DATA_DIR, [
  if test "$datadir" = '${prefix}/share'; then
    if test "$prefix" = 'NONE'; then
      DATA_DIR="$ac_default_prefix/share"
    else
      DATA_DIR="$prefix/share"
    fi
  else
    DATA_DIR="$datadir"
  fi
  AC_SUBST(DATA_DIR)
])



AC_DEFUN(AC_PATH_KDE, [
  AC_REQUIRE([AC_PATH_QT_LIB])
  AC_REQUIRE([AC_PATH_QT_INC])
  AC_MSG_CHECKING([for KDE 2])

  ac_kde_includes=""
  ac_kde_libraries=""
  kde_libraries=""
  kde_includes=""

  AC_ARG_WITH(kde,
    [  --with-kde              compile with KDE support. ],
    [  ac_kde="$withval" ])

  dnl Check for KDE 2 includes
  kde_incdirs="\
    /usr/include \
    /usr/lib/kde/include \
    /usr/local/kde/include \
    /usr/kde/include \
    /usr/include/kde \
    /opt/kde2/include \
    /opt/kde/include \
    $x_includes \
    $qt_includes"
  if test -n "$KDEDIR"; then
    kde_incdirs="$KDEDIR/include $KDEDIR $kde_incdirs"
  fi
  AC_FIND_FILE(kaction.h, $kde_incdirs, kde_incdir)
  kde_includes=$kde_incdir

  dnl Check for KDE 2 libraries
  kde_libdirs="\
    /usr/lib \
    /usr/kde/lib \
    /usr/lib/kde \
    /usr/lib/kde/lib \
    /usr/local/kde/lib \
    /opt/kde2/lib \
    /opt/kde/lib \
    /usr/X11R6/lib \
    /usr/X11R6/kde/lib"
  if test -n "$KDEDIR"; then
    kde_libdirs="$KDEDIR/lib $KDEDIR $kde_libdirs"
  fi
  AC_FIND_FILE(libksycoca.la, $kde_libdirs, kde_libdir)
  kde_libraries=$kde_libdir

  dnl Define INCLUDES and LDFLAGS
  if test -n "$kde_includes" && test -n "$kde_libraries" && test -n "$ac_kde"; then
    if test "$kde_includes" != "$x_includes" && test "$kde_includes" != "$qt_includes"; then
      KDE_INCLUDES="-I$kde_includes"
    fi
    if test "$kde_libraries" != "$x_libraries" && test "$kde_libraries" != "$qt_libraries"; then
      KDE_LDFLAGS="-L$kde_libraries"
    fi

    AC_MSG_RESULT([libraries $kde_libraries, headers $kde_includes])
    AC_DEFINE(WITH_KDE)
    KDE_LIBS="-lkfile"
    AC_SUBST(KDE_LIBS)
    have_kde=yes
    AC_SUBST(have_kde)
  else
    AC_MSG_RESULT(["no"])
    KDE_LDFLAGS=""
    KDE_LIBS=""
    KDE_INCLUDES=""
  fi

  AC_SUBST(KDE_LDFLAGS)
  AC_SUBST(KDE_INCLUDES)
  AC_SUBST(kde_libraries)
  AC_SUBST(kde_includes)
])
