/*


    ========== licence begin GPL
    Copyright (C) 2002-2003 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


*/

package com.sap.dbtech.jdbc.translators;

import java.io.*;

import com.sap.dbtech.util.StringUtil;

/**
 *
 */
public class ReaderInputStream
    extends InputStream
{
    private Reader reader;
    private char [] charBuf = new char [4096];
    private byte [] byteBuf;
    private int bufPos = 0;
    private int bufExtent = 0;
    private boolean atEnd = false;
    private boolean sevenbit = false;
    /**
     * creates a new ReaderInputStream
     */
    public
    ReaderInputStream (
        Reader reader, boolean sevenbit)
    {
        this.reader = reader;
        this.sevenbit = sevenbit;
    }
    /**
     *
     */
    public int
    available ()
    {
        int result;

        result = this.bufExtent - this.bufPos;
        return result;
    }
    /**
     *
     */
    public void
    close ()
    throws IOException
    {
        this.bufPos = 0;
        this.bufExtent = 0;
        this.reader.close ();
    }
    /**
     *
     */
    public int
    read ()
    throws IOException
    {
        int result;

        if (this.bufPos >= this.bufExtent) {
            this.fillBuffer ();
        }
        result = this.byteBuf [this.bufPos];
        ++this.bufPos;
        return result;
    }
    /**
     *
     */
    public int
    read (
        byte [] buf,
        int off,
        int len)
    throws IOException
    {
        int bytesCopied = 0;
        boolean atEnd = false;

        while ((len > 0) && !atEnd) {
            if (this.bufPos >= this.bufExtent) {
                this.fillBuffer ();
            }
            if (this.bufPos >= this.bufExtent) {
                break;
            }
            int copySize = java.lang.Math.min (len, this.bufExtent - this.bufPos);
            System.arraycopy (this.byteBuf, this.bufPos, buf, off, copySize);
            this.bufPos += copySize;
            off += copySize;
            len -= copySize;
            bytesCopied += copySize;
            atEnd = this.atEnd;
        }
        if (bytesCopied == 0) {
            bytesCopied = -1;
        }
        return bytesCopied;
    }
    /**
     *
     */
    private void
    fillBuffer ()
    throws IOException
    {
        this.bufPos = 0;
        this.bufExtent = 0;
        int charsRead =  this.reader.read (this.charBuf);
        if (charsRead < this.charBuf.length) {
            this.atEnd = true;
        }
        if (charsRead < 0) {
            return;
        }
        String converter = new String (this.charBuf, 0, charsRead);
        if(this.sevenbit) {
			this.byteBuf = StringUtil.bytes_ascii7bit(converter);
        } else {
			this.byteBuf = StringUtil.bytes_iso8859_1(converter);	
        }
        this.bufExtent = this.byteBuf.length;
    }
    /**
     *
     */
    public void
    reset ()
    throws IOException
    {
        this.bufPos = 0;
        this.bufExtent = 0;
        this.reader.reset ();
    }
}
