package  com.sap.dbtech.util;
/*


    ========== licence begin GPL
    Copyright (C) 2002-2003 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


*/

import  java.util.Vector;

import com.sap.dbtech.jdbc.ConnectionSapDB;

public abstract class GarbageCan {
    private Vector garbage;
    private int canTresholdC = 20;
    private boolean objPending = false;
    private boolean currentEmptyRun = false;
    private boolean currentEmptyRun2 = false;
    public GarbageCan () {
        this(20);
    }

    public GarbageCan (int aTreshhold) {
        this.canTresholdC = aTreshhold;
        this.garbage = new Vector(aTreshhold);
    }

    public boolean isPending () {
        if (this.garbage.size() >= canTresholdC) {
            this.objPending = true;
        }
        else {
            this.objPending = false;
        }
        return  this.objPending;
    }

    final public void throwIntoGarbageCan (Object obj) {
        this.garbage.addElement(obj);
    }

    final public void forceGarbageCollection(){
      this.objPending = true;
    }

    final public synchronized boolean emptyCan(com.sap.dbtech.jdbc.packet.RequestPacket requestPacket)
    {
        if(currentEmptyRun2)
            return false;
        currentEmptyRun2=true;

        boolean packetActionFailed=false;
        int sz=this.garbage.size();
        while(sz>0 &&
              !packetActionFailed) {
            Object o=this.garbage.remove(sz-1);
            packetActionFailed = ! packetAction(requestPacket, o);
            if(packetActionFailed) {
                this.garbage.addElement(o);
            }
            --sz;
        }
        currentEmptyRun2=false;
        return !packetActionFailed;
    }

    final public void emptyCan (ConnectionSapDB conn) {
        if(currentEmptyRun)
            return;
        currentEmptyRun=true;

        com.sap.dbtech.jdbc.packet.RequestPacket requestPacket;
        this.objPending = false;
        while (this.garbage.size()>0) {
            try {
                requestPacket = conn.getRequestPacket();
                requestPacket.initializePacket(Short.MAX_VALUE);
                emptyCan(  requestPacket);
                conn.execute(requestPacket, this, ConnectionSapDB.GC_NONE);
            } catch (java.sql.SQLException ignore) { /* ignore */}
        }
        currentEmptyRun=false;
    }

    final public void emptyCan () {
      this.garbage.removeAllElements();
    }

    abstract public boolean packetAction(com.sap.dbtech.jdbc.packet.RequestPacket requestPacket,
                                         Object obj);
}



