/*
 * Copyright 2003-2007 Keith Seymour.
 * Copyright 1992-2007 The University of Tennessee. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 * 
 * - Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer.
 * 
 * - Redistributions in binary form must reproduce the above copyright
 *   notice, this list of conditions and the following disclaimer listed
 *   in this license in the documentation and/or other materials
 *   provided with the distribution.
 * 
 * - Neither the name of the copyright holders nor the names of its
 *   contributors may be used to endorse or promote products derived from
 *   this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * This file was auto-generated by the org.netlib.generate.JavaGenerator
 * program, a part of netlib-java.
 * 
 * @see http://code.google.com/p/netlib-java/
 */
package org.netlib.arpack;

import java.util.logging.Logger;
import org.netlib.util.StringW;
import org.netlib.util.booleanW;
import org.netlib.util.doubleW;
import org.netlib.util.floatW;
import org.netlib.util.intW;

/**
 * ARPACK provider which will attempt to access a native implementation
 * and falling back to use F2J if none is available.
 *
 * @see http://sourceforge.net/projects/f2j
 * @see http://www.netlib.org/arpack/
 * @author Samuel Halliday
 */
public abstract class ARPACK {

	static private final ARPACK current;
	static {
		Logger logger = Logger.getLogger("org.netlib.arpack");
		if (NativeARPACK.INSTANCE.isLoaded) {
			current = NativeARPACK.INSTANCE;
			logger.config("Using JNI for ARPACK");
		} else {
			current = JARPACK.INSTANCE;
			logger.config("Using F2J as JNI failed for ARPACK");
		}
	}

	public static ARPACK getInstance() {
		return current;
	}

		/**
	 * No documentation was available when generating this method.
	 * 
	 * @param arg1
	 * @param arg2
	 * @param arg3
	 * @param arg4
	 * @param arg6
	 * @param arg7
	 * @param arg8
	 */
	public void dmout(int arg1, int arg2, int arg3, double[] arg4, int arg6, int arg7, String arg8) {
		org.netlib.arpack.Dmout.dmout(arg1, arg2, arg3, arg4, 0, arg6, arg7, arg8);
	}

		/**
	 * No documentation was available when generating this method.
	 * 
	 * @param arg1
	 * @param arg2
	 * @param arg3
	 * @param arg5
	 * @param arg6
	 */
	public void dvout(int arg1, int arg2, double[] arg3, int arg5, String arg6) {
		org.netlib.arpack.Dvout.dvout(arg1, arg2, arg3, 0, arg5, arg6);
	}

		/**
	 * No documentation was available when generating this method.
	 * 
	 * @param arg1
	 * @param arg2
	 * @param arg4
	 */
	public int icnteq(int arg1, int[] arg2, int arg4) {
		return org.netlib.arpack.Icnteq.icnteq(arg1, arg2, 0, arg4);
	}

		/**
	 * No documentation was available when generating this method.
	 * 
	 * @param arg1
	 * @param arg2
	 * @param arg4
	 * @param arg5
	 * @param arg7
	 */
	public void icopy(int arg1, int[] arg2, int arg4, int[] arg5, int arg7) {
		org.netlib.arpack.Icopy.icopy(arg1, arg2, 0, arg4, arg5, 0, arg7);
	}

		/**
	 * No documentation was available when generating this method.
	 * 
	 * @param arg1
	 * @param arg2
	 * @param arg3
	 * @param arg5
	 */
	public void iset(int arg1, int arg2, int[] arg3, int arg5) {
		org.netlib.arpack.Iset.iset(arg1, arg2, arg3, 0, arg5);
	}

		/**
	 * No documentation was available when generating this method.
	 * 
	 * @param arg1
	 * @param arg2
	 * @param arg4
	 * @param arg5
	 * @param arg7
	 */
	public void iswap(int arg1, int[] arg2, int arg4, int[] arg5, int arg7) {
		org.netlib.arpack.Iswap.iswap(arg1, arg2, 0, arg4, arg5, 0, arg7);
	}

		/**
	 * No documentation was available when generating this method.
	 * 
	 * @param arg1
	 * @param arg2
	 * @param arg3
	 * @param arg5
	 * @param arg6
	 */
	public void ivout(int arg1, int arg2, int[] arg3, int arg5, String arg6) {
		org.netlib.arpack.Ivout.ivout(arg1, arg2, arg3, 0, arg5, arg6);
	}

		/**
	 * No documentation was available when generating this method.
	 * 
	 * @param arg1
	 */
	public void second(floatW arg1) {
		org.netlib.arpack.Second.second(arg1);
	}

		/**
	 * No documentation was available when generating this method.
	 * 
	 * @param arg1
	 * @param arg2
	 * @param arg3
	 * @param arg4
	 * @param arg6
	 * @param arg7
	 * @param arg8
	 */
	public void smout(int arg1, int arg2, int arg3, float[] arg4, int arg6, int arg7, String arg8) {
		org.netlib.arpack.Smout.smout(arg1, arg2, arg3, arg4, 0, arg6, arg7, arg8);
	}

		/**
	 * No documentation was available when generating this method.
	 * 
	 * @param arg1
	 * @param arg2
	 * @param arg3
	 * @param arg5
	 * @param arg6
	 */
	public void svout(int arg1, int arg2, float[] arg3, int arg5, String arg6) {
		org.netlib.arpack.Svout.svout(arg1, arg2, arg3, 0, arg5, arg6);
	}

		/**
	 * No documentation was available when generating this method.
	 * 
	 * @param arg1
	 * @param arg2
	 * @param arg3
	 * @param arg4
	 * @param arg5
	 * @param arg6
	 * @param arg7
	 * @param arg9
	 * @param arg10
	 * @param arg12
	 * @param arg13
	 * @param arg15
	 * @param arg17
	 */
	public void dgetv0(intW arg1, String arg2, int arg3, boolean arg4, int arg5, int arg6, double[] arg7, int arg9, double[] arg10, doubleW arg12, int[] arg13, double[] arg15, intW arg17) {
		org.netlib.arpack.Dgetv0.dgetv0(arg1, arg2, arg3, arg4, arg5, arg6, arg7, 0, arg9, arg10, 0, arg12, arg13, 0, arg15, 0, arg17);
	}

		/**
	 * No documentation was available when generating this method.
	 * 
	 * @param arg1
	 * @param arg2
	 * @param arg3
	 * @param arg4
	 * @param arg5
	 * @param arg7
	 * @param arg8
	 * @param arg10
	 * @param arg12
	 * @param arg14
	 */
	public void dlaqrb(boolean arg1, int arg2, int arg3, int arg4, double[] arg5, int arg7, double[] arg8, double[] arg10, double[] arg12, intW arg14) {
		org.netlib.arpack.Dlaqrb.dlaqrb(arg1, arg2, arg3, arg4, arg5, 0, arg7, arg8, 0, arg10, 0, arg12, 0, arg14);
	}

		/**
	 * No documentation was available when generating this method.
	 * 
	 * @param arg1
	 * @param arg2
	 * @param arg3
	 * @param arg4
	 * @param arg5
	 * @param arg6
	 * @param arg7
	 * @param arg9
	 * @param arg10
	 * @param arg12
	 * @param arg13
	 * @param arg15
	 * @param arg16
	 * @param arg18
	 * @param arg20
	 */
	public void dnaitr(intW arg1, String arg2, int arg3, int arg4, int arg5, int arg6, double[] arg7, doubleW arg9, double[] arg10, int arg12, double[] arg13, int arg15, int[] arg16, double[] arg18, intW arg20) {
		org.netlib.arpack.Dnaitr.dnaitr(arg1, arg2, arg3, arg4, arg5, arg6, arg7, 0, arg9, arg10, 0, arg12, arg13, 0, arg15, arg16, 0, arg18, 0, arg20);
	}

		/**
	 * No documentation was available when generating this method.
	 * 
	 * @param arg1
	 * @param arg2
	 * @param arg3
	 * @param arg4
	 * @param arg6
	 * @param arg8
	 * @param arg10
	 * @param arg11
	 * @param arg13
	 * @param arg14
	 * @param arg16
	 * @param arg18
	 * @param arg19
	 * @param arg21
	 */
	public void dnapps(int arg1, intW arg2, int arg3, double[] arg4, double[] arg6, double[] arg8, int arg10, double[] arg11, int arg13, double[] arg14, double[] arg16, int arg18, double[] arg19, double[] arg21) {
		org.netlib.arpack.Dnapps.dnapps(arg1, arg2, arg3, arg4, 0, arg6, 0, arg8, 0, arg10, arg11, 0, arg13, arg14, 0, arg16, 0, arg18, arg19, 0, arg21, 0);
	}

		/**
	 * No documentation was available when generating this method.
	 * 
	 * @param arg1
	 * @param arg2
	 * @param arg3
	 * @param arg4
	 * @param arg5
	 * @param arg6
	 * @param arg7
	 * @param arg8
	 * @param arg10
	 * @param arg11
	 * @param arg12
	 * @param arg13
	 * @param arg14
	 * @param arg16
	 * @param arg17
	 * @param arg19
	 * @param arg20
	 * @param arg22
	 * @param arg24
	 * @param arg26
	 * @param arg28
	 * @param arg29
	 * @param arg31
	 * @param arg33
	 * @param arg35
	 */
	public void dnaup2(intW arg1, String arg2, int arg3, String arg4, intW arg5, intW arg6, double arg7, double[] arg8, int arg10, int arg11, int arg12, intW arg13, double[] arg14, int arg16, double[] arg17, int arg19, double[] arg20, double[] arg22, double[] arg24, double[] arg26, int arg28, double[] arg29, int[] arg31, double[] arg33, intW arg35) {
		org.netlib.arpack.Dnaup2.dnaup2(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, 0, arg10, arg11, arg12, arg13, arg14, 0, arg16, arg17, 0, arg19, arg20, 0, arg22, 0, arg24, 0, arg26, 0, arg28, arg29, 0, arg31, 0, arg33, 0, arg35);
	}

	/**
	 * No documentation was available when generating this method.
	 * 
	 * @param arg1
	 * @param arg2
	 * @param arg3
	 * @param arg4
	 * @param arg5
	 * @param arg6
	 * @param arg7
	 * @param arg9
	 * @param arg10
	 * @param arg12
	 * @param arg13
	 * @param arg15
	 * @param arg17
	 * @param arg19
	 * @param arg21
	 * @param arg22
	 */
	public abstract void dnaupd(intW arg1, String arg2, int arg3, String arg4, int arg5, doubleW arg6, double[] arg7, int arg9, double[] arg10, int arg12, int[] arg13, int[] arg15, double[] arg17, double[] arg19, int arg21, intW arg22);

		/**
	 * No documentation was available when generating this method.
	 * 
	 * @param arg1
	 * @param arg2
	 * @param arg4
	 * @param arg6
	 * @param arg8
	 * @param arg9
	 */
	public void dnconv(int arg1, double[] arg2, double[] arg4, double[] arg6, double arg8, intW arg9) {
		org.netlib.arpack.Dnconv.dnconv(arg1, arg2, 0, arg4, 0, arg6, 0, arg8, arg9);
	}

		/**
	 * No documentation was available when generating this method.
	 * 
	 * @param arg1
	 * @param arg2
	 * @param arg3
	 * @param arg5
	 * @param arg6
	 * @param arg8
	 * @param arg10
	 * @param arg12
	 * @param arg14
	 * @param arg15
	 * @param arg17
	 */
	public void dneigh(double arg1, intW arg2, double[] arg3, int arg5, double[] arg6, double[] arg8, double[] arg10, double[] arg12, int arg14, double[] arg15, intW arg17) {
		org.netlib.arpack.Dneigh.dneigh(arg1, arg2, arg3, 0, arg5, arg6, 0, arg8, 0, arg10, 0, arg12, 0, arg14, arg15, 0, arg17);
	}

	/**
	 * No documentation was available when generating this method.
	 * 
	 * @param arg1
	 * @param arg2
	 * @param arg3
	 * @param arg5
	 * @param arg7
	 * @param arg9
	 * @param arg11
	 * @param arg12
	 * @param arg13
	 * @param arg14
	 * @param arg16
	 * @param arg17
	 * @param arg18
	 * @param arg19
	 * @param arg20
	 * @param arg21
	 * @param arg23
	 * @param arg24
	 * @param arg26
	 * @param arg27
	 * @param arg29
	 * @param arg31
	 * @param arg33
	 * @param arg35
	 * @param arg36
	 */
	public abstract void dneupd(boolean arg1, String arg2, boolean[] arg3, double[] arg5, double[] arg7, double[] arg9, int arg11, double arg12, double arg13, double[] arg14, String arg16, int arg17, String arg18, intW arg19, double arg20, double[] arg21, int arg23, double[] arg24, int arg26, int[] arg27, int[] arg29, double[] arg31, double[] arg33, int arg35, intW arg36);

		/**
	 * No documentation was available when generating this method.
	 * 
	 * @param arg1
	 * @param arg2
	 * @param arg3
	 * @param arg4
	 * @param arg5
	 * @param arg7
	 * @param arg9
	 * @param arg11
	 * @param arg13
	 */
	public void dngets(int arg1, String arg2, intW arg3, intW arg4, double[] arg5, double[] arg7, double[] arg9, double[] arg11, double[] arg13) {
		org.netlib.arpack.Dngets.dngets(arg1, arg2, arg3, arg4, arg5, 0, arg7, 0, arg9, 0, arg11, 0, arg13, 0);
	}

		/**
	 * No documentation was available when generating this method.
	 * 
	 * @param arg1
	 * @param arg2
	 * @param arg3
	 * @param arg4
	 * @param arg5
	 * @param arg6
	 * @param arg7
	 * @param arg9
	 * @param arg10
	 * @param arg12
	 * @param arg13
	 * @param arg15
	 * @param arg16
	 * @param arg18
	 * @param arg20
	 */
	public void dsaitr(intW arg1, String arg2, int arg3, int arg4, int arg5, int arg6, double[] arg7, doubleW arg9, double[] arg10, int arg12, double[] arg13, int arg15, int[] arg16, double[] arg18, intW arg20) {
		org.netlib.arpack.Dsaitr.dsaitr(arg1, arg2, arg3, arg4, arg5, arg6, arg7, 0, arg9, arg10, 0, arg12, arg13, 0, arg15, arg16, 0, arg18, 0, arg20);
	}

		/**
	 * No documentation was available when generating this method.
	 * 
	 * @param arg1
	 * @param arg2
	 * @param arg3
	 * @param arg4
	 * @param arg6
	 * @param arg8
	 * @param arg9
	 * @param arg11
	 * @param arg12
	 * @param arg14
	 * @param arg16
	 * @param arg17
	 */
	public void dsapps(int arg1, int arg2, int arg3, double[] arg4, double[] arg6, int arg8, double[] arg9, int arg11, double[] arg12, double[] arg14, int arg16, double[] arg17) {
		org.netlib.arpack.Dsapps.dsapps(arg1, arg2, arg3, arg4, 0, arg6, 0, arg8, arg9, 0, arg11, arg12, 0, arg14, 0, arg16, arg17, 0);
	}

		/**
	 * No documentation was available when generating this method.
	 * 
	 * @param arg1
	 * @param arg2
	 * @param arg3
	 * @param arg4
	 * @param arg5
	 * @param arg6
	 * @param arg7
	 * @param arg8
	 * @param arg10
	 * @param arg11
	 * @param arg12
	 * @param arg13
	 * @param arg14
	 * @param arg16
	 * @param arg17
	 * @param arg19
	 * @param arg20
	 * @param arg22
	 * @param arg24
	 * @param arg26
	 * @param arg27
	 * @param arg29
	 * @param arg31
	 * @param arg33
	 */
	public void dsaup2(intW arg1, String arg2, int arg3, String arg4, intW arg5, intW arg6, double arg7, double[] arg8, int arg10, int arg11, int arg12, intW arg13, double[] arg14, int arg16, double[] arg17, int arg19, double[] arg20, double[] arg22, double[] arg24, int arg26, double[] arg27, int[] arg29, double[] arg31, intW arg33) {
		org.netlib.arpack.Dsaup2.dsaup2(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, 0, arg10, arg11, arg12, arg13, arg14, 0, arg16, arg17, 0, arg19, arg20, 0, arg22, 0, arg24, 0, arg26, arg27, 0, arg29, 0, arg31, 0, arg33);
	}

	/**
	 * No documentation was available when generating this method.
	 * 
	 * @param arg1
	 * @param arg2
	 * @param arg3
	 * @param arg4
	 * @param arg5
	 * @param arg6
	 * @param arg7
	 * @param arg9
	 * @param arg10
	 * @param arg12
	 * @param arg13
	 * @param arg15
	 * @param arg17
	 * @param arg19
	 * @param arg21
	 * @param arg22
	 */
	public abstract void dsaupd(intW arg1, String arg2, int arg3, String arg4, int arg5, doubleW arg6, double[] arg7, int arg9, double[] arg10, int arg12, int[] arg13, int[] arg15, double[] arg17, double[] arg19, int arg21, intW arg22);

		/**
	 * No documentation was available when generating this method.
	 * 
	 * @param arg1
	 * @param arg2
	 * @param arg4
	 * @param arg6
	 * @param arg7
	 */
	public void dsconv(int arg1, double[] arg2, double[] arg4, double arg6, intW arg7) {
		org.netlib.arpack.Dsconv.dsconv(arg1, arg2, 0, arg4, 0, arg6, arg7);
	}

		/**
	 * No documentation was available when generating this method.
	 * 
	 * @param arg1
	 * @param arg2
	 * @param arg3
	 * @param arg5
	 * @param arg6
	 * @param arg8
	 * @param arg10
	 * @param arg12
	 */
	public void dseigt(double arg1, int arg2, double[] arg3, int arg5, double[] arg6, double[] arg8, double[] arg10, intW arg12) {
		org.netlib.arpack.Dseigt.dseigt(arg1, arg2, arg3, 0, arg5, arg6, 0, arg8, 0, arg10, 0, arg12);
	}

		/**
	 * No documentation was available when generating this method.
	 * 
	 * @param arg1
	 * @param arg2
	 * @param arg3
	 * @param arg4
	 * @param arg6
	 * @param arg7
	 * @param arg9
	 */
	public void dsesrt(String arg1, boolean arg2, int arg3, double[] arg4, int arg6, double[] arg7, int arg9) {
		org.netlib.arpack.Dsesrt.dsesrt(arg1, arg2, arg3, arg4, 0, arg6, arg7, 0, arg9);
	}

	/**
	 * No documentation was available when generating this method.
	 * 
	 * @param arg1
	 * @param arg2
	 * @param arg3
	 * @param arg5
	 * @param arg7
	 * @param arg9
	 * @param arg10
	 * @param arg11
	 * @param arg12
	 * @param arg13
	 * @param arg14
	 * @param arg15
	 * @param arg16
	 * @param arg18
	 * @param arg19
	 * @param arg21
	 * @param arg22
	 * @param arg24
	 * @param arg26
	 * @param arg28
	 * @param arg30
	 * @param arg31
	 */
	public abstract void dseupd(boolean arg1, String arg2, boolean[] arg3, double[] arg5, double[] arg7, int arg9, double arg10, String arg11, int arg12, String arg13, intW arg14, double arg15, double[] arg16, int arg18, double[] arg19, int arg21, int[] arg22, int[] arg24, double[] arg26, double[] arg28, int arg30, intW arg31);

		/**
	 * No documentation was available when generating this method.
	 * 
	 * @param arg1
	 * @param arg2
	 * @param arg3
	 * @param arg4
	 * @param arg5
	 * @param arg7
	 * @param arg9
	 */
	public void dsgets(int arg1, String arg2, intW arg3, intW arg4, double[] arg5, double[] arg7, double[] arg9) {
		org.netlib.arpack.Dsgets.dsgets(arg1, arg2, arg3, arg4, arg5, 0, arg7, 0, arg9, 0);
	}

		/**
	 * No documentation was available when generating this method.
	 * 
	 * @param arg1
	 * @param arg2
	 * @param arg3
	 * @param arg4
	 * @param arg6
	 * @param arg8
	 */
	public void dsortc(String arg1, boolean arg2, int arg3, double[] arg4, double[] arg6, double[] arg8) {
		org.netlib.arpack.Dsortc.dsortc(arg1, arg2, arg3, arg4, 0, arg6, 0, arg8, 0);
	}

		/**
	 * No documentation was available when generating this method.
	 * 
	 * @param arg1
	 * @param arg2
	 * @param arg3
	 * @param arg4
	 * @param arg6
	 */
	public void dsortr(String arg1, boolean arg2, int arg3, double[] arg4, double[] arg6) {
		org.netlib.arpack.Dsortr.dsortr(arg1, arg2, arg3, arg4, 0, arg6, 0);
	}

		/**
	 * No documentation was available when generating this method.
	 * 
	 */
	public void dstatn() {
		org.netlib.arpack.Dstatn.dstatn();
	}

		/**
	 * No documentation was available when generating this method.
	 * 
	 */
	public void dstats() {
		org.netlib.arpack.Dstats.dstats();
	}

		/**
	 * No documentation was available when generating this method.
	 * 
	 * @param arg1
	 * @param arg2
	 * @param arg4
	 * @param arg6
	 * @param arg8
	 * @param arg10
	 */
	public void dstqrb(int arg1, double[] arg2, double[] arg4, double[] arg6, double[] arg8, intW arg10) {
		org.netlib.arpack.Dstqrb.dstqrb(arg1, arg2, 0, arg4, 0, arg6, 0, arg8, 0, arg10);
	}

		/**
	 * No documentation was available when generating this method.
	 * 
	 * @param arg1
	 * @param arg2
	 * @param arg3
	 * @param arg4
	 * @param arg5
	 * @param arg6
	 * @param arg7
	 * @param arg9
	 * @param arg10
	 * @param arg12
	 * @param arg13
	 * @param arg15
	 * @param arg17
	 */
	public void sgetv0(intW arg1, String arg2, int arg3, boolean arg4, int arg5, int arg6, float[] arg7, int arg9, float[] arg10, floatW arg12, int[] arg13, float[] arg15, intW arg17) {
		org.netlib.arpack.Sgetv0.sgetv0(arg1, arg2, arg3, arg4, arg5, arg6, arg7, 0, arg9, arg10, 0, arg12, arg13, 0, arg15, 0, arg17);
	}

		/**
	 * No documentation was available when generating this method.
	 * 
	 * @param arg1
	 * @param arg2
	 * @param arg3
	 * @param arg4
	 * @param arg5
	 * @param arg7
	 * @param arg8
	 * @param arg10
	 * @param arg12
	 * @param arg14
	 */
	public void slaqrb(boolean arg1, int arg2, int arg3, int arg4, float[] arg5, int arg7, float[] arg8, float[] arg10, float[] arg12, intW arg14) {
		org.netlib.arpack.Slaqrb.slaqrb(arg1, arg2, arg3, arg4, arg5, 0, arg7, arg8, 0, arg10, 0, arg12, 0, arg14);
	}

		/**
	 * No documentation was available when generating this method.
	 * 
	 * @param arg1
	 * @param arg2
	 * @param arg3
	 * @param arg4
	 * @param arg5
	 * @param arg6
	 * @param arg7
	 * @param arg9
	 * @param arg10
	 * @param arg12
	 * @param arg13
	 * @param arg15
	 * @param arg16
	 * @param arg18
	 * @param arg20
	 */
	public void snaitr(intW arg1, String arg2, int arg3, int arg4, int arg5, int arg6, float[] arg7, floatW arg9, float[] arg10, int arg12, float[] arg13, int arg15, int[] arg16, float[] arg18, intW arg20) {
		org.netlib.arpack.Snaitr.snaitr(arg1, arg2, arg3, arg4, arg5, arg6, arg7, 0, arg9, arg10, 0, arg12, arg13, 0, arg15, arg16, 0, arg18, 0, arg20);
	}

		/**
	 * No documentation was available when generating this method.
	 * 
	 * @param arg1
	 * @param arg2
	 * @param arg3
	 * @param arg4
	 * @param arg6
	 * @param arg8
	 * @param arg10
	 * @param arg11
	 * @param arg13
	 * @param arg14
	 * @param arg16
	 * @param arg18
	 * @param arg19
	 * @param arg21
	 */
	public void snapps(int arg1, intW arg2, int arg3, float[] arg4, float[] arg6, float[] arg8, int arg10, float[] arg11, int arg13, float[] arg14, float[] arg16, int arg18, float[] arg19, float[] arg21) {
		org.netlib.arpack.Snapps.snapps(arg1, arg2, arg3, arg4, 0, arg6, 0, arg8, 0, arg10, arg11, 0, arg13, arg14, 0, arg16, 0, arg18, arg19, 0, arg21, 0);
	}

		/**
	 * No documentation was available when generating this method.
	 * 
	 * @param arg1
	 * @param arg2
	 * @param arg3
	 * @param arg4
	 * @param arg5
	 * @param arg6
	 * @param arg7
	 * @param arg8
	 * @param arg10
	 * @param arg11
	 * @param arg12
	 * @param arg13
	 * @param arg14
	 * @param arg16
	 * @param arg17
	 * @param arg19
	 * @param arg20
	 * @param arg22
	 * @param arg24
	 * @param arg26
	 * @param arg28
	 * @param arg29
	 * @param arg31
	 * @param arg33
	 * @param arg35
	 */
	public void snaup2(intW arg1, String arg2, int arg3, String arg4, intW arg5, intW arg6, float arg7, float[] arg8, int arg10, int arg11, int arg12, intW arg13, float[] arg14, int arg16, float[] arg17, int arg19, float[] arg20, float[] arg22, float[] arg24, float[] arg26, int arg28, float[] arg29, int[] arg31, float[] arg33, intW arg35) {
		org.netlib.arpack.Snaup2.snaup2(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, 0, arg10, arg11, arg12, arg13, arg14, 0, arg16, arg17, 0, arg19, arg20, 0, arg22, 0, arg24, 0, arg26, 0, arg28, arg29, 0, arg31, 0, arg33, 0, arg35);
	}

	/**
	 * No documentation was available when generating this method.
	 * 
	 * @param arg1
	 * @param arg2
	 * @param arg3
	 * @param arg4
	 * @param arg5
	 * @param arg6
	 * @param arg7
	 * @param arg9
	 * @param arg10
	 * @param arg12
	 * @param arg13
	 * @param arg15
	 * @param arg17
	 * @param arg19
	 * @param arg21
	 * @param arg22
	 */
	public abstract void snaupd(intW arg1, String arg2, int arg3, String arg4, int arg5, floatW arg6, float[] arg7, int arg9, float[] arg10, int arg12, int[] arg13, int[] arg15, float[] arg17, float[] arg19, int arg21, intW arg22);

		/**
	 * No documentation was available when generating this method.
	 * 
	 * @param arg1
	 * @param arg2
	 * @param arg4
	 * @param arg6
	 * @param arg8
	 * @param arg9
	 */
	public void snconv(int arg1, float[] arg2, float[] arg4, float[] arg6, float arg8, intW arg9) {
		org.netlib.arpack.Snconv.snconv(arg1, arg2, 0, arg4, 0, arg6, 0, arg8, arg9);
	}

		/**
	 * No documentation was available when generating this method.
	 * 
	 * @param arg1
	 * @param arg2
	 * @param arg3
	 * @param arg5
	 * @param arg6
	 * @param arg8
	 * @param arg10
	 * @param arg12
	 * @param arg14
	 * @param arg15
	 * @param arg17
	 */
	public void sneigh(float arg1, intW arg2, float[] arg3, int arg5, float[] arg6, float[] arg8, float[] arg10, float[] arg12, int arg14, float[] arg15, intW arg17) {
		org.netlib.arpack.Sneigh.sneigh(arg1, arg2, arg3, 0, arg5, arg6, 0, arg8, 0, arg10, 0, arg12, 0, arg14, arg15, 0, arg17);
	}

	/**
	 * No documentation was available when generating this method.
	 * 
	 * @param arg1
	 * @param arg2
	 * @param arg3
	 * @param arg5
	 * @param arg7
	 * @param arg9
	 * @param arg11
	 * @param arg12
	 * @param arg13
	 * @param arg14
	 * @param arg16
	 * @param arg17
	 * @param arg18
	 * @param arg19
	 * @param arg20
	 * @param arg21
	 * @param arg23
	 * @param arg24
	 * @param arg26
	 * @param arg27
	 * @param arg29
	 * @param arg31
	 * @param arg33
	 * @param arg35
	 * @param arg36
	 */
	public abstract void sneupd(boolean arg1, String arg2, boolean[] arg3, float[] arg5, float[] arg7, float[] arg9, int arg11, float arg12, float arg13, float[] arg14, String arg16, int arg17, String arg18, intW arg19, float arg20, float[] arg21, int arg23, float[] arg24, int arg26, int[] arg27, int[] arg29, float[] arg31, float[] arg33, int arg35, intW arg36);

		/**
	 * No documentation was available when generating this method.
	 * 
	 * @param arg1
	 * @param arg2
	 * @param arg3
	 * @param arg4
	 * @param arg5
	 * @param arg7
	 * @param arg9
	 * @param arg11
	 * @param arg13
	 */
	public void sngets(int arg1, String arg2, intW arg3, intW arg4, float[] arg5, float[] arg7, float[] arg9, float[] arg11, float[] arg13) {
		org.netlib.arpack.Sngets.sngets(arg1, arg2, arg3, arg4, arg5, 0, arg7, 0, arg9, 0, arg11, 0, arg13, 0);
	}

		/**
	 * No documentation was available when generating this method.
	 * 
	 * @param arg1
	 * @param arg2
	 * @param arg3
	 * @param arg4
	 * @param arg5
	 * @param arg6
	 * @param arg7
	 * @param arg9
	 * @param arg10
	 * @param arg12
	 * @param arg13
	 * @param arg15
	 * @param arg16
	 * @param arg18
	 * @param arg20
	 */
	public void ssaitr(intW arg1, String arg2, int arg3, int arg4, int arg5, int arg6, float[] arg7, floatW arg9, float[] arg10, int arg12, float[] arg13, int arg15, int[] arg16, float[] arg18, intW arg20) {
		org.netlib.arpack.Ssaitr.ssaitr(arg1, arg2, arg3, arg4, arg5, arg6, arg7, 0, arg9, arg10, 0, arg12, arg13, 0, arg15, arg16, 0, arg18, 0, arg20);
	}

		/**
	 * No documentation was available when generating this method.
	 * 
	 * @param arg1
	 * @param arg2
	 * @param arg3
	 * @param arg4
	 * @param arg6
	 * @param arg8
	 * @param arg9
	 * @param arg11
	 * @param arg12
	 * @param arg14
	 * @param arg16
	 * @param arg17
	 */
	public void ssapps(int arg1, int arg2, int arg3, float[] arg4, float[] arg6, int arg8, float[] arg9, int arg11, float[] arg12, float[] arg14, int arg16, float[] arg17) {
		org.netlib.arpack.Ssapps.ssapps(arg1, arg2, arg3, arg4, 0, arg6, 0, arg8, arg9, 0, arg11, arg12, 0, arg14, 0, arg16, arg17, 0);
	}

		/**
	 * No documentation was available when generating this method.
	 * 
	 * @param arg1
	 * @param arg2
	 * @param arg3
	 * @param arg4
	 * @param arg5
	 * @param arg6
	 * @param arg7
	 * @param arg8
	 * @param arg10
	 * @param arg11
	 * @param arg12
	 * @param arg13
	 * @param arg14
	 * @param arg16
	 * @param arg17
	 * @param arg19
	 * @param arg20
	 * @param arg22
	 * @param arg24
	 * @param arg26
	 * @param arg27
	 * @param arg29
	 * @param arg31
	 * @param arg33
	 */
	public void ssaup2(intW arg1, String arg2, int arg3, String arg4, intW arg5, intW arg6, float arg7, float[] arg8, int arg10, int arg11, int arg12, intW arg13, float[] arg14, int arg16, float[] arg17, int arg19, float[] arg20, float[] arg22, float[] arg24, int arg26, float[] arg27, int[] arg29, float[] arg31, intW arg33) {
		org.netlib.arpack.Ssaup2.ssaup2(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, 0, arg10, arg11, arg12, arg13, arg14, 0, arg16, arg17, 0, arg19, arg20, 0, arg22, 0, arg24, 0, arg26, arg27, 0, arg29, 0, arg31, 0, arg33);
	}

	/**
	 * No documentation was available when generating this method.
	 * 
	 * @param arg1
	 * @param arg2
	 * @param arg3
	 * @param arg4
	 * @param arg5
	 * @param arg6
	 * @param arg7
	 * @param arg9
	 * @param arg10
	 * @param arg12
	 * @param arg13
	 * @param arg15
	 * @param arg17
	 * @param arg19
	 * @param arg21
	 * @param arg22
	 */
	public abstract void ssaupd(intW arg1, String arg2, int arg3, String arg4, int arg5, floatW arg6, float[] arg7, int arg9, float[] arg10, int arg12, int[] arg13, int[] arg15, float[] arg17, float[] arg19, int arg21, intW arg22);

		/**
	 * No documentation was available when generating this method.
	 * 
	 * @param arg1
	 * @param arg2
	 * @param arg4
	 * @param arg6
	 * @param arg7
	 */
	public void ssconv(int arg1, float[] arg2, float[] arg4, float arg6, intW arg7) {
		org.netlib.arpack.Ssconv.ssconv(arg1, arg2, 0, arg4, 0, arg6, arg7);
	}

		/**
	 * No documentation was available when generating this method.
	 * 
	 * @param arg1
	 * @param arg2
	 * @param arg3
	 * @param arg5
	 * @param arg6
	 * @param arg8
	 * @param arg10
	 * @param arg12
	 */
	public void sseigt(float arg1, int arg2, float[] arg3, int arg5, float[] arg6, float[] arg8, float[] arg10, intW arg12) {
		org.netlib.arpack.Sseigt.sseigt(arg1, arg2, arg3, 0, arg5, arg6, 0, arg8, 0, arg10, 0, arg12);
	}

		/**
	 * No documentation was available when generating this method.
	 * 
	 * @param arg1
	 * @param arg2
	 * @param arg3
	 * @param arg4
	 * @param arg6
	 * @param arg7
	 * @param arg9
	 */
	public void ssesrt(String arg1, boolean arg2, int arg3, float[] arg4, int arg6, float[] arg7, int arg9) {
		org.netlib.arpack.Ssesrt.ssesrt(arg1, arg2, arg3, arg4, 0, arg6, arg7, 0, arg9);
	}

	/**
	 * No documentation was available when generating this method.
	 * 
	 * @param arg1
	 * @param arg2
	 * @param arg3
	 * @param arg5
	 * @param arg7
	 * @param arg9
	 * @param arg10
	 * @param arg11
	 * @param arg12
	 * @param arg13
	 * @param arg14
	 * @param arg15
	 * @param arg16
	 * @param arg18
	 * @param arg19
	 * @param arg21
	 * @param arg22
	 * @param arg24
	 * @param arg26
	 * @param arg28
	 * @param arg30
	 * @param arg31
	 */
	public abstract void sseupd(boolean arg1, String arg2, boolean[] arg3, float[] arg5, float[] arg7, int arg9, float arg10, String arg11, int arg12, String arg13, intW arg14, float arg15, float[] arg16, int arg18, float[] arg19, int arg21, int[] arg22, int[] arg24, float[] arg26, float[] arg28, int arg30, intW arg31);

		/**
	 * No documentation was available when generating this method.
	 * 
	 * @param arg1
	 * @param arg2
	 * @param arg3
	 * @param arg4
	 * @param arg5
	 * @param arg7
	 * @param arg9
	 */
	public void ssgets(int arg1, String arg2, intW arg3, intW arg4, float[] arg5, float[] arg7, float[] arg9) {
		org.netlib.arpack.Ssgets.ssgets(arg1, arg2, arg3, arg4, arg5, 0, arg7, 0, arg9, 0);
	}

		/**
	 * No documentation was available when generating this method.
	 * 
	 * @param arg1
	 * @param arg2
	 * @param arg3
	 * @param arg4
	 * @param arg6
	 * @param arg8
	 */
	public void ssortc(String arg1, boolean arg2, int arg3, float[] arg4, float[] arg6, float[] arg8) {
		org.netlib.arpack.Ssortc.ssortc(arg1, arg2, arg3, arg4, 0, arg6, 0, arg8, 0);
	}

		/**
	 * No documentation was available when generating this method.
	 * 
	 * @param arg1
	 * @param arg2
	 * @param arg3
	 * @param arg4
	 * @param arg6
	 */
	public void ssortr(String arg1, boolean arg2, int arg3, float[] arg4, float[] arg6) {
		org.netlib.arpack.Ssortr.ssortr(arg1, arg2, arg3, arg4, 0, arg6, 0);
	}

		/**
	 * No documentation was available when generating this method.
	 * 
	 */
	public void sstatn() {
		org.netlib.arpack.Sstatn.sstatn();
	}

		/**
	 * No documentation was available when generating this method.
	 * 
	 */
	public void sstats() {
		org.netlib.arpack.Sstats.sstats();
	}

		/**
	 * No documentation was available when generating this method.
	 * 
	 * @param arg1
	 * @param arg2
	 * @param arg4
	 * @param arg6
	 * @param arg8
	 * @param arg10
	 */
	public void sstqrb(int arg1, float[] arg2, float[] arg4, float[] arg6, float[] arg8, intW arg10) {
		org.netlib.arpack.Sstqrb.sstqrb(arg1, arg2, 0, arg4, 0, arg6, 0, arg8, 0, arg10);
	}

}
