/* XtMalloc Wrapper to unsetenv LD_PRELOAD.
 *
 * We should unsetenv LD_PRELOAD for child processes. 
 * I assume that Netscape calls XtMalloc() once at least by startup.
 * And This XtMalloc code is based on XFree86's one.
 */

#include <stdio.h>

char *XtMalloc(unsigned size)
{
    char *ptr;
    static init_flag = 1;

    if (init_flag) {
	unsetenv("LD_PRELOAD");
	init_flag = 0;
    }

/* XXX: I don't know follows well */
#if defined (MALLOC_0_RETURNS_NULL) && defined(XTMALLOC_BC)
    /* preserve this (broken) behavior until everyone fixes their apps */
    if (!size) size = 1;
#endif

    if ((ptr = (char*)malloc(size)) == NULL) {
        fprintf(stderr, "malloc failed.\n");
    }

    return ptr;
}

