// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/base_natives/common_olv2/object_generic.cpp,v 1.21 2002/01/10 10:06:51 xli18 Exp $
//

#ifdef OBJECT_LOCK_V2
#include "platform.h"
#include <assert.h>
#include <iostream.h>

#include "orp_types.h"
#include "exceptions.h"

#include "thread_generic_olv2.h"
#include "object_generic_olv2.h"
#include "mon_enter_exit_olv2.h"
///////////////////////////////////////////////////////////////////////////////
///////////////
/////////////// WARNING: start_of_object_busybit_critical_zone() MUST BE  THE FIRST
///////////////
/////////////// PROCEDURE IN java_lang_Object.cpp
///////////////
///////////////////////////////////////////////////////////////////////////////

void start_of_object_generic_busybit_critical_zone()
{
////////////// THIS MUST BE THE FIRST PROCEDURE IN java_lang_Object.cpp
////////////// SEE in_busybit_critical_zone() for details
}

mon_wait_fields mon_wait_array[MAX_ORP_THREADS];

#ifdef _DEBUG
// loose, approximate counts, full of race conditions
int max_notifyAll = 0;
int max_recursion = 0;
int total_sleep_timeouts = 0;
int total_sleep_interrupts = 0;
int total_wait_timeouts = 0;
int total_wait_interrupts = 0;
int total_illegal_mon_state_exceptions = 0;
int iterations_per_thread[MAX_ORP_THREADS];
int max_block_on_mon_enter_loops = 0;
#endif

void notify_internal (Java_java_lang_Object *p_obj, Boolean all)
{
#ifdef LAZY_LOCK 
	if(! bMultithreaded)
		return;
#endif

    uint16 current_stack_key = get_stack_pointer() >> STACK_KEY_SHIFT;
 
	assert(p_obj->vt->clss->p_vtable->clss->p_vtable);

    if (STACK_KEY(p_obj) != current_stack_key)
    {
        throw_java_exception("java/lang/IllegalMonitorStateException");
        assert(0);
    }

#ifdef _DEBUG
    int notifyAll_count = 0;
#endif

    DWORD stat;
    int xx;

    for (xx = 1; xx < next_thread_index; xx++)
    {
        if (mon_wait_array[xx].p_obj == p_obj)
        {
#ifdef CONCURRENCY_ANALYSIS
            uint64 time = readTimeStampCounter();
#ifdef ORP_POSIX
            fprintf(f_concur, "OBJECT_NOTIFY( thread_id = %d, notified_tid = %d, time = %llu )\n", 
                p_TLS_orpthread->thread_index, mon_wait_array[xx].p_thr->thread_index, time );
#else
            fprintf(f_concur, "OBJECT_NOTIFY( thread_id = %d, notified_tid = %d, time = %I64u )\n", 
                p_TLS_orpthread->thread_index, mon_wait_array[xx].p_thr->thread_index, time );
#endif //#ifdef ORP_POSIX
#endif //#ifdef CONCURRENCY_ANALYSIS
            stat = SetEvent(mon_wait_array[xx].p_thr->event_handle_notify_or_interrupt);

            assert(stat);

            if (!all)
                return;

#ifdef _DEBUG
            notifyAll_count++;
            if (notifyAll_count > max_notifyAll)
                max_notifyAll = notifyAll_count;
#endif
        }
    }
}


void java_lang_Object_notify (Java_java_lang_Object *p_obj)
{
	//printf("******************************%x, to Notify %d\n", p_obj, p_TLS_orpthread->thread_handle);

    assert(get_thread_ptr()->gc_enabled_status == disabled);
    notify_internal(p_obj, false);

	//printf("******************************%x, finish Notify %d\n", p_obj, p_TLS_orpthread->thread_handle);

}


void java_lang_Object_notifyAll (Java_java_lang_Object *p_obj)
{
    assert(get_thread_ptr()->gc_enabled_status == disabled);
    notify_internal(p_obj, true);
}


void java_lang_Object_wait(Java_java_lang_Object *p_obj, int64 msec)
{
    uint16 current_stack_key = get_stack_pointer() >> STACK_KEY_SHIFT;
    
	assert(p_obj->vt->clss->p_vtable->clss->p_vtable);

    if ( STACK_KEY( p_obj) != current_stack_key)
    {
        throw_java_exception("java/lang/IllegalMonitorStateException");
        return;
    }

    setup_gc_frame_context();

    volatile Java_java_lang_Object *p_obj_volatile = p_obj;

    GC_Frame gcf1;
    orp_push_gc_frame(&gcf1, (void *)&p_obj_volatile, sizeof(void *) );
    orp_enable_gc();   //vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv
    p_thread_lock->_lock_enum(); //with gc_enabled ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
    //orp_disable_gc();
    orp_pop_gc_frame(&gcf1);  

    ORP_thread *p_thr = get_thread_ptr();

    DWORD stat;
    
    assert(p_thr->app_status == thread_is_running);

    assert(mon_wait_array[p_thr->thread_index].p_obj == 0);
    mon_wait_array[p_thr->thread_index].p_obj = (struct Java_java_lang_Object *)p_obj_volatile;

    assert(p_thr->notify_recursion_count == 0);

    p_thr->notify_recursion_count = RECURSION(p_obj_volatile);
    RECURSION(p_obj_volatile) = 0;  // leave the recursion at zero for the next lock owner

#ifdef _DEBUG
    if (p_thr->notify_recursion_count > max_recursion)
        max_recursion = p_thr->notify_recursion_count;
#endif

    // toss stale interrupts and notifies
    stat = ResetEvent(p_thr->event_handle_notify_or_interrupt);

    STACK_KEY( p_obj_volatile) = 0; // finally, give up the lock

	p_thr->app_status = thread_is_waiting;
    p_thr->gc_status = gc_at_safepoint;
    p_thr->which_trap = x_java_wait;

    find_an_interested_thread((struct Java_java_lang_Object *)p_obj_volatile);

    // by convention, *only* mon_enter_array and mon_wait_array will be enumerated to the GC
    // thus reload from mon_wait_array[] after the waitforsingleobject returns
    // volatile Java_java_lang_Object *volatile_p_obj = (Java_java_lang_Object *)p_obj;

	//orp_push_gc_frame(&gcf1, (void *)&p_obj, sizeof(volatile void *));
    //orp_enable_gc();
    p_thread_lock->_unlock_enum(); //with gc_enabled vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv

#ifdef CONCURRENCY_ANALYSIS
        uint64 start = readTimeStampCounter();
#endif //#ifdef CONCURRENCY_ANALYSIS

	//printf("******************************to Wait %d\n", p_TLS_orpthread->thread_handle);

    if (msec == 0)
    {
        stat = WaitForSingleObject(p_thr->event_handle_notify_or_interrupt, INFINITE);
        assert(stat == WAIT_OBJECT_0);
    }
    else
    {
        stat = WaitForSingleObject(p_thr->event_handle_notify_or_interrupt, (int)msec); 
        assert( (stat == WAIT_OBJECT_0) || (stat == WAIT_TIMEOUT) );
    }
	//printf("******************************finish Wait %d\n", p_TLS_orpthread->thread_handle);

    p_thread_lock->_lock_enum(); //with gc_enabled ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
    orp_disable_gc();    //xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx

#ifdef _DEBUG
    if (stat == WAIT_OBJECT_0)
        total_wait_interrupts++;
    else
        total_wait_timeouts++;
#endif

    
    //GC may have moved the object sitting in mon_wait_array[], thus reload it
	assert( mon_wait_array[p_thr->thread_index].p_obj->vt->clss->p_vtable->clss->p_vtable );
    p_obj_volatile = mon_wait_array[p_thr->thread_index].p_obj;
    
    mon_wait_array[p_thr->thread_index].p_obj = 0;
    //bugbug --> do we need to do a p4 sfence here?

    assert(p_thr->app_status == thread_is_waiting);
    p_thr->app_status = thread_is_running;
    p_thr->gc_status = zero;
    p_thr->which_trap = x_nothing;

    // now we need to re-acquire the object lock
    // since block_on_mon_enter() can block, reload p_obj
    p_thread_lock->_unlock_enum(); //with gc_disabled xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx

#ifdef CONCURRENCY_ANALYSIS
        uint64 end = readTimeStampCounter();
#ifdef ORP_POSIX
        fprintf(f_concur, 
            "OBJECT_WAIT_START( object_id = %d, waiting_tid = %d, time = %llu )\n",
            generic_hashcode((Java_java_lang_Object *)p_obj_volatile),
            p_thr->thread_index, start );
        fprintf(f_concur, 
            "OBJECT_WAIT_END( object_id = %d, waiting_tid = %d, time = %llu )\n",
            generic_hashcode((Java_java_lang_Object *)p_obj_volatile),
            p_thr->thread_index, end );
#else
        fprintf(f_concur, 
            "OBJECT_WAIT_START( object_id = %d, waiting_tid = %d, time = %I64u )\n",
            generic_hashcode((Java_java_lang_Object *)p_obj_volatile),
            p_thr->thread_index, start );
        fprintf(f_concur, 
            "OBJECT_WAIT_END( object_id = %d, waiting_tid = %d, time = %I64u )\n",
            generic_hashcode((Java_java_lang_Object *)p_obj_volatile),
            p_thr->thread_index, end );
#endif //#ifdef ORP_POSIX
#endif //#ifdef CONCURRENCY_ANALYSIS

    p_obj_volatile = block_on_mon_enter( (Java_java_lang_Object *)p_obj_volatile);
   	assert(p_obj_volatile->vt->clss->p_vtable->clss->p_vtable);
	assert( STACK_KEY(p_obj_volatile) == current_stack_key );

    // re-install the recursion count
    assert( RECURSION(p_obj_volatile) == 0);
    RECURSION(p_obj_volatile) = p_thr->notify_recursion_count;

    p_thr->notify_recursion_count = 0;

    if ( (stat == WAIT_OBJECT_0) && (p_thr->interrupt_a_waiting_thread == true) )
    {
        p_thr->interrupt_a_waiting_thread = false;
        throw_java_exception("java/lang/InterruptedException");
    }

    // ready to return to java code 
}


long generic_hashcode(Java_java_lang_Object * p_obj)
{
    if ( HASH_CONTENTION(p_obj) & HASH_MASK)
        return HASH_CONTENTION(p_obj) & HASH_MASK;

    set_hash_bits(p_obj);

    if ( HASH_CONTENTION(p_obj) & HASH_MASK)
        return HASH_CONTENTION(p_obj) & HASH_MASK;    
    
    assert(0);  // the above simply has to work
    return 0xff;
}


///////////////////////////////////////////////////////////////////////////////
///////////////
/////////////// WARNING: end_of_object_busybit_critical_zone() MUST BE  THE LAST
///////////////
/////////////// PROCEDURE IN java_lang_Object.cpp
///////////////
///////////////////////////////////////////////////////////////////////////////

void end_of_object_gerneric_busybit_critical_zone()
{
////////////// THIS MUST BE THE LAST PROCEDURE IN java_lang_Object.cpp
////////////// SEE in_busybit_critical_zone() for details
}

#endif //#ifdef OBJECT_LOCK_V2 
