// Copyright (C)  2001 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/base_natives/gnu_classpath/java_lang_reflect_Array.cpp,v 1.3 2001/08/17 03:09:32 gwu2 Exp $
//

#ifdef ORP_POSIX
#include <unistd.h>
#endif

#include "platform.h"
#include <assert.h>
#include "object_layout.h"
#include "orp_utils.h"
#include "exceptions.h"
#include "jni.h"

#include <sys/types.h>
#include <sys/stat.h>

#ifdef ORP_NT
#include <io.h>
#endif

#include "native_utils.h"
#include "jni_direct.h"
#include "jni_utils.h"
#include "object_layout.h"

#include <fcntl.h>

#ifdef ORP_NT
#include <direct.h>
#endif

#include <errno.h>
#include "VMSystem.h"
#include "java_lang_reflect_Array.h"
#include "environment.h"


/*
 * Class:     java_lang_reflect_Array
 * Method:    createObjectArray
 * Signature: (Ljava/lang/Class;I)Ljava/lang/Object;
 */
JNIEXPORT jobject JNICALL Java_java_lang_reflect_Array_createObjectArray
  (JNIEnv *jenv, jclass c_this, jclass clazz, jint dim)
{
	return NewObjectArray(jenv, dim, clazz, 0);
}

/*
 * Class:     java_lang_reflect_Array
 * Method:    getLength
 * Signature: (Ljava/lang/Object;)I
 */
JNIEXPORT jint JNICALL Java_java_lang_reflect_Array_getLength
  (JNIEnv *jenv, jclass c_this, jobject array)
{
	return GetArrayLength(jenv, (jobjectArray)array); 
}
