// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/common/class_loader/Mem_Manager.cpp,v 1.1.1.1 2001/07/23 07:25:38 xli18 Exp $
//


#include "platform.h"
#include <iostream.h>
#include <stdio.h>
#include "Mem_Manager.h"

#ifdef USE_IA64_JIT
#define BITS_TO_CLEAR 7
#else
#define BITS_TO_CLEAR 3 
#endif


Mem_Manager::Mem_Manager(unsigned initial_estimate)
{
	_arena = NULL;
    _bytes_allocated = 0;
	_alloc_arena(initial_estimate);
}

Mem_Manager::~Mem_Manager()
{
	_free_arenas(_arena);
    //cout << "~Mem_Manager: " << _bytes_allocated << " bytes were allocated." << endl;
}

void Mem_Manager::_alloc_arena(unsigned size)
{
	_arena = alloc_arena(_arena,size);
}

void Mem_Manager::_free_arenas(Arena *a)
{
	if (a == NULL)
		return;
	_free_arenas(a->next_arena);
	free_arena(a);
}

void *Mem_Manager::alloc(unsigned size)
{
	if (size == 0)
		return NULL;

    // _arena=>next_byte is guaranteed to be aligned initially
    // to maintain the above, make sure that size is rounded up 
    // if necessary

    assert(((unsigned)_arena->next_byte & BITS_TO_CLEAR) == 0);
    size = (size + BITS_TO_CLEAR) & ~BITS_TO_CLEAR;
    _bytes_allocated += size;

    if (_arena->next_byte + size > _arena->last_byte) {
		// allocate another arena

        if (size < default_arena_size) 
			_alloc_arena(default_arena_size);
		else
			_alloc_arena(size);
	}
    
    // already aligned 
    char *mem = _arena->next_byte;
    // still aligned
    _arena->next_byte += size;
	return (void*)mem;
}

