// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/common/gc_v2/include/gc_perf.h,v 1.3 2001/11/20 20:09:22 rlhudson Exp $
//


//
// Counters and routines related to GC performance monitoring.
//



#ifndef _gc_perf_h_
#define _gc_perf_h_

 
#include "gc_for_orp.h"
 
#include "object_layout.h"
#include "gc_header.h"

#ifdef CLASS_DEMOGRAPHICS
void dump_class_demographics();
void record_for_class_demographics(VTable *p_vt);
void delete_for_class_demographics(VTable *p_vt);
#endif

//
// The performance frequency of the high-resolution performance counter.
//
extern LARGE_INTEGER performance_frequency;

//
// The instant the GC subsystem started initialization.
//
extern LARGE_INTEGER gc_system_init_time;

//
// The instant the most recent stop-the-world collection started.
//
extern LARGE_INTEGER gc_start_time;

//
// The time spent in the most recent stop-the-world collection.
//
extern unsigned long gc_time;

//
// The cumulative time spent in all past stop-the-world collections.
//
extern unsigned long cumulative_gc_time;

//
// The best case gc pause time so far.
//
extern unsigned long best_case_gc_time;

//
// The worst case gc pause time so far.
//
extern unsigned long worst_case_gc_time;

//
// The instant the most recent minor collection started.
//
extern LARGE_INTEGER minor_collection_start_time;

//
// The time spent in the most recent minor collection.
//
extern unsigned long minor_collection_time;

//
// The cumulative time spent in minor collections so far.
//
extern unsigned long cumulative_minor_collection_time;

//
// The worst case minor collection time.
//
extern unsigned long worst_case_minor_collection_time;

//
// The best case minor collection time.
//
extern unsigned long best_case_minor_collection_time;

//
// The instant the most recent incremental mature collection started.
//
extern LARGE_INTEGER incremental_collection_start_time;

//
// The time spent in the most recent mature incremental collection.
//
extern unsigned long incremental_collection_time;

//
// The cumulative time spent in incremental collections so far.
//
extern unsigned long cumulative_incremental_collection_time;

//
// The worst case incremental collection time.
//
extern unsigned long worst_case_incremental_collection_time;

//
// The best case incremental collection time.
//
extern unsigned long best_case_incremental_collection_time;

//
// The instant the most recent request to the ORP for 
// enumerating live references was made.
//
extern LARGE_INTEGER live_reference_enumeration_start_time;

//
// The time taken to do the most recent enumeration of live refs.
//
extern unsigned long enumeration_time;

void initialize_gc_performance_counters();


inline unsigned long get_time_milliseconds(LARGE_INTEGER StartCounter,
							        LARGE_INTEGER EndCounter)
{
#ifdef ORP_POSIX
    unsigned long runtime     
		= (unsigned long)((double)
               ( (EndCounter.tv.tv_sec - StartCounter.tv.tv_sec)*1000000.0 +
                  EndCounter.tv.tv_usec - StartCounter.tv.tv_usec 
               )/1000.0  );
              
#else
    unsigned long runtime     
		= (unsigned long)((double)(EndCounter.QuadPart -
                           StartCounter.QuadPart) /
                           (double)performance_frequency.QuadPart
						   * 1000.0);
#endif

	return runtime;
}


inline unsigned long get_time_microseconds(LARGE_INTEGER StartCounter,
							        LARGE_INTEGER EndCounter)
{
#ifdef ORP_POSIX
    unsigned long runtime     
		= (unsigned long)((double)
                 (EndCounter.tv.tv_sec - StartCounter.tv.tv_sec)*1000000.0 +
                 EndCounter.tv.tv_usec - StartCounter.tv.tv_usec 
                );
              
#else
    unsigned long runtime     
		= (unsigned long)((double)(EndCounter.QuadPart -
                           StartCounter.QuadPart) /
                           (double)performance_frequency.QuadPart
						   * 1000000.0);
#endif

	return runtime;
}

#endif // _gc_perf_h_

// end file gc\include\gc_perf.h

