// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/os/linux/os_wrapper.cpp,v 1.3 2001/11/12 06:32:36 xli18 Exp $
//

#include <stdio.h>
#include <signal.h>
#include <pthread.h>
#include <unistd.h>
#include <sys/time.h>
#include <asm/sigcontext.h>
#include <assert.h>
#include <asm/errno.h>
#include <malloc.h>

#include "platform.h"

#ifndef __SMP__
#error
-- recompile with -D__SMP__
#endif

#ifndef _REENTRANT
#error
-- recompile with -D_REENTRANT
#endif

#ifndef __SIGRTMIN
#else
#if __SIGRTMAX - __SIGRTMIN >= 3
// good, this will work. java dbg, also orp can use SIGUSR1, SIGUSR2
#else
#error
-- must be using an old version of pthreads
-- which uses SIGUSR1, SIGUSR2 (which conflicts with the java app debugger and orp)
#endif
#endif


pthread_mutexattr_t mutex_attr;
pthread_mutexattr_t mutex_attr_for_cond_wait;

pthread_key_t thread_local_storage_key;

pthread_condattr_t cond_attr;

pthread_attr_t pthread_attr;

void init_linux_thread_system()
{
    mutex_attr.__mutexkind = PTHREAD_MUTEX_RECURSIVE_NP;
    mutex_attr_for_cond_wait.__mutexkind = 0;

    int stat = pthread_condattr_init(&cond_attr);
    assert(stat == 0);

    pthread_attr_init(&pthread_attr);
    pthread_attr_setdetachstate(&pthread_attr, PTHREAD_CREATE_DETACHED);

    pthread_key_create(&thread_local_storage_key, 0);
}

VOID InitializeCriticalSection(LPCRITICAL_SECTION lpCriticalSection)
{
    assert(lpCriticalSection);
    int xx = pthread_mutex_init(lpCriticalSection, &mutex_attr);
    assert(xx == 0);
}


VOID DeleteCriticalSection(LPCRITICAL_SECTION lpCriticalSection)
{
    assert(lpCriticalSection);
}


VOID LeaveCriticalSection(LPCRITICAL_SECTION lpCriticalSection)
{
    assert(lpCriticalSection);
    int xx = pthread_mutex_unlock(lpCriticalSection);
    assert(xx == 0);
}


BOOL TryEnterCriticalSection(LPCRITICAL_SECTION lpCriticalSection)
{
    assert(lpCriticalSection);
    int xx = pthread_mutex_trylock(lpCriticalSection);

    if (xx == 0)
        return 1;

    if (xx == EBUSY)
        return 0;

    assert(0);  
}


BOOL EnterCriticalSection(LPCRITICAL_SECTION lpCriticalSection)
{
    assert(lpCriticalSection);
    int xx = pthread_mutex_lock(lpCriticalSection);

    if (xx == 0)
        return 1;

    return 0;
}


unsigned long _beginthreadex( void *security,  unsigned stacksize, unsigned(__stdcall *start_address)(void *), void *arglist, unsigned initflag, unsigned *thrdaddr)
{ 
  pthread_t tid = 0;

  void *(*sa)(void *) = ( void *(*)(void *) )start_address;
  int stat = pthread_create(&tid, &pthread_attr, sa, arglist); 
  assert(stat == 0);
  //printf("tid = 0x%x\n", tid);
  *thrdaddr = 0;
  return tid;
}


HANDLE CreateEvent(int *security, unsigned int man_reset_flag, unsigned int initial_state_flag, char * p_name)
{
   event_wrapper *p_event = (event_wrapper *)malloc( sizeof(struct event_wrapper) );

    int stat = pthread_mutex_init(&p_event->mutex, &mutex_attr_for_cond_wait);
    assert(stat == 0);
  
    stat = pthread_cond_init(&p_event->cond, &cond_attr);
    assert(stat == 0);

    p_event->man_reset_flag = man_reset_flag;
    p_event->state = initial_state_flag;

    return (HANDLE)p_event;
}


BOOL ResetEvent(HANDLE hEvent)
{
  event_wrapper *p_event = (event_wrapper *)hEvent;

  assert(p_event);
  int xx = pthread_mutex_lock(&p_event->mutex);
  assert(xx == 0);
  p_event->state = 0;
  xx = pthread_mutex_unlock(&p_event->mutex);
  assert(xx == 0);
  return 1;
}


BOOL SetEvent(HANDLE hEvent)
{
  event_wrapper *p_event = (event_wrapper *)hEvent;

  assert(p_event);
  int stat = pthread_mutex_lock(&p_event->mutex);
  assert(stat == 0);

  p_event->state = 1;

  stat = pthread_cond_broadcast(&p_event->cond);
  assert(stat == 0);

  stat = pthread_mutex_unlock(&p_event->mutex);
  assert(stat == 0);
  return 1;
}


DWORD WaitForSingleObject(HANDLE hHandle, DWORD dwMillisec)
{
  if (dwMillisec < 10)
    return WAIT_TIMEOUT;

  struct timespec ts;
  ts.tv_sec  = dwMillisec/1000;
  ts.tv_nsec = (dwMillisec%1000)*1000000;

  struct timeval tv;
  int stat = gettimeofday(&tv, 0);
  assert(stat == 0);
  //printf("tv_sec = %d, tv_usec = %d\n", tv.tv_sec, tv.tv_usec);

  ts.tv_sec  += tv.tv_sec;
  ts.tv_nsec += tv.tv_usec*1000;

  event_wrapper *p_event = (event_wrapper *)hHandle;

  assert(p_event);
  stat = pthread_mutex_lock(&p_event->mutex);
  assert(stat == 0);
  
  int wait_status = WAIT_OBJECT_0;

  while (1)
    {
      if (p_event->state != 0)
          break;
      
      wait_status = pthread_cond_timedwait(&p_event->cond, 
					   &p_event->mutex,
					   &ts );
      if (wait_status == ETIMEDOUT)
	break;
      if (wait_status == 0)
	break;

    }

  if (p_event->man_reset_flag == 0)
      p_event->state = 0;

  stat = pthread_mutex_unlock(&p_event->mutex);
  assert(stat == 0);

  if (wait_status == ETIMEDOUT)
    return WAIT_TIMEOUT;

  if (wait_status == 0)
      return WAIT_OBJECT_0;

  return WAIT_TIMEOUT;  
}


void Sleep(DWORD msec)
{
  if (msec < 1000){
    sched_yield();
    return;
  }

  unsigned int zz = msec/1000;

  sleep(zz);

}


void SleepEx(DWORD time, bool bb)
{
  Sleep(time);
}
/*
void *get_specific00( ){
        register void *specific;
        asm volatile(
                "movl %%gs:%c1, %%eax\n\t"
                "movl (%%eax), %0"
                :"=r"(specific)
                :"i"(300)
        );
        return specific;
}
*/
