/*
**  prefs_dialog.h -- Defines for the prefs dialog
**
**	This file is subject to the terms and conditions of the GNU General Public
**	License.  See the file COPYING in the main directory of this archive
**	for more details.
**
*/

/* Some dialog definitions */

enum { /* Prefs Dialog */
	kPrefsOkButton = 1,
	kPrefsCancelButton,
	kPrefsKernelTab,
	kPrefsOptionsTab,
	kPrefsSerialTab,
	
	kPrefsBackground1,
	kPrefsBackground2,
	kPrefsKernelTabLabel,
	kPrefsOptionsTabLabel,
	kPrefsSerialTabLabel,
	
	kPrefsNext
};

#define PREFS_NUM_ITEMS		10
#define PREFS_DLOG_ID 		130

enum { /* Kernel Dialog */
	kKernelKernelButton = kPrefsNext,
	kKernelRamdiskButton,
	kKernelRamdiskCheckbox,
	
	kKernelKernelFileLabel,
	kKernelThisSpaceForRentLabel,
	kKernelKernelTab,
	kKernelKernelTabLabel
};

#define KERNEL_NUM_ITEMS	7
#define KERNEL_DITL_ID		1001

enum { /* Options Dialog */
	kOptionsAutoboot = kPrefsNext,
	kOptionsBootIntoLinux,
	kOptionsDontBoot,
	kOptionsColorByPenguin,
	
	kOptionsDelayBoot,
	kOptionsDelayAmount,
	
	kOptionsAppendLogCheckbox,
	kOptionsLogFileCheckbox,
	kOptionsLogFileButton,
	
	kOptionsDebugBootInfo,
	kOptionsDebugSegmentInfo,
	kOptionsDebugMachineSpecs,
	kOptionsDebugBootstrap,
	
	kOptionsCommandline,
	
	kOptionsDebugLabel,
	kOptionsCommandlineLabel,
	kOptionsOptionsTab,
	kOptionsOptionsTabLabel
};

#define OPTIONS_NUM_ITEMS	18
#define OPTIONS_DITL_ID		1002

enum { /* Serial Dialog */
	kSerialDisableAtalkCheckbox = kPrefsNext,
	
	kSerialModemPortCheckbox,
	kSerialPrinterPortCheckbox,
	
	kSerialModemPortSpeedMenu,
	kSerialModemDataSizeMenu,
	kSerialModemParityMenu,
	kSerialModemStopBitsMenu,
	
	kSerialPrinterPortSpeedMenu,
	kSerialPrinterDataSizeMenu,
	kSerialPrinterParityMenu,
	kSerialPrinterStopBitsMenu,
	
	kSerialConfigurePortsLabel,
	
	kSerialSerialTab,
	kSerialSerialTabLabel
};

#define SERIAL_NUM_ITEMS	14
#define SERIAL_DITL_ID		1003

enum { /* Serial Speed Menu */
	kSpeedMenu150 = 1,
	kSpeedMenu300,
	kSpeedMenu600,
	kSpeedMenu1200,
	kSpeedMenu1800,
	kSpeedMenu2400,
	kSpeedMenu3600,
	kSpeedMenu4800,
	kSpeedMenu7200,
	kSpeedMenu9600,
	kSpeedMenu14400,
	kSpeedMenu19200,
	kSpeedMenu28800,
	kSpeedMenu38400,
	kSpeedMenu57600,
	kSpeedMenu115k,
	kSpeedMenu230k
};

enum { /* Data Size Menu */
	kSizeMenu8bit = 1,
	kSizeMenu7bit,
	kSizeMenu6bit,
	kSizeMenu5bit
};

enum { /* Parity Menu */
	kParityMenuNone = 1,
	kParityMenuOdd,
	kParityMenuEven
};

enum { /* Stop Bits Menu */
	kStopMenu10Stop = 1,
	kStopMenu15Stop,
	kStopMenu20Stop
};

