/*
 *	MMU030.h
 */

#define 	BIT(n)		(1<<(n))
/*	b = big bit,
	s = small bit
	
	BITS(31,23) creates a bit mask of the upper 8 bits
 */
#define		BITS(b,s)	( ((b) == 31)	? ( 0xFFFFFFFF ) - (BIT((s))-1)	\
						: (BIT((b)+1)-1) - (BIT((s))-1) )
#define 	xBITS(val,b,s)	(((val) & BITS((b),(s))) >> (s))

#define		NIBBLE(n)	(BITS((n)*4+3,(n)*4+0))
#define		xNIBBLE(val,n)	(((val) & NIBBLE(n)) >> ((n)*4))



#define kEightBytePD		1
#define kFourBytePD 		0

extern u32	gps, gis, gtia, gtib, gtic, gtid;

void		get030CRP (void *root);
void		get030SRP (void *root);
void		get030TCReg (u32 *tc);
void		get030TT0 (void *tt);
void		get030TT1 (void *tt);

void		emit030TCinfo (u32 tc);
void		emit030RPinfo (u32 *rootPtr);
void		emit030TTinfo (char *str, u32 tt);
void		emit030Translation (u32 logAddr, u32 phys, u32 len, u32 attr);
