#include "RSGGobi.h"
#include "GGobiAPI.h"

#ifndef G_OS_WIN32
#include <sys/time.h>
#include "R_ext/eventloop.h"
#endif

#include "RUtils.h"


#ifdef G_OS_WIN32
#if 0
#ifdef ERROR
#undef ERROR
#endif
#endif
#if 0
#include <gdk/gdkwin32.h>
#endif
#include <process.h>
static void __cdecl GtkEventThreadHandler(void *display);
void R_gtk_handle_events();
extern void (*R_gtkdo)();
extern void (*R_tcldo)();
#else
#include <gdk/gdkx.h>
#endif

/*
#ifdef ERROR
#undef ERROR
#endif
*/
#include "R_ext/RS.h"

#include "gtkUtils.h"


USER_OBJECT_ RS_INTERNAL_GGOBI(getDisplay)(gboolean , displayd *display, ggobid *gg);
USER_OBJECT_ RS_INTERNAL_GGOBI(getPlotDescription)(splotd *splot, displayd *display, ggobid *gg);
USER_OBJECT_ RS_INTERNAL_GGOBI(getDisplayPlots)(displayd *display, ggobid *gg);

extern void RS_GGOBI(event_handle)(void *data);
void RS_GGOBI(limited_event_handle)(gint max);

USER_OBJECT_ RS_INTERNAL_GGOBI(describeGGobi)(ggobid *gg, gboolean full);
USER_OBJECT_ RS_INTERNAL_GGOBI(describeDatasets)(ggobid *gg, gboolean full);
USER_OBJECT_ RS_INTERNAL_GGOBI(describeDataset)(datad *d, gboolean full);

USER_OBJECT_ RS_GGOBI(getDisplays)(USER_OBJECT_ rsFull, USER_OBJECT_ ggobiId);
USER_OBJECT_ RS_INTERNAL_GGOBI(getDisplays)(gboolean full, ggobid *gg);


/*
  Create a ggobi instance and initialize.
 */
USER_OBJECT_
RS_GGOBI(init)(USER_OBJECT_ args, USER_OBJECT_ createInstance)
{
 gint which, i;
 char **c_args;
 int n = GET_LENGTH(args);
 USER_OBJECT_ ans;

   c_args = g_malloc(sizeof(char *)*n);
   for(i = 0; i < n ; i++) {
     c_args[i] = CHAR_DEREF(STRING_ELT(args, i));
   }
   if(LOGICAL_DATA(createInstance)[0]) {
     which = GGOBI(main)(n, c_args, false);
     ans = RS_ggobiInstance(ggobi_get(which-1), which);
   } else {
      ggobiInit(&n, &c_args);
      ans = NEW_LOGICAL(1);
      LOGICAL_DATA(ans)[0] = TRUE;
   }
   g_free(c_args);

#ifdef G_OS_WIN32 
   /*XXX R_tcldo = R_gtk_handle_events; */
#else
  addInputHandler (R_InputHandlers, ConnectionNumber(gdk_display),
                   RS_GGOBI(event_handle), -1);
#endif

  gdk_flush();    

  return(ans);
}


/**
 Get a reference to a specific GGobi instance by indexing
 into the list of active/alive GGobis.
 */
USER_OBJECT_
RS_GGOBI(getGGobi)(USER_OBJECT_ which)
{
 USER_OBJECT_ ans;
 ggobid *gg;
 int n = GET_LENGTH(which), i, index;
 PROTECT(ans =  NEW_LIST(n));
 
 for(i = 0; i < n ; i ++) {
  index = INTEGER_DATA(which)[i];
  gg = ggobi_get(index-1);
  if(gg) {
    SET_VECTOR_ELT(ans,i, RS_ggobiInstance(gg, index));
  }
 }

 UNPROTECT(1);
 return(ans);
}

USER_OBJECT_
RS_GGOBI(describeGGobis)(USER_OBJECT_ ggobis, USER_OBJECT_ sfull)
{
 int n = GET_LENGTH(ggobis), i;
 ggobid *gg;
 gboolean full = LOGICAL_DATA(sfull)[0];
 USER_OBJECT_ ans;

 PROTECT(ans = NEW_LIST(n));

 for(i = 0; i < n; i++) {
   gg = GetGGobi(VECTOR_ELT(ggobis, i));
   if(gg)
     SET_VECTOR_ELT(ans, i, RS_INTERNAL_GGOBI(describeGGobi)(gg, full));
 }

 UNPROTECT(1);
 return(ans);
}

USER_OBJECT_
RS_INTERNAL_GGOBI(describeGGobi)(ggobid *gg, gboolean full)
{
 USER_OBJECT_ ans, names, klass;

 PROTECT(ans = NEW_LIST(3));
 PROTECT(names = NEW_CHARACTER(3));

  SET_STRING_ELT(names, 0, COPY_TO_USER_STRING("datasets"));
  SET_STRING_ELT(names, 1, COPY_TO_USER_STRING("displays"));
  SET_STRING_ELT(names, 2, COPY_TO_USER_STRING("ggobi"));
 SET_NAMES(ans, names);

 SET_VECTOR_ELT(ans, 0, RS_INTERNAL_GGOBI(describeDatasets)(gg, full));
 SET_VECTOR_ELT(ans, 1, RS_INTERNAL_GGOBI(getDisplays)(true, gg));
 SET_VECTOR_ELT(ans, 2, RS_ggobiInstance(gg, -1));

 PROTECT(klass = NEW_CHARACTER(1));
  SET_STRING_ELT(klass, 0, COPY_TO_USER_STRING("ggobiDescription"));
 SET_CLASS(ans, klass);

 UNPROTECT(3);

 return(ans);
}

USER_OBJECT_
RS_INTERNAL_GGOBI(describeDatasets)(ggobid *gg, gboolean full)
{
 int n, i;
 USER_OBJECT_ ans, names;

  n = g_slist_length(gg->d);
  PROTECT(ans = NEW_LIST(n));
  PROTECT(names = NEW_CHARACTER(n));
  for(i = 0; i < n ; i++) {
    datad *d = (datad *) g_slist_nth_data(gg->d, i);
    SET_VECTOR_ELT(ans, i, RS_INTERNAL_GGOBI(describeDataset)(d, full));
    SET_STRING_ELT(names, i, COPY_TO_USER_STRING(d->name));
  }
  SET_NAMES(ans, names);
  UNPROTECT(2);

 return(ans); 
}


/*
 Creates an S list object  giving a representation
 of a dataset in ggobi. It includes slots for
  Name and file name, 
  dimensions,
  mode
  variable names,
  auxillary files.
*/
USER_OBJECT_
RS_INTERNAL_GGOBI(describeDataset)(datad *d, gboolean full)
{
 USER_OBJECT_ ans, tmp, names, tmp1;


 PROTECT(ans = NEW_LIST(5));
 PROTECT(names = NEW_LIST(5));

 SET_VECTOR_ELT(ans, 0, tmp = NEW_CHARACTER(2));
  SET_STRING_ELT(tmp, 0, COPY_TO_USER_STRING(d->name));
  SET_STRING_ELT(tmp, 1, COPY_TO_USER_STRING(d->input->fileName));
  SET_STRING_ELT(names, 0, COPY_TO_USER_STRING("name"));

 SET_VECTOR_ELT(ans, 1, tmp = NEW_INTEGER(2));
  INTEGER_DATA(tmp)[0] = GGOBI(nrecords)(d);
  INTEGER_DATA(tmp)[1] = GGOBI(ncols)(d);
  SET_STRING_ELT(names, 1, COPY_TO_USER_STRING("dims"));

 SET_VECTOR_ELT(ans, 2, tmp = NEW_INTEGER(1));
  INTEGER_DATA(tmp)[0] = d->input->mode;
  SET_NAMES(tmp, tmp1 = NEW_CHARACTER(1));
#if 0
/*XXX */
  SET_STRING_ELT(tmp1, 0, COPY_TO_USER_STRING(GGOBI(getDataModeDescription)(INTEGER_DATA(tmp)[0])));
#endif
  SET_NAMES(tmp, tmp1);
  SET_STRING_ELT(names, 2, COPY_TO_USER_STRING("format"));

  SET_VECTOR_ELT(ans, 3, RS_INTERNAL_GGOBI(getVariableNames)(d));
  SET_STRING_ELT(names, 3, COPY_TO_USER_STRING("variables"));
  SET_NAMES(ans, names);

 {
   int n, i;
 
   n = g_slist_length(d->input->extensions);
  SET_VECTOR_ELT(ans, 4, tmp = NEW_CHARACTER(n));
  for(i = 0; i < n ; i++) {
   gchar *str;
   str = (gchar *) g_slist_nth_data(d->input->extensions, i);
   SET_STRING_ELT(tmp, i, COPY_TO_USER_STRING(str));
  }

  SET_STRING_ELT(names, 4, COPY_TO_USER_STRING("auxillaryFiles"));
 }

  SET_NAMES(ans, names);

 UNPROTECT(2);
 return(ans);
}



/*
   Handle all the events currently in the queue,
   until there are no more.
   This is called by the R event loop when input is 
   detected on the file descriptor associated with the 
   X connection.

   This needs a little more finessing to make it
   work correctly.
 */
void
RS_GGOBI(event_handle)(void *data)
{
  RS_GGOBI(limited_event_handle)(-1);
}

/**
  Process max number of events and then terminate.
 */
void
RS_GGOBI(limited_event_handle)(gint max) {
  gint ctr = 0;
  gboolean block =  (max > -1);

  while(g_main_iteration(block)) {
    /*  fprintf(stderr, "Event %d\n",ctr); */
    /*
    gtk_main_iteration_do(false);
    */
    /*   g_main_iteration((ctr < max));  */
    ctr++;
    block = max > -1 && ctr < max;

    if(max > -1 && ctr >= max)
       return;
  }
}


USER_OBJECT_
RS_GGOBI(getDataModes)()
{
  USER_OBJECT_ ans, names;
  const gchar * const *modeNames;
  int n, i;

  modeNames = GGOBI(getDataModeNames)(&n);
  PROTECT(ans = NEW_INTEGER(n));
  PROTECT(names = NEW_CHARACTER(n));
  for(i = 0; i < n; i++) {
    INTEGER_DATA(ans)[i] = i;
    SET_STRING_ELT(names, i, COPY_TO_USER_STRING(modeNames[i]));
  }

  if(modeNames)
     g_free((gchar *)modeNames);

  SET_NAMES(ans, names);
  UNPROTECT(2);
  return(ans);
}


/*
   Initializes the GGobi session using the specified
   file as the source of the data.
 */
USER_OBJECT_
RS_GGOBI(setFile)(USER_OBJECT_ fileName, USER_OBJECT_ smode, USER_OBJECT_ add, USER_OBJECT_ gobiId)
{
 DataMode mode;
 ggobid *gg = GetGGobi(gobiId);
 USER_OBJECT_ ans = NEW_INTEGER(1);
 gchar *modeName;

 if(IS_CHARACTER(smode))
	 modeName = CHAR_DEREF(STRING_ELT(smode, 0));
 else if(IS_INTEGER(smode)) {
  mode = INTEGER_DATA(smode)[0];
  if(mode < 0)
    mode = unknown_data;
 }

  /*if(fileset_read_init(CHAR_DEREF(STRING_ELT(fileName, 0)), mode, gg)) {*/
  if(fileset_read_init(CHAR_DEREF(STRING_ELT(fileName, 0)), modeName, NULL, gg)) {
    INTEGER_DATA(ans)[0] = g_slist_length(gg->d)-1;
    display_menu_build(gg);
  } else
    INTEGER_DATA(ans)[0] = -1;


  /*
  gtk_widget_show_all (varpanel); 
gdk_flush();
  RS_GGOBI(limited_event_handle)(10);
  */

 return(ans);
}

/*
  A version of the event handling mechanism that one can call 
  directly from R to prohibit the prompt from 
  Note that selecting the Quit menu item causes this loop
  to exit and the routine to return control to the R event
  handling. Hence the prompt will return.

  Added for debugging purposes currently, but may have
  some value under special circumstances.
 */
void
RS_GGOBI(blockingLoop)(void)
{
  gtk_main();
}


/*
 Returns a list whose length is equal to the number of datasets
 within the specified ggobi.
 */
USER_OBJECT_
RS_GGOBI(getFileNames)(USER_OBJECT_ auxillary, USER_OBJECT_ ggobiId)
{
  ggobid *gg = GetGGobi(ggobiId); 
  int n, i;
  datad *d;
  gboolean aux = LOGICAL_DATA(auxillary)[0];

  USER_OBJECT_ ans = NULL_USER_OBJECT, tmp;
  if(gg) {
    n = g_slist_length(gg->d);
    PROTECT(ans = NEW_LIST(n));
    for(i = 0; i < n; i++) {
      int len;
      d = (datad *) g_slist_nth_data(gg->d, i);
      len = 1;
      if(aux && d->input->extensions) {
        len += g_slist_length(d->input->extensions);
      }
      SET_VECTOR_ELT(ans, i, tmp = NEW_CHARACTER(len));
      SET_STRING_ELT(tmp, 0, COPY_TO_USER_STRING(d->input->fileName));
      if(len > 1) {
        int j;
        for(j = 0; j < len-1; j++) {
         gchar *el = (gchar *)g_slist_nth_data(d->input->extensions, j);
         SET_STRING_ELT(tmp, j+1, COPY_TO_USER_STRING(el));
        }
      }
    }
    UNPROTECT(1);
  }
  return(ans);
}

/*
  Get the file name associated with the specified datad
  or, if this is null, of all the datad objects in the specified
  ggobid.
 */

USER_OBJECT_
RS_GGOBI(getFileName)(USER_OBJECT_ datasetId, USER_OBJECT_ ggobiId, USER_OBJECT_ auxillary)
{
  ggobid *gg = GetGGobi(ggobiId);
  USER_OBJECT_ ans;
  datad *d;

  if(GET_LENGTH(datasetId)) {
    d = resolveDatad(datasetId, ggobiId, &gg);
  } else {
    
  }

  ans = NEW_CHARACTER(1);

  PROTECT(ans);

  if(GGOBI(getFileName)(gg))
    SET_STRING_ELT(ans, 0, COPY_TO_USER_STRING(GGOBI(getFileName)(gg)));

  UNPROTECT(1);

  return(ans);
}



USER_OBJECT_
RS_GGOBI(getViewTypes)()
{
  USER_OBJECT_ ans, names;
  gint n = -1, i;
  const gint *symbols = GGOBI(getViewTypeIndices)(&n);
  const gchar *const * plotNames = GGOBI(getViewTypes)(&n);

  PROTECT(ans = NEW_INTEGER(n));
  PROTECT(names = NEW_CHARACTER(n));

  for (i = 0; i < n; i++) {
    INTEGER_DATA(ans)[i] = symbols[i];
    SET_STRING_ELT(names, i, COPY_TO_USER_STRING(plotNames[i]));
  }

  SET_NAMES(ans, names);

  UNPROTECT(2);

  return (ans);
}


USER_OBJECT_
RS_GGOBI(getCurrentDisplayType)(USER_OBJECT_ ggobiId)
{
  ggobid *gg = GetGGobi(ggobiId);
  USER_OBJECT_ ans;
  const gchar *name = GGOBI(getCurrentDisplayType)(gg);

  PROTECT(ans = NEW_CHARACTER(1));
  SET_STRING_ELT(ans, 0, COPY_TO_USER_STRING(name));

  UNPROTECT(1);

  return(ans);
}


USER_OBJECT_
RS_GGOBI(getDisplayOptions)(USER_OBJECT_ which, USER_OBJECT_ ggobiId)
{
  ggobid *gg = GetGGobi(ggobiId);
  USER_OBJECT_ ans, names;
  gint NumOptions = 8;
  gint displayNum;
  DisplayOptions *options;

  if(gg == NULL)
    return(NULL_USER_OBJECT);
  
  displayNum = INTEGER_DATA(which)[0];

  options = GGOBI(getDisplayOptions)(displayNum, gg);
  if (options == NULL) {
    char error_buf[400];
    sprintf(error_buf,
	    "No display numbered %d", displayNum);
    Rf_error(error_buf);  
  }

  PROTECT(ans = NEW_LOGICAL(NumOptions));
  PROTECT(names = NEW_CHARACTER(NumOptions));

  LOGICAL_DATA(ans)[DOPT_POINTS] = options->points_show_p;
  SET_STRING_ELT(names, DOPT_POINTS, COPY_TO_USER_STRING("Show points"));
  LOGICAL_DATA(ans)[DOPT_AXES] = options->axes_show_p;
  SET_STRING_ELT(names, DOPT_AXES,  COPY_TO_USER_STRING("Show axes"));

  LOGICAL_DATA(ans)[DOPT_AXESLAB] = options->axes_label_p;
  SET_STRING_ELT(names, DOPT_AXESLAB,
    COPY_TO_USER_STRING("Show tour axes"));
  LOGICAL_DATA(ans)[DOPT_AXESVALS] = options->axes_values_p;
  SET_STRING_ELT(names, DOPT_AXESVALS,
    COPY_TO_USER_STRING("Show axes labels"));

  LOGICAL_DATA(ans)[DOPT_EDGES_U] = options->edges_undirected_show_p;
  SET_STRING_ELT(names, DOPT_EDGES_U, COPY_TO_USER_STRING("Undirected edges"));
  LOGICAL_DATA(ans)[DOPT_EDGES_A] = options->edges_arrowheads_show_p;
  SET_STRING_ELT(names, DOPT_EDGES_A, COPY_TO_USER_STRING("Arrowheads"));
  LOGICAL_DATA(ans)[DOPT_EDGES_D] = options->edges_directed_show_p;
  SET_STRING_ELT(names, DOPT_EDGES_D, COPY_TO_USER_STRING("Directed edges"));

  LOGICAL_DATA(ans)[DOPT_WHISKERS] = options->whiskers_show_p;
  SET_STRING_ELT(names, DOPT_WHISKERS,
    COPY_TO_USER_STRING("Show whiskers"));

/* unused
  LOGICAL_DATA(ans)[5] = options->missings_show_p;
  SET_STRING_ELT(names, 5, COPY_TO_USER_STRING("Missing Values"));
  LOGICAL_DATA(ans)[8] = options->axes_center_p;
  SET_STRING_ELT(names, 8,  COPY_TO_USER_STRING("Center axes"));
  LOGICAL_DATA(ans)[9] = options->double_buffer_p;
  SET_STRING_ELT(names, 9,  COPY_TO_USER_STRING("Double buffer"));
  LOGICAL_DATA(ans)[10] = options->link_p;
  SET_STRING_ELT(names, 10,  COPY_TO_USER_STRING("Link"));
*/

  SET_NAMES(ans, names);

  UNPROTECT(2);

  return(ans);
}


/*

 */
USER_OBJECT_
RS_GGOBI(setDisplayOptions)(USER_OBJECT_ which, USER_OBJECT_ values,
                              USER_OBJECT_ ggobiId)
{
  ggobid *gg;
  gint displayNum, i;
  DisplayOptions *options;
  int apply = 0;

  if(GET_LENGTH(ggobiId) == 0) {
	  /* XXX */
     options = GGOBI(getDefaultDisplayOptions)();
  } else {
     gg = GetGGobi(ggobiId);
     displayNum = INTEGER_DATA(which)[0];
     options = GGOBI(getDisplayOptions)(displayNum, gg);

     if(options == NULL) {
	     char error_buf[400];
	     sprintf(error_buf,
		     "No display numbered %d", displayNum);
	     Rf_error(error_buf);
     }
     apply = 1;
  }


  if(GET_LENGTH(values) != 8) {
    PROBLEM "Incorrect length %d for options", 
	      GET_LENGTH(values)
    ERROR;
  }

  i = 0;
  options->points_show_p = LOGICAL_DATA(values)[i++];
  options->axes_show_p = LOGICAL_DATA(values)[i++];
  options->axes_label_p = LOGICAL_DATA(values)[i++];
  options->axes_values_p = LOGICAL_DATA(values)[i++];
  options->edges_undirected_show_p = LOGICAL_DATA(values)[i++];
  options->edges_arrowheads_show_p = LOGICAL_DATA(values)[i++];
  options->edges_directed_show_p = LOGICAL_DATA(values)[i++];
  options->whiskers_show_p = LOGICAL_DATA(values)[i++];
/* unused
  options->missings_show_p = LOGICAL_DATA(values)[i++];
  options->axes_center_p = LOGICAL_DATA(values)[i++];
  options->double_buffer_p = LOGICAL_DATA(values)[i++];
  options->link_p = LOGICAL_DATA(values)[i++];
*/

  if(apply) {
     displayd *display = GetDisplay(which, ggobiId, NULL);
     if(display)
      set_display_options(display, gg);
  }

  return (NULL_USER_OBJECT);
}


USER_OBJECT_
RS_GGOBI(getActivePlot)(USER_OBJECT_ ggobiId)
{
  USER_OBJECT_ ans;
  ggobid *gg = GetGGobi(ggobiId);

  PROTECT(ans = NEW_INTEGER(2));

  INTEGER_DATA(ans)[0] = GGOBI(getCurrentDisplayIndex)(gg);
  INTEGER_DATA(ans)[1] = GGOBI(getCurrentPlotIndex)(gg);

  UNPROTECT(1);

  return(ans);
}

/*
  which is a vector length 1 or 2.
  The first element is the displayd object to make active.
  The second argument (if present) identifies the plot that is to be made
  active.
 */
USER_OBJECT_
RS_GGOBI(setActivePlot)(USER_OBJECT_ which, USER_OBJECT_ ggobiId)
{
  ggobid *gg = GetGGobi(ggobiId);
  gint n;
  USER_OBJECT_ ans;

  n = GET_LENGTH(which);

  PROTECT(ans = NEW_LOGICAL(n));

  GGOBI(setCurrentDisplay)(INTEGER_DATA(which)[0], gg);
  LOGICAL_DATA(ans)[0] = 1;

  if (n > 1) {
    displayd *display;
    splotd *sp;
    display = GGOBI(getCurrentDisplay)(gg);
    if (display != NULL)
      sp = GGOBI(getPlot)(display, INTEGER_DATA(which)[1]);

    if (sp) {
      GGOBI(splot_set_current_full)(display, sp, gg);
      LOGICAL_DATA(ans)[1] = 1;
    }
  }
  gdk_flush();
   
  UNPROTECT(1); 
  return (ans);
}


/*
  Get a description of the displays in the specified ggobi.
  This works recursively
 */
USER_OBJECT_
RS_GGOBI(getDisplays)(USER_OBJECT_ rsFull, USER_OBJECT_ ggobiId)
{
  ggobid *gg = GetGGobi(ggobiId);
  gboolean full = LOGICAL_DATA(rsFull)[0];
  return(RS_INTERNAL_GGOBI(getDisplays)(full, gg));
}


USER_OBJECT_
RS_INTERNAL_GGOBI(getDisplays)(gboolean full, ggobid *gg)
{
  USER_OBJECT_ ans; 
  gint n, i;
  GList *dlist;

  n = g_list_length(gg->displays);

  PROTECT(ans = NEW_LIST(n));
  i = 0;
  for (dlist = gg->displays; dlist ; dlist = dlist->next, i++) {
    SET_VECTOR_ELT(ans, i, RS_INTERNAL_GGOBI(getDisplay)(full, (displayd*)
                                             dlist->data, gg));
  }
  UNPROTECT(1);

 return(ans);
}

USER_OBJECT_
RS_GGOBI(getDisplayDataset)(USER_OBJECT_ dpy, USER_OBJECT_ ggobiId)
{
 displayd * display;
 ggobid *gg;
 USER_OBJECT_ ans;

  display = GetDisplay(dpy, ggobiId, &gg);
  if(display)
    ans = RS_datasetInstance(display->d, gg);
  else 
    ans = NULL_USER_OBJECT;
  return(ans);
}

 /*
    Name, type, sub-plots.
    Other things such as which rows of the data were involved in the plots,
    which variables, whether missing values are used, etc. might also be 
    useful here.
  */
USER_OBJECT_
RS_INTERNAL_GGOBI(getDisplay)(gboolean full, displayd *display, ggobid *gg)  
{
  gint numSlots;
  USER_OBJECT_ ans, tmp, names;

  if(full == false) {
#if 0
    PROTECT(ans = NEW_LIST(2));
    PROTECT(names = NEW_CHARACTER(2));
    SET_VECTOR_ELT(ans, 0, RS_displayInstance(display, gg, -1));
    SET_VECTOR_ELT(ans, 1, RS_datasetInstance(display->d, gg));
    SET_STRING_ELT(names, 0, COPY_TO_USER_STRING("display"));
    SET_STRING_ELT(names, 1, COPY_TO_USER_STRING("dataset"));
    SET_NAMES(ans, names);
    PROTECT(tmp = NEW_CHARACTER(1));
    SET_STRING_ELT(tmp, 0, COPY_TO_USER_STRING("ggobiDisplay"));
    SET_CLASS(ans, tmp);

    UNPROTECT(3);
#endif
    ans = RS_displayInstance(display, gg, -1);
    return(ans);
  }

  numSlots = 5;     
  PROTECT(ans = NEW_LIST(numSlots));
  PROTECT(names = NEW_CHARACTER(numSlots));

  SET_VECTOR_ELT(ans, 0, NEW_CHARACTER(1));

  if(GTK_IS_GGOBI_EXTENDED_DISPLAY(display)) {
      GtkGGobiExtendedDisplayClass *klass;
      klass = GTK_GGOBI_EXTENDED_DISPLAY_CLASS(GTK_OBJECT(display)->klass);
      SET_STRING_ELT(VECTOR_ELT(ans, 0), 0,
		     COPY_TO_USER_STRING(klass->titleLabel));
      SET_STRING_ELT(names, 0, COPY_TO_USER_STRING("Name"));
  }

  SET_VECTOR_ELT(ans, 1, R_createGtkType(GTK_OBJECT_TYPE(display), NULL));

  PROTECT(tmp = NEW_CHARACTER(1));
   SET_STRING_ELT(tmp, 0, COPY_TO_USER_STRING(GGOBI(getViewTypeName)(display)));
   SET_NAMES(VECTOR_ELT(ans, 1), tmp);
  UNPROTECT(1);

  SET_STRING_ELT(names, 1, COPY_TO_USER_STRING("Type"));


  SET_VECTOR_ELT(ans, 2, RS_INTERNAL_GGOBI(getDisplayPlots)(display, gg));
  SET_STRING_ELT(names, 2, COPY_TO_USER_STRING("Plots"));

  SET_VECTOR_ELT(ans, 3, RS_datasetInstance(display->d, gg));
  SET_STRING_ELT(names, 3, COPY_TO_USER_STRING("dataset"));


  SET_VECTOR_ELT(ans, 4, tmp = RS_displayInstance(display, gg, -1));
  SET_STRING_ELT(names, 4, COPY_TO_USER_STRING("display"));

  SET_NAMES(ans, names);

  PROTECT(tmp = NEW_CHARACTER(1));
  SET_STRING_ELT(tmp, 0, COPY_TO_USER_STRING("ggobiDisplayDescription"));
  SET_CLASS(ans, tmp);

  UNPROTECT(3);

  return (ans);
}

USER_OBJECT_
RS_displayInstance(displayd *display, ggobid *gg, int which)
{
 USER_OBJECT_ ans, names, tmp;

  PROTECT(ans = NEW_LIST(3));
  PROTECT(names = NEW_CHARACTER(3));

  SET_VECTOR_ELT(ans, 0, tmp = NEW_INTEGER(1));
  if(which < 0) {
    GList *l;
     which = 0;
     l = gg->displays;
    while(l) {
      if(l->data == display) {
        which++;
        break;
      }
      l = l->next;
    }
    if(which >= g_list_length(gg->displays)) {
      which = -1;
    }
  }
  INTEGER_DATA(tmp)[0] = which;
  SET_STRING_ELT(names, 0, COPY_TO_USER_STRING("id"));


#ifdef USE_EXT_PTR
   SET_VECTOR_ELT(ans, 1, R_MakeExternalPtr(display, Rf_install("GtkGGobiDisplay"), NULL_USER_OBJECT));
#else
   SET_VECTOR_ELT(ans, 1, tmp = NEW_NUMERIC(1));
   NUMERIC_DATA(tmp)[0] = (double) (long) display;
#endif
  SET_STRING_ELT(names, 1, COPY_TO_USER_STRING("ref"));
  
  SET_VECTOR_ELT(ans, 2, RS_ggobiInstance(gg, -1));
  SET_STRING_ELT(names, 2, COPY_TO_USER_STRING("ggobi"));

  PROTECT(tmp = NEW_CHARACTER(1));
  SET_STRING_ELT(tmp, 0, COPY_TO_USER_STRING("ggobiDisplay"));
  SET_CLASS(ans, tmp);
  SET_NAMES(ans, names);
  UNPROTECT(3);

  return(ans);
}

USER_OBJECT_ 
RS_GGOBI(closeDisplay)(USER_OBJECT_ ref, USER_OBJECT_ ggobiId)
{
  ggobid *gg = GetGGobi(ggobiId);
  USER_OBJECT_ ans = NEW_LOGICAL(1);
  displayd *display;

  if(!gg)
    return(ans);

  display  = (displayd*) (long) NUMERIC_DATA(ref)[0];
  display = ValidateDisplayRef(display, gg, false);
  if(display) {
    display_free(display, true, gg);
    LOGICAL_DATA(ans)[0] = TRUE;
    gdk_flush();
  } 

  return(ans);
}


USER_OBJECT_
RS_INTERNAL_GGOBI(getDisplayPlots)(displayd *display, ggobid *gg)
{
  gint n, i;
  splotd *splot;
  GList *splist;
  USER_OBJECT_ ans;

  n = g_list_length(display->splots);
  PROTECT(ans = NEW_LIST(n));

  i = 0;
  for(splist = display->splots ; splist != NULL ; splist = splist->next, i++) {
     splot = (splotd*) splist->data;
     SET_VECTOR_ELT(ans, i, RS_INTERNAL_GGOBI(getPlotDescription)(splot, display, gg));
  }

  UNPROTECT(1);

  return(ans);
}

/*
  Variables
 */

USER_OBJECT_
RS_INTERNAL_GGOBI(getPlotDescription)(splotd *splot,
                                        displayd *display, ggobid *gg)
{
 USER_OBJECT_ ans, tmp, names, desc;
 datad *d;

 GtkGGobiExtendedSPlotClass *klass;

 gint i, nvars, *vars;

 d = display->d;

 if(!GTK_IS_GGOBI_EXTENDED_SPLOT(splot)) {
	 PROBLEM "Unrecognized plot type passed to getPlotDescription"
         ERROR;
 }

 PROTECT(desc = NEW_LIST(3));
 PROTECT(names = NEW_CHARACTER(3));

 klass = GTK_GGOBI_EXTENDED_SPLOT_CLASS(GTK_OBJECT(splot)->klass);
 if(!klass || !klass->plotted_vars_get) {
   PROBLEM "type of plot (%s) doesn't support the plotted_vars_get method",
	   gtk_type_name(GTK_OBJECT_TYPE(splot))
   ERROR;
 }

/*XX Use S_alloc or R_alloc here. */
 vars = (gint *) g_malloc(sizeof(gint)*d->ncols);
 nvars = klass->plotted_vars_get(splot, vars, d);

 PROTECT(ans = NEW_INTEGER(nvars));
 PROTECT(tmp = NEW_CHARACTER(nvars)); 
 for(i = 0; i < nvars; i++) {
    vartabled *vt;
    vt = vartable_element_get(vars[i], d);
    INTEGER_DATA(ans)[i] = vars[i] + 1;
    SET_STRING_ELT(tmp, i, COPY_TO_USER_STRING(vt->collab));
 }
 SET_NAMES(ans, tmp);

 g_free(vars);
 
 SET_VECTOR_ELT(desc, 0, ans); 
 SET_STRING_ELT(names, 0, COPY_TO_USER_STRING("variables"));

 SET_VECTOR_ELT(desc, 1, RS_datasetInstance(d, gg)); 
 SET_STRING_ELT(names, 1, COPY_TO_USER_STRING("dataset"));


 SET_VECTOR_ELT(desc, 2, RS_ggobiInstance(gg, -1)); 
 SET_STRING_ELT(names, 2, COPY_TO_USER_STRING("ggobi"));

 SET_NAMES(desc, names);

 UNPROTECT(4);

 return(ans);
}

USER_OBJECT_
RS_GGOBI(getDatasetReference)(USER_OBJECT_ which, USER_OBJECT_ gobiID)
{
  int i, n;
  ggobid *gg  = GetGGobi(gobiID);
  USER_OBJECT_ ans = NULL_USER_OBJECT;
  if(gg == NULL)
    return(ans);

  n = GET_LENGTH(which);
  PROTECT(ans = NEW_LIST(n)); 
  for(i = 0; i < n; i++) {
    int val = INTEGER_DATA(which)[i];
    datad *d = (datad *) g_slist_nth_data(gg->d, val);
    if(d) {
      SET_VECTOR_ELT(ans, i, RS_datasetInstance(d, gg));
    }
  }
  UNPROTECT(1);

  return(ans);
}

USER_OBJECT_
RS_GGOBI(getNumDatasets)(USER_OBJECT_ gobiID)
{
 ggobid *gg  = GetGGobi(gobiID);
 USER_OBJECT_  ans = NEW_INTEGER(1);
    if(gg != NULL)
      INTEGER_DATA(ans)[0] = g_slist_length(gg->d);

   return(ans);
}

USER_OBJECT_
RS_GGOBI(datasetDim)(USER_OBJECT_ data)
{
  USER_OBJECT_ ans = NULL_USER_OBJECT;
  datad *d;
   d = GetDatad(data);
   if(d) {
     ans = NEW_INTEGER(2);
     INTEGER_DATA(ans)[0] = GGOBI(nrecords)(d);
     INTEGER_DATA(ans)[1] = GGOBI(ncols)(d);
   }

  return(ans);
}


/*
  Creates an R/S object which describes a datad object.
 */
USER_OBJECT_
RS_datasetInstance(datad *d, ggobid *gg) 
{
  USER_OBJECT_ ans, data, name;
  gboolean isEdgeData = (d->edge.n > 0);

  PROTECT(ans = NEW_LIST(3));

#ifdef USE_EXT_PTR 
  SET_VECTOR_ELT(ans, 0, data = R_MakeExternalPtr((void *) d, Rf_install("GtkGGobiData"), NULL_USER_OBJECT));  
#else
  SET_VECTOR_ELT(ans, 0, data = NEW_NUMERIC(1));
  NUMERIC_DATA(data)[0] = (double) ((long) d);

  PROTECT(name = NEW_CHARACTER(1));
  if(d->input && d->input->fileName && d->input->fileName[0])
    SET_STRING_ELT(name, 0, COPY_TO_USER_STRING(d->input->fileName));
  SET_NAMES(data, name);
  UNPROTECT(1);
#endif

  SET_VECTOR_ELT(ans, 1, RS_ggobiInstance(gg, -1));
  if(d->name)
      SET_VECTOR_ELT(ans, 2, mkString(d->name));

  PROTECT(name = NEW_CHARACTER(1 + isEdgeData));
  SET_STRING_ELT(name, GET_LENGTH(name)-1, COPY_TO_USER_STRING("ggobiDataset"));
  if(isEdgeData)
      SET_STRING_ELT(name, 0, COPY_TO_USER_STRING("ggobiEdgeDataset"));
  SET_CLASS(ans, name);

     /* Put names on the elements of `ans'. */
  PROTECT(name = NEW_CHARACTER(GET_LENGTH(ans)));
  SET_STRING_ELT(name, 0, COPY_TO_USER_STRING("data"));
  SET_STRING_ELT(name, 1, COPY_TO_USER_STRING("ggobi"));
  SET_STRING_ELT(name, 2, COPY_TO_USER_STRING("name"));
  SET_NAMES(ans, name);

  UNPROTECT(3);

 return(ans);
}

/*
  Represent a ggobi instance by its pointer.
  When dereferencing this, we have to check
  to make certain that it still exists.
  We do this by iterating over the all_ggobis
  array in ggobi.c.
 */
USER_OBJECT_
RS_ggobiInstance(ggobid *gg, int which)
{
 USER_OBJECT_ tmp, klass;
 USER_OBJECT_ ans, names;

   PROTECT(ans = NEW_LIST(2));

      SET_VECTOR_ELT(ans, 0, tmp = NEW_INTEGER(1));
      if(which < 0)
	which = ggobi_getIndex(gg);
      INTEGER_DATA(tmp)[0] = which;

#ifdef USE_EXT_PTR
      SET_VECTOR_ELT(ans, 1, tmp = R_MakeExternalPtr((void *)gg, Rf_install("GtkGGobi"), NULL_USER_OBJECT));
      SET_CLASS(tmp, R_getObjectTypeHierarchy(tmp)); 
#else
      SET_VECTOR_ELT(ans, 1, tmp = NEW_NUMERIC(1));
      NUMERIC_DATA(tmp)[0] = (double) ((long)gg);
#endif

      PROTECT(names = NEW_CHARACTER(2));
      SET_STRING_ELT(names, 0, COPY_TO_USER_STRING("id"));
      SET_STRING_ELT(names, 1, COPY_TO_USER_STRING("ref"));
      SET_NAMES(ans, names);

     UNPROTECT(1);

    PROTECT(klass = NEW_CHARACTER(1));
     SET_STRING_ELT(klass, 0, COPY_TO_USER_STRING("ggobi"));
    SET_CLASS(ans, klass);

  UNPROTECT(2);

 return(ans);
}


USER_OBJECT_
RS_GGOBI(getDescription)(USER_OBJECT_ ggobiId)
{
 ggobid *gg = GetGGobi(ggobiId);
 datad *d;
 gint numSlots = 3, numDatasets, i;
 DataMode mode;
 USER_OBJECT_ ans, names, tmp;
 const gchar *tmpname;

 if(gg == NULL) {
     RS_throwError("Invalid reference to GGobi instance");
 }

 if(!gg->d) {
     return(NULL_USER_OBJECT);
 }


 PROTECT(ans = NEW_LIST(numSlots));
 PROTECT(names = NEW_CHARACTER(numSlots));

 SET_VECTOR_ELT(ans, 0, NEW_CHARACTER(1));
 tmpname = GGOBI(getFileName(gg));
 if (tmpname)
   SET_STRING_ELT(VECTOR_ELT(ans, 0), 0,
     COPY_TO_USER_STRING((gchar *)tmpname));
 SET_STRING_ELT(names, 0, COPY_TO_USER_STRING("Filename"));


 SET_VECTOR_ELT(ans, 1, NEW_INTEGER(1));
 mode = GGOBI(getDataMode)(gg);
 INTEGER_DATA(VECTOR_ELT(ans, 1))[0] = mode;
 PROTECT(tmp = NEW_CHARACTER(1));
#if 0
/*XXX */
  SET_STRING_ELT(tmp, 0,
		 COPY_TO_USER_STRING(GGOBI(getDataModeDescription(mode))));
#endif
 SET_NAMES(VECTOR_ELT(ans, 1), tmp);
 UNPROTECT(1);
 SET_STRING_ELT(names, 1, COPY_TO_USER_STRING("Data mode"));


 numDatasets = g_slist_length (gg->d);

 SET_VECTOR_ELT(ans, 2,  tmp = allocMatrix(INTSXP, numDatasets, 2));
 for(i = 0; i < numDatasets ; i++) {
  d = (datad *) g_slist_nth_data (gg->d, i);
  INTEGER_DATA(tmp)[i] = d->nrows;
  INTEGER_DATA(tmp)[i + numDatasets] = d->ncols;
 }
 SET_STRING_ELT(names, 2, COPY_TO_USER_STRING("Data dimensions"));

 SET_NAMES(ans, names);

 UNPROTECT(2);

 return(ans);
}



USER_OBJECT_
RS_GGOBI(newScatterplot)(USER_OBJECT_ variables, USER_OBJECT_ datasetId, USER_OBJECT_ ggobiId)
{
 ggobid *gg;
 datad *d;
 USER_OBJECT_ ans;
 displayd *display;

  d = resolveDatad(datasetId, ggobiId, &gg);
  if(d == NULL)
    return(NULL_USER_OBJECT);

 display = GGOBI(newScatterplot)(INTEGER_DATA(variables)[0],
                                 INTEGER_DATA(variables)[1],
                                 d, gg);

 ans = RS_displayInstance(display, gg, -1);

 return (ans);
}


USER_OBJECT_
RS_GGOBI(newParcoords)(USER_OBJECT_ variables, USER_OBJECT_ datasetId, USER_OBJECT_ ggobiId)
{
 ggobid *gg;
 datad *d; 
 displayd *display;
 USER_OBJECT_ ans;
 gint *ids, n, i;

  d = resolveDatad(datasetId, ggobiId, &gg);
  if(d == NULL)
    return(NULL_USER_OBJECT);
 
 n  = GET_LENGTH(variables);
/*XXX make certain to free this. */
 ids = g_malloc0(n * sizeof (gint));
 for(i = 0; i < n; i++) 
   ids[i] = INTEGER_DATA(variables)[i];

 display = GGOBI(newParCoords)(ids, n, d, gg);
 ans = RS_displayInstance(display, gg, -1);

 return (ans);
}


/*
  Assumes the variables are specified in

 We want to add a general version that takes
 pairs of variables and generates the corresponding 
 plot for each of these pairs and then adds them to the
 scatter matrix.

 */
USER_OBJECT_
RS_GGOBI(newScatmat)(USER_OBJECT_ x, USER_OBJECT_ y, USER_OBJECT_ datasetId, USER_OBJECT_ ggobiId)
{
  ggobid *gg;
  datad *d;
  displayd *display;
  USER_OBJECT_ ans;
  gint *rowIds, *colIds, nr, nc, i;

  d = resolveDatad(datasetId, ggobiId, &gg);
  if(d == NULL)
    return(NULL_USER_OBJECT);


  nr = GET_LENGTH(x);
  nc = GET_LENGTH(y);
 
  rowIds = g_malloc0 (nr * sizeof (gint));
  colIds = g_malloc0 (nc * sizeof (gint));
  for (i = 0; i < nr; i++) 
    rowIds[i] = INTEGER_DATA(x)[i];

  for (i = 0; i < nc; i++) 
    colIds[i] = INTEGER_DATA(y)[i];

  display = GGOBI(newScatmat)(rowIds, colIds, nr, nc, d, gg);

  ans = RS_displayInstance(display, gg, -1);

  return(ans);
}

USER_OBJECT_
RS_GGOBI(createPlot)(USER_OBJECT_ stype, USER_OBJECT_ svars, USER_OBJECT_ datasetId, USER_OBJECT_ ggobiId)
{
  datad *d;
  ggobid *gg;
  displayd *display;
  GtkType type;
  GtkGGobiExtendedDisplayClass *klass;

  d = resolveDatad(datasetId, ggobiId, &gg);
  if(d == NULL)
    return(NULL_USER_OBJECT);

  type = (GtkType) NUMERIC_DATA(stype)[0];
  klass = GTK_GGOBI_EXTENDED_DISPLAY_CLASS(gtk_type_class(type));

  if(!klass) {
     PROBLEM "Unrecognized display type"
     ERROR;
  }

  if(klass->createWithVars && GET_LENGTH(svars)) {
     gint nvars, *vars, i;
     nvars = GET_LENGTH(svars);
     vars = g_malloc(sizeof(gint)*nvars);
     for(i = 0; i < nvars; i++)
       vars[i] = INTEGER_DATA(svars)[i] - 1;
     display = klass->createWithVars(false, nvars, vars, d, gg);
  } else if(klass->create)
     display = klass->create(false, NULL, d, gg);

  if(!display) {
        PROBLEM "Couldn't create the display"
	ERROR;
  }

  display_add(display, gg);

  return(RS_displayInstance(display, gg, -1));
}

USER_OBJECT_
RS_GGOBI(isValid)(USER_OBJECT_ gobi)
{
 USER_OBJECT_ ans = NEW_LOGICAL(1);
 LOGICAL_DATA(ans)[0] = GetGGobi(gobi) != NULL;
 return(ans);
}

ggobid *
GetGGobi(USER_OBJECT_ id)
{
 if(IS_INTEGER(id)) {
   return(ggobi_get(INTEGER_DATA(id)[0]));
 } else if(R_IS(id, "ggobiDataset")) {
    id = VECTOR_ELT(id, 1);
 } else if(R_IS(id, "GtkGGobi")) {
    ggobid *gg;
    gg = (ggobid *) R_ExternalPtrAddr(id);
    gg = ValidateGGobiRef(gg, false);
    return(gg);
 }

 if(R_IS(id, "ggobi")) {
   ggobid *gg;
   /* Got an object of class ggobi */
#ifdef USE_EXT_PTR
   gg = (ggobid *) R_ExternalPtrAddr(VECTOR_ELT(id, 1));
#else
   gg = (ggobid *) (long) NUMERIC_DATA(VECTOR_ELT(id, 1))[0];
#endif
   gg = ValidateGGobiRef(gg, false);
   if(gg == NULL) {
     return(NULL);
   }

   return(gg);
 }

  return(NULL);
}

datad *
GetDatad(USER_OBJECT_ d)
{
  ggobid *gg;

  if(R_IS(d, "GtkGGobiData")) {
    datad *data;
    data = (datad *) R_ExternalPtrAddr(d);
    if(data) {
      if(!ValidateGGobiRef(data->gg, false))
         return(NULL);
      data = ValidateDatadRef(data, data->gg, false);
    }
    return(data);
  }

  if(!R_IS(d, "ggobiDataset")) {
    return(NULL);
  }
  gg = GetGGobi(VECTOR_ELT(d, 1));
  if(gg) {
    datad *data;
    /*  = (datad *) (long) NUMERIC_DATA(VECTOR_ELT(d, 0))[0]; */
    data = (datad *) R_ExternalPtrAddr(VECTOR_ELT(d, 0));
    if(data) {
      data = ValidateDatadRef(data, gg, false);
    }

    if(data)
      return(data);
  }  
 
  return(NULL);
}

displayd *
GetDisplay(USER_OBJECT_ rdisplay, USER_OBJECT_ ggobiId, ggobid **setgg)
{
 ggobid *gg;
 displayd *display = NULL;

  gg = GetGGobi(ggobiId);
  if(gg == NULL)
    return(NULL);

  if(setgg)
    *setgg = gg;

  if(R_IS(rdisplay, "ggobiDisplay")) {
    rdisplay = VECTOR_ELT(rdisplay, 1);   
  } else if(IS_INTEGER(rdisplay)) {
   display =  GGOBI(getDisplay)(INTEGER_DATA(rdisplay)[0], gg);
  } 

  if(IS_NUMERIC(rdisplay)) {
     display  = (displayd*) (long) NUMERIC_DATA(rdisplay)[0];
  } else if(TYPEOF(rdisplay) == EXTPTRSXP) {
     display = (displayd *) R_ExternalPtrAddr(rdisplay);    
  }

  if(display) {
    display = ValidateDisplayRef(display, gg, false);
    if(!display)
      display = GGOBI(getDisplay)(((long) NUMERIC_DATA(rdisplay)[0] - 1), gg);
  }

 return(display);
}

/*
 Resolves a datad from the ggobiId, datadId pair.

 Handles indices, names or ggobiDataset objects.
 */
datad *
resolveDatad(USER_OBJECT_ datasetId, USER_OBJECT_ ggobiId, ggobid **setgg) 
{
 datad *d = NULL;
 ggobid *gg = NULL;
  if(R_IS(datasetId, "ggobiDataset")) {
    d = GetDatad(datasetId);
    if(setgg)
      gg = GetGGobi(VECTOR_ELT(datasetId, 1));
  } else if(IS_INTEGER(datasetId)) {
    gg = GetGGobi(ggobiId);
    if(gg)
      d = (datad *) g_slist_nth_data(gg->d,INTEGER_DATA(datasetId)[0]); 
  } else if(IS_CHARACTER(datasetId)) {
    GSList *tmp = NULL;
    gg = GetGGobi(ggobiId);
    if(gg)
      tmp = gg->d;
    while(tmp) {
      d = (datad *) tmp->data;
      if(strcmp(d->name, CHAR_DEREF(STRING_ELT(datasetId, 0))) == 0)
        break;
      d = NULL; 
      tmp = tmp->next;
    }
  }

 if(setgg)
   *setgg = gg;

 return(d);
}



void
RS_GGOBI(getNumGGobiInstances)(glong *ans)
{
 ans[0] = GGOBI(getNumGGobis)();
}


USER_OBJECT_
RS_GGOBI(close)(USER_OBJECT_ gobi)
{
  ggobid *gg = GetGGobi(gobi);
  USER_OBJECT_ ans = NEW_LOGICAL(1);
  if(gg) {
    LOGICAL_DATA(ans)[0] = GGOBI(close)(gg, true);
    gdk_flush();
  }

 return(ans);
}


/**
 queries ggobi's list of display types, assuming GGobi has been initialized.
*/
USER_OBJECT_
RS_GGOBI(getDisplayTypes)()
{
  GSList *l;
  gint n;
  USER_OBJECT_ ans, names;

  l = GGOBI(getExtendedDisplayTypes)();
 
  n = g_slist_length(l); 
  PROTECT(ans = NEW_LIST(n));
  PROTECT(names = NEW_CHARACTER(n));

  n = 0;
  for( ; l ; l = l->next, n++) {
     GtkGGobiExtendedDisplayClass *klass;
     klass = GTK_GGOBI_EXTENDED_DISPLAY_CLASS((GtkObjectClass*) l->data);
     SET_STRING_ELT(names, n, COPY_TO_USER_STRING(klass->titleLabel));
     SET_VECTOR_ELT(ans, n, R_createGtkType(GTK_OBJECT_CLASS(klass)->type, NULL));
  }

  SET_NAMES(ans, names);
  UNPROTECT(2);

  return(ans);
}



/*
  Overrides the one in libGGobi.so 
  which is called when a window is deleted or explicitly
  closed.
 */
void
quit_ggobi(ggobid *gg, gint action, GtkWidget *w)
{
  GGOBI(close)(gg, true);
}

#ifdef G_OS_WIN32

void
R_gtk_handle_events()
{
  RS_GGOBI(limited_event_handle)(-1);
}
#endif


#include "GGStructSizes.c"

USER_OBJECT_
RS_GGOBI(getStructSizes)(USER_OBJECT_ local)
{
   const GGobi_StructSize *sizes;
   int n = 0, i;
   USER_OBJECT_ ans, names;

   if(LOGICAL_DATA(local)[0]) {
     sizes = GGOBI(getGGobiStructs)(&n);
   } else {
     sizes = GGOBI(getStructs)(&n);
   }

   PROTECT(ans = NEW_INTEGER(n));
   PROTECT(names = NEW_CHARACTER(n));
   for(i = 0; i < n ; i++) {
      INTEGER_DATA(ans)[i] = sizes[i].size;
      SET_STRING_ELT(names, i, COPY_TO_USER_STRING(sizes[i].name));
   }

   SET_NAMES(ans, names);

   UNPROTECT(2);
   return(ans);
}

USER_OBJECT_
RS_GGOBI(getMenubar)(USER_OBJECT_ gobi)
{
  ggobid *gg = GetGGobi(gobi);
  USER_OBJECT_ ans = NULL_USER_OBJECT;
  if(gg)
    ans = R_MakeExternalPtr(gg->main_menubar, Rf_install("GtkWidget"), NULL_USER_OBJECT);
  return(ans);
}
