/*
 * Copyright (c) 2003 Red Hat, Inc. All rights reserved.
 *
 * This software may be freely redistributed under the terms of the
 * GNU General Public License.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Author: Fernando Nasser
 * Component of: Visual Explain GUI tool for PostgreSQL - Red Hat Edition
 */

package com.redhat.rhdb.vise.resources;

import java.util.ListResourceBundle;
import java.awt.Event;
import java.awt.event.KeyEvent;
import java.awt.event.ActionEvent;
import javax.swing.KeyStroke;

/**
 * ActionResources.java
 *
 * @author <a href="mailto:fnasser@redhat.com">Fernando Nasser</a>
 *
 * @version 1.2.0
 */

public class ActionResources_ja_JP extends ListResourceBundle {

	public Object[][] getContents()
	{
		return contents;
	}

	private static final Object[][] contents = {
		{ ActionResources.NEW_NAME,                "\u65b0\u898f(N)" },
		//{ ActionResources.NEW_COMMAND,             "new" },
		{ ActionResources.NEW_SHORTDESC,           "\u65b0\u898f" },
		{ ActionResources.NEW_LONGDESC,            "\u65b0\u898f" },
		//{ ActionResources.NEW_SMALLICON,           "new16.png" },
		//{ ActionResources.NEW_LARGEICON,           "new24.png" },
		//{ ActionResources.NEW_ACCELERATOR,         KeyStroke.getKeyStroke(KeyEvent.VK_N, Event.CTRL_MASK) },
		//{ ActionResources.NEW_MNEMONIC,            new Integer(KeyEvent.VK_N) },

		{ ActionResources.SAVE_NAME,               "\u4fdd\u5b58(S)" },
		//{ ActionResources.SAVE_COMMAND,            "save" },
		{ ActionResources.SAVE_SHORTDESC,          "\u4fdd\u5b58" },
		{ ActionResources.SAVE_LONGDESC,           "\u4fdd\u5b58" },
		//{ ActionResources.SAVE_SMALLICON,          "save16.png" },
		//{ ActionResources.SAVE_LARGEICON,          "save24.png" },
		//{ ActionResources.SAVE_ACCELERATOR,        KeyStroke.getKeyStroke(KeyEvent.VK_S, Event.CTRL_MASK) },
		//{ ActionResources.SAVE_MNEMONIC,           new Integer(KeyEvent.VK_S) },
		
		{ ActionResources.SAVEAS_NAME,             "\u540d\u524d\u3092\u3064\u3051\u3066\u4fdd\u5b58(A)..." },
		//{ ActionResources.SAVEAS_COMMAND,          "saveas" },
		{ ActionResources.SAVEAS_SHORTDESC,        "\u540d\u524d\u3092\u3064\u3051\u3066\u4fdd\u5b58" },
		{ ActionResources.SAVEAS_LONGDESC,         "\u540d\u524d\u3092\u3064\u3051\u3066\u4fdd\u5b58" },
		//{ ActionResources.SAVEAS_SMALLICON,        "saveas16.png" },
		//{ ActionResources.SAVEAS_LARGEICON,        "saveas24.png" },
		//{ ActionResources.SAVEAS_MNEMONIC,         new Integer(KeyEvent.VK_C) },
		{ ActionResources.SAVEAS_MNEMONIC_INDEX,   new Integer(9) },

		{ ActionResources.OPEN_NAME,               "\u958b\u304f(O)..." },
		//{ ActionResources.OPEN_COMMAND,            "open" },
		{ ActionResources.OPEN_SHORTDESC,          "\u958b\u304f" },
		{ ActionResources.OPEN_LONGDESC,           "\u958b\u304f" },
		//{ ActionResources.OPEN_SMALLICON,          "open16.png" },
		//{ ActionResources.OPEN_LARGEICON,          "open24.png" },
		//{ ActionResources.OPEN_ACCELERATOR,        KeyStroke.getKeyStroke(KeyEvent.VK_O, Event.CTRL_MASK) },
		//{ ActionResources.OPEN_MNEMONIC,           new Integer(KeyEvent.VK_A) },

		{ ActionResources.CUT_NAME,                "\u5207\u308a\u53d6\u308a(T)" },
		//{ ActionResources.CUT_COMMAND,             "cut" },
		{ ActionResources.CUT_SHORTDESC,           "\u5207\u308a\u53d6\u308a" },
		{ ActionResources.CUT_LONGDESC,            "\u5207\u308a\u53d6\u308a" },
		//{ ActionResources.CUT_SMALLICON,           "cut16.png" },
		//{ ActionResources.CUT_LARGEICON,           "cut24.png" },
		//{ ActionResources.CUT_ACCELERATOR,         KeyStroke.getKeyStroke(KeyEvent.VK_X, Event.CTRL_MASK) },
		//{ ActionResources.CUT_MNEMONIC,            new Integer(KeyEvent.VK_R) },

		{ ActionResources.COPY_NAME,               "\u30b3\u30d4\u30fc(C)" },
		//{ ActionResources.COPY_COMMAND,            "copy" },
		{ ActionResources.COPY_SHORTDESC,          "\u30b3\u30d4\u30fc" },
		{ ActionResources.COPY_LONGDESC,           "\u30b3\u30d4\u30fc" },
		//{ ActionResources.COPY_SMALLICON,          "copy16.png" },
		//{ ActionResources.COPY_LARGEICON,          "copy24.png" },
		//{ ActionResources.COPY_ACCELERATOR,        KeyStroke.getKeyStroke(KeyEvent.VK_C, Event.CTRL_MASK) },
		//{ ActionResources.COPY_MNEMONIC,           new Integer(KeyEvent.VK_C) },

		{ ActionResources.PASTE_NAME,              "\u8cbc\u308a\u4ed8\u3051(P)" },
		//{ ActionResources.PASTE_COMMAND,           "paste" },
		{ ActionResources.PASTE_SHORTDESC,         "\u8cbc\u308a\u4ed8\u3051" },
		{ ActionResources.PASTE_LONGDESC,          "\u8cbc\u308a\u4ed8\u3051" },
		//{ ActionResources.PASTE_SMALLICON,         "paste16.png" },
		//{ ActionResources.PASTE_LARGEICON,         "paste24.png" },
		//{ ActionResources.PASTE_ACCELERATOR,       KeyStroke.getKeyStroke(KeyEvent.VK_V, Event.CTRL_MASK) },
		//{ ActionResources.PASTE_MNEMONIC,          new Integer(KeyEvent.VK_L) },

		{ ActionResources.MANUAL_NAME,             "\u30de\u30cb\u30e5\u30a2\u30eb(M)..." },
		//{ ActionResources.MANUAL_COMMAND,        "manual" },
		{ ActionResources.MANUAL_SHORTDESC,        "\u30de\u30cb\u30e5\u30a2\u30eb" },
		{ ActionResources.MANUAL_LONGDESC,         "\u30de\u30cb\u30e5\u30a2\u30eb" },
		//{ ActionResources.MANUAL_SMALLICON,      "help16.png" },
		//{ ActionResources.MANUAL_LARGEICON,      "help24.png" },
		//{ ActionResources.MANUAL_ACCELERATOR,      KeyStroke.getKeyStroke(KeyEvent.VK_F1, 0) },
		//{ ActionResources.MANUAL_MNEMONIC,         new Integer(KeyEvent.VK_M) },

		{ ActionResources.ABOUT_NAME,              "\u60c5\u5831(A)..." },
		//{ ActionResources.ABOUT_COMMAND,           "about" },
		{ ActionResources.ABOUT_SHORTDESC,         "\u60c5\u5831" },
		{ ActionResources.ABOUT_LONGDESC,          "\u60c5\u5831" },
		//{ ActionResources.ABOUT_SMALLICON,         "about16.png" },
		//{ ActionResources.ABOUT_LARGEICON,         "about24.png" },
		//{ ActionResources.ABOUT_MNEMONIC,          new Integer(KeyEvent.VK_S) },

		{ ActionResources.EXIT_NAME,               "\u7d42\u4e86(X)" },
		//{ ActionResources.EXIT_COMMAND,            "exit" },
		{ ActionResources.EXIT_SHORTDESC,          "\u7d42\u4e86" },
		{ ActionResources.EXIT_LONGDESC,           "\u7d42\u4e86" },
		//{ ActionResources.EXIT_SMALLICON,          "exit16.png" },
		//{ ActionResources.EXIT_LARGEICON,          "exit24.png" },
		//{ ActionResources.EXIT_MNEMONIC,           new Integer(KeyEvent.VK_R) },

		{ ActionResources.EXPLAIN_NAME,            "Explain" },
		//{ ActionResources.EXPLAIN_COMMAND,         "explain" },
		{ ActionResources.EXPLAIN_SHORTDESC,       "Explain" },
		{ ActionResources.EXPLAIN_LONGDESC,        "Explain" },
		//{ ActionResources.EXPLAIN_SMALLICON,       "explain16.png" },
		//{ ActionResources.EXPLAIN_LARGEICON,       "explain24.png" },
		//{ ActionResources.EXPLAIN_ACCELERATOR,     KeyStroke.getKeyStroke(KeyEvent.VK_E, Event.CTRL_MASK) },
		//{ ActionResources.EXPLAIN_MNEMONIC,        new Integer(KeyEvent.VK_E) },

		{ ActionResources.PREFERENCES_NAME,        "\u74b0\u5883\u8a2d\u5b9a(F)..." },
		//{ ActionResources.PREFERENCES_COMMAND,     "preferences" },
		{ ActionResources.PREFERENCES_SHORTDESC,   "Visual Explain\u306e\u8a2d\u5b9a\u3092\u7de8\u96c6\u3057\u307e\u3059" },
		{ ActionResources.PREFERENCES_LONGDESC,    "Visual Explain\u306e\u8a2d\u5b9a\u3092\u7de8\u96c6\u3057\u307e\u3059" },
		//{ ActionResources.PREFERENCES_SMALLICON,   "prefs16.png" },
		//{ ActionResources.PREFERENCES_LARGEICON,   "prefs24.png" },
		//{ ActionResources.PREFERENCES_MNEMONIC,    new Integer(KeyEvent.VK_P) },

		{ ActionResources.DATABASES_NAME,          "\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9(D)..." },
		//{ ActionResources.DATABASES_COMMAND,       "databases" },
		{ ActionResources.DATABASES_SHORTDESC,     "\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u306b\u63a5\u7d9a\u3059\u308b\u305f\u3081\u306e\u8a2d\u5b9a\u3092\u7de8\u96c6\u3057\u307e\u3059" },
		{ ActionResources.DATABASES_LONGDESC,      "\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u306b\u63a5\u7d9a\u3059\u308b\u305f\u3081\u306e\u8a2d\u5b9a\u3092\u7de8\u96c6\u3057\u307e\u3059" },
		//{ ActionResources.DATABASES_MNEMONIC,      new Integer(KeyEvent.VK_D) },

		{ ActionResources.PLANNEROPTIONS_NAME,      "\u30d7\u30e9\u30f3\u30ca \u30aa\u30d7\u30b7\u30e7\u30f3(O)..." },
		//{ ActionResources.PLANNEROPTIONS_COMMAND,   "planneroptions" },
		{ ActionResources.PLANNEROPTIONS_SHORTDESC, "\u30d7\u30e9\u30f3\u30ca\u306e\u30aa\u30d7\u30b7\u30e7\u30f3\u3092\u7de8\u96c6\u3057\u307e\u3059" },
		{ ActionResources.PLANNEROPTIONS_LONGDESC,  "\u30d7\u30e9\u30f3\u30ca\u306e\u30aa\u30d7\u30b7\u30e7\u30f3\u3092\u7de8\u96c6\u3057\u307e\u3059" },
		//{ ActionResources.PLANNEROPTIONS_MNEMONIC,  new Integer(KeyEvent.VK_O) },

		{ ActionResources.ZOOMIN_NAME,             "\u62e1\u5927(I)" },
		//{ ActionResources.ZOOMIN_COMMAND,          "zoomin" },
		{ ActionResources.ZOOMIN_SHORTDESC,        "\u8868\u793a\u3092\u62e1\u5927\u3057\u307e\u3059" },
		{ ActionResources.ZOOMIN_LONGDESC,         "\u8868\u793a\u3092\u62e1\u5927\u3057\u307e\u3059" },
		//{ ActionResources.ZOOMIN_SMALLICON,        "zoomin16.png" },
		//{ ActionResources.ZOOMIN_LARGEICON,        "zoomin24.png" },
		//{ ActionResources.ZOOMIN_ACCELERATOR,      KeyStroke.getKeyStroke(KeyEvent.VK_EQUALS, Event.CTRL_MASK) },
		//{ ActionResources.ZOOMIN_MNEMONIC,         new Integer(KeyEvent.VK_P) },

		{ ActionResources.ZOOMOUT_NAME,            "\u7e2e\u5c0f(O)" },
		//{ ActionResources.ZOOMOUT_COMMAND,         "zoomout" },
		{ ActionResources.ZOOMOUT_SHORTDESC,       "\u8868\u793a\u3092\u7e2e\u5c0f\u3057\u307e\u3059" },
		{ ActionResources.ZOOMOUT_LONGDESC,        "\u8868\u793a\u3092\u7e2e\u5c0f\u3057\u307e\u3059" },
		//{ ActionResources.ZOOMOUT_SMALLICON,       "zoomout16.png" },
		//{ ActionResources.ZOOMOUT_LARGEICON,       "zoomout24.png" },
		//{ ActionResources.ZOOMOUT_ACCELERATOR,     KeyStroke.getKeyStroke(KeyEvent.VK_MINUS, Event.CTRL_MASK) },
		//{ ActionResources.ZOOMOUT_MNEMONIC,        new Integer(KeyEvent.VK_F) },

		{ ActionResources.DELETE_NAME,             "\u524a\u9664(D)" },
		//{ ActionResources.DELETE_COMMAND,          "delete" },
		{ ActionResources.DELETE_SHORTDESC,        "\u524a\u9664" },
		{ ActionResources.DELETE_LONGDESC,         "\u524a\u9664" },
		//{ ActionResources.DELETE_ACCELERATOR,      KeyStroke.getKeyStroke(KeyEvent.VK_D, Event.CTRL_MASK) },
		//{ ActionResources.DELETE_MNEMONIC,         new Integer(KeyEvent.VK_D) },

		{ ActionResources.EDIT_NAME,               "\u7de8\u96c6(E)" },
		//{ ActionResources.EDIT_COMMAND,            "edit" },
		{ ActionResources.EDIT_SHORTDESC,          "\u7de8\u96c6" },
		{ ActionResources.EDIT_LONGDESC,           "\u7de8\u96c6" },
		//{ ActionResources.EDIT_ACCELERATOR,        KeyStroke.getKeyStroke(KeyEvent.VK_E, Event.CTRL_MASK) },
		//{ ActionResources.EDIT_MNEMONIC,           new Integer(KeyEvent.VK_E) },

		{ ActionResources.OK_NAME,                 "OK" },
		//{ ActionResources.OK_COMMAND,              "ok" },
		{ ActionResources.OK_SHORTDESC,            "OK" },
		{ ActionResources.OK_LONGDESC,             "OK" },
		//{ ActionResources.OK_ACCELERATOR,          KeyStroke.getKeyStroke(KeyEvent.VK_O, Event.CTRL_MASK) },
		//{ ActionResources.OK_MNEMONIC,             new Integer(KeyEvent.VK_O) },

		{ ActionResources.CANCEL_NAME,             "\u53d6\u6d88\u3057" },
		//{ ActionResources.CANCEL_COMMAND,          "cancel" },
		{ ActionResources.CANCEL_SHORTDESC,        "\u53d6\u6d88\u3057" },
		{ ActionResources.CANCEL_LONGDESC,         "\u53d6\u6d88\u3057" },
		//{ ActionResources.CANCEL_ACCELERATOR,      KeyStroke.getKeyStroke(KeyEvent.VK_C, Event.CTRL_MASK) },
		//{ ActionResources.CANCEL_MNEMONIC,         new Integer(KeyEvent.VK_C) },

		{ ActionResources.TEST_NAME,               "\u30c6\u30b9\u30c8(T)" },
		//{ ActionResources.TEST_COMMAND,            "test" },
		{ ActionResources.TEST_SHORTDESC,          "\u30c6\u30b9\u30c8" },
		{ ActionResources.TEST_LONGDESC,           "\u30c6\u30b9\u30c8" },
		//{ ActionResources.TEST_ACCELERATOR,        KeyStroke.getKeyStroke(KeyEvent.VK_T, Event.CTRL_MASK) },
		//{ ActionResources.TEST_MNEMONIC,           new Integer(KeyEvent.VK_T) },

		{ ActionResources.REFRESH_NAME,            "\u30ea\u30d5\u30ec\u30c3\u30b7\u30e5(R)" },
		//{ ActionResources.REFRESH_COMMAND,         "refresh" },
		{ ActionResources.REFRESH_SHORTDESC,       "\u8868\u793a\u3092\u66f4\u65b0\u3057\u307e\u3059" },
		{ ActionResources.REFRESH_LONGDESC,        "\u8868\u793a\u3092\u66f4\u65b0\u3057\u307e\u3059" },
		//{ ActionResources.REFRESH_SMALLICON,	     "refresh16.png" },
		//{ ActionResources.REFRESH_ACCELERATOR,     KeyStroke.getKeyStroke(KeyEvent.VK_F5, 0) },
		//{ ActionResources.REFRESH_MNEMONIC,        new Integer(KeyEvent.VK_R) },

		{ ActionResources.CONTINUE_NAME,           "\u7d99\u7d9a" },
		//{ ActionResources.CONTINUE_COMMAND,        "continue" },
		{ ActionResources.CONTINUE_SHORTDESC,      "\u7d99\u7d9a" },
		{ ActionResources.CONTINUE_LONGDESC,       "\u7d99\u7d9a" },
		//{ ActionResources.CONTINUE_ACCELERATOR,    KeyStroke.getKeyStroke(KeyEvent.VK_O, Event.CTRL_MASK) },
		//{ ActionResources.CONTINUE_MNEMONIC,       new Integer(KeyEvent.VK_O) },

		{ ActionResources.BACK_NAME,               "\u623b\u308b" },
		//{ ActionResources.BACK_COMMAND,            "back" },
		{ ActionResources.BACK_SHORTDESC,          "\u623b\u308b" },
		{ ActionResources.BACK_LONGDESC,           "\u623b\u308b" },
		//{ ActionResources.BACK_LARGEICON,          "back24.png" },
		//{ ActionResources.BACK_ACCELERATOR,        KeyStroke.getKeyStroke(KeyEvent.VK_LEFT, Event.CTRL_MASK) },
		//{ ActionResources.BACK_MNEMONIC,           new Integer(KeyEvent.VK_B) },

		{ ActionResources.FORWARD_NAME,            "\u9032\u3080" },
		//{ ActionResources.FORWARD_COMMAND,         "forward" },
		{ ActionResources.FORWARD_SHORTDESC,       "\u9032\u3080" },
		{ ActionResources.FORWARD_LONGDESC,        "\u9032\u3080" },
		//{ ActionResources.FORWARD_LARGEICON,       "forward24.png" },
		//{ ActionResources.FORWARD_ACCELERATOR,     KeyStroke.getKeyStroke(KeyEvent.VK_RIGHT, Event.CTRL_MASK) },
		//{ ActionResources.FORWARD_MNEMONIC,        new Integer(KeyEvent.VK_F) },

		{ ActionResources.HOME_NAME,               "\u30db\u30fc\u30e0" },
		//{ ActionResources.HOME_COMMAND,            "home" },
		{ ActionResources.HOME_SHORTDESC,          "\u30db\u30fc\u30e0" },
		{ ActionResources.HOME_LONGDESC,           "\u30db\u30fc\u30e0" },
		//{ ActionResources.HOME_LARGEICON,          "home24.png" },
		//{ ActionResources.HOME_ACCELERATOR,        KeyStroke.getKeyStroke(KeyEvent.VK_HOME, Event.CTRL_MASK) },
		//{ ActionResources.HOME_MNEMONIC,           new Integer(KeyEvent.VK_H) },

		{ ActionResources.ANALYZE_NAME,            "Explain Analyze" },
		//{ ActionResources.ANALYZE_COMMAND,         "explain analyze" },
		{ ActionResources.ANALYZE_SHORTDESC,       "Explain Analyze" },
		{ ActionResources.ANALYZE_LONGDESC,        "Explain Analyze" },
		//{ ActionResources.ANALYZE_SMALLICON,       "explain16.png" },
		//{ ActionResources.ANALYZE_LARGEICON,       "explain24.png" },
		//{ ActionResources.ANALYZE_ACCELERATOR,     KeyStroke.getKeyStroke(KeyEvent.VK_L, Event.CTRL_MASK) },
		//{ ActionResources.ANALYZE_MNEMONIC,        new Integer(KeyEvent.VK_L) },
		//{ ActionResources.ANALYZE_MNEMONIC_INDEX,  new Integer(11) },

		{ ActionResources.STOP_NAME,               "\u505c\u6b62" },
		//{ ActionResources.STOP_COMMAND,            "stop" },
		{ ActionResources.STOP_SHORTDESC,          "\u505c\u6b62" },
		{ ActionResources.STOP_LONGDESC,           "\u505c\u6b62" },
		//{ ActionResources.STOP_SMALLICON,          "stop16.png" },
		//{ ActionResources.STOP_LARGEICON,          "stop24.png" },
		//{ ActionResources.STOP_ACCELERATOR,        KeyStroke.getKeyStroke(KeyEvent.VK_Z, Event.CTRL_MASK) },
		//{ ActionResources.STOP_MNEMONIC,           new Integer(KeyEvent.VK_Z) },

		//{ ActionResources.DEFAULT_NAME,            "Unknown Action" },

	};
}// Resources
