/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.generic;

import org.apache.bcel.Repository;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.generic.ReferenceType;

public class ObjectType
extends ReferenceType {
    private String class_name;

    public ObjectType(String string) {
        super((byte)14, "L" + string.replace('.', '/') + ";");
        this.class_name = string.replace('/', '.');
    }

    public String getClassName() {
        return this.class_name;
    }

    public int hashCode() {
        return this.class_name.hashCode();
    }

    public boolean equals(Object object) {
        return object instanceof ObjectType ? ((ObjectType)object).class_name.equals(this.class_name) : false;
    }

    public boolean referencesClass() {
        try {
            JavaClass javaClass = Repository.lookupClass(this.class_name);
            return javaClass.isClass();
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    public boolean referencesInterface() {
        try {
            JavaClass javaClass = Repository.lookupClass(this.class_name);
            return !javaClass.isClass();
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    public boolean referencesClassExact() throws ClassNotFoundException {
        JavaClass javaClass = Repository.lookupClass(this.class_name);
        return javaClass.isClass();
    }

    public boolean referencesInterfaceExact() throws ClassNotFoundException {
        JavaClass javaClass = Repository.lookupClass(this.class_name);
        return !javaClass.isClass();
    }

    public boolean subclassOf(ObjectType objectType) throws ClassNotFoundException {
        if (this.referencesInterface() || objectType.referencesInterface()) {
            return false;
        }
        return Repository.instanceOf(this.class_name, objectType.class_name);
    }

    public boolean accessibleTo(ObjectType objectType) throws ClassNotFoundException {
        JavaClass javaClass = Repository.lookupClass(this.class_name);
        if (javaClass.isPublic()) {
            return true;
        }
        JavaClass javaClass2 = Repository.lookupClass(objectType.class_name);
        return javaClass2.getPackageName().equals(javaClass.getPackageName());
    }
}

