#include "forms.h"
#include "rtty_f.h"
#include "common.h"

extern FD_rtty_form *fd_rtty_form;

/*** callbacks and freeobj handles for form rtty_form ***/

void display_mode(FL_OBJECT *ob, long data)
{
	disdp->mode=data;
	redisp=1;
}

/*********************************************************/

void set_data_bits(FL_OBJECT *ob, long data)
{
	fskdp->nbit=data;
}

void set_stop_bits(FL_OBJECT *ob, long data)
{
	fskdp->nstop=data;
	if(data==3) {
		fskdp->nstop=1;
		fskdp->nstop05=1;
	} else  fskdp->nstop05=0;
}

void set_parity(FL_OBJECT *ob, long data)
{
	fskdp->parity=data;
}

/*------------------------------------------------------*/

const int baudlist[]=BAUD_LIST;
static int baudp=0;
void adj_baudp(int dr)
{
	for (baudp=0;;baudp++) {
		if (baudlist[baudp]==0 || baudlist[baudp]>dr){baudp--; break;}
	}
	if (baudp<0) baudp=0;
}

void set_baud(FL_OBJECT *ob, long data)
{
	unsigned int dr;
	dr=atoi(fl_get_input(ob));
	fskdp->dr=dr;
	fskdp->phs=(dr<<16)/FS;	/* bit phase / sample */
	set_filters(fskdp->spacef,fskdp->markf,fskdp->dr);
	adj_baudp(dr);
	redisp=1;
}

void set_baud_st(FL_OBJECT *ob, long data)
{
	char buf[40];
	
	baudp+=data;
	if (baudp<0) baudp=0;
	if (baudlist[baudp]==0) baudp--;
	sprintf(buf,"%d",baudlist[baudp]);
	fl_set_input(fd_rtty_form->sbaud,buf);
	fskdp->dr=baudlist[baudp];
	fskdp->phs=(baudlist[baudp]<<16)/FS;
	set_filters(fskdp->spacef,fskdp->markf,fskdp->dr);
	redisp=1;
}

void set_space(FL_OBJECT *ob, long data)
{
	fskdp->spacef=fl_get_counter_value(ob);
	set_filters(fskdp->spacef,fskdp->markf,fskdp->dr);
	redisp=1;
}

void set_mark(FL_OBJECT *ob, long data)
{
	fskdp->markf=fl_get_counter_value(ob);
	set_filters(fskdp->spacef,fskdp->markf,fskdp->dr);
	redisp=1;
}



