#ifndef S9X_INTERFACE_H
#define S9X_INTERFACE_H

class s9x_Interface;

#include <string>
#include "defines.h"
#include "frend.h"
#include "skins.h"
#include "rom.h"
#include "sound.h"
#include "video.h"
#include "controller.h"
#include "cpu.h"
#include "netplay.h"
#include "extra.h"
#include "profiler.h"
#include "prefs.h"
#include "misc.h"

class s9x_Interface: public fr_MainProgram, private fr_Listener {
  friend class s9x_Prefs;
 private:
  std::string           outbuf, errbuf;
  fr_Notebook    	NoteBook;
  fr_Element		Quit, Tip;
  fr_CustomButton	Power, Reset, Eject;
  fr_ButtonBox          console_buttons;
  fr_Button             power_btn, reset_btn, eject_btn;
  fr_Size               defaultnotebooksize, defaultbuttonsize, defaultwindowsize;
  fr_Point              console_button_place;
  fr_ArgList		LastArgs;
  s9x_File		LogFile;
  fr_Window		AboutWindow, LogWindow;
  fr_TextArea		AboutText, LogText;
  fr_Button		AboutClose, LogBtn;
  fr_Label		LogLabel;
  void			CreateMenu();
  void			CreateNotebook();
  void                  CreateAboutInfo();
  void			EventOccurred(fr_Event*e);
  void                  hitPower();
  void                  hitEject();
  void                  hitReset();
  void			viewOutput(const std::string& msg="");
  void                  play();
 public:
  s9x_Prefs		Prefs;
  s9x_ROM		ROM;
  s9x_Sound		Sound;
  s9x_Video		Video;
  s9x_CPU		CPU;
  s9x_Controller	Controller;
  s9x_NetPlay		NetPlay;
  s9x_Snapshot		Snapshot;
  s9x_Extra		Extra;
  s9x_Profiler		Profiler;
  s9x_Skin		*Skin;
                	s9x_Interface(const fr_ArgList& args);
                        ~s9x_Interface();
  void			SetToDefaults();
  void			Set9xVersion(double version);
  void 	       		SiftArgs(fr_ArgList& L);
  void			CompileArgs(fr_ArgList& L);
  void                  setROMdir(const std::string& d) { ROM.setROMdir(d); }
  void			ApplySkin(const std::string& SkinDir);
  void			ShedSkin();
};

#endif

