#ifndef S9X_S9XSKIN_H
#define S9X_S9XSKIN_H

#include "defines.h"

#ifdef S9X_SKINABLE

#include <cstdio>
#include <cstdlib>
#include <iostream>
#include <netinet/in.h>
#include <string>
#include <map>
#include <list>

typedef struct
{
	char filename[40];
	uint32_t fileoffset;
	uint32_t filesize;
} s9x_SkinFileIndexRecord;


class s9x_SkinFileBase
{
 typedef std::map<std::string,s9x_SkinFileIndexRecord*> index;
 protected:
	index idx;
	FILE*skinfptr;
 public:
	s9x_SkinFileBase() { skinfptr = 0; }
	virtual ~s9x_SkinFileBase();
};

class s9x_SkinReader : public s9x_SkinFileBase
{
 private:
	void readHeader();
	void loadIndex();

 public:
	s9x_SkinReader(const std::string filespec);
	virtual ~s9x_SkinReader() {}


	uint32_t getFileSize(std::string filename);
	std::istream& getIstream(std::string filename);
	FILE* seekFile(std::string filename);
};

class s9x_SkinWriter : public s9x_SkinFileBase
{
 typedef std::list<std::string> filelist;
 private:
	filelist files;
	std::string stylesheet;
	std::string skindir;

	void addFile(const std::string& filename);
	void scanStyleSheet();
	void writeIndex();
 public:
	s9x_SkinWriter(const std::string& inputdir);
	virtual ~s9x_SkinWriter() {}

	void writeFile(const std::string& outputfilename);
};

#else
class s9x_SkinReader;
#endif

int s9xskin_main(int argc, char**argv);

#endif
