#ifndef S9X_SKINS_H
#define S9X_SKINS_H

#include <iostream>
#include <map>
#include <string>
#include "frend.h"
#include "s9xskin.h"

#ifndef S9X_INTERFACE_H
class s9x_Interface;
#endif

class s9x_Skin;

class s9x_SkinSelector:	public fr_PulldownMenu
{
 typedef std::map<std::string,std::string> PathMap;
 typedef std::map<fr_MenuItem*,std::string> MenuMap;
 private:
  std::string		defaultskin;
  PathMap               skinPaths;
  MenuMap               menuItems;
  void			LoadPaths();
  void                  FillMenu();
  void			setDefaultSkinFromFile(const std::string& f);
 public:
  s9x_SkinSelector(fr_Element*parent);
  virtual ~s9x_SkinSelector();
  std::string		GetSelectedSkinName();
  std::string		GetSelectedSkinPath();
};

class s9x_SkinSection
{
 private:
   s9x_Skin* skin;
   std::map<std::string, std::string> properties;	// string from source
 public:
   s9x_SkinSection(s9x_Skin*parent);
   virtual ~s9x_SkinSection();
   void set(const std::string& name, const std::string& value)
     { properties[name] = value; }
   bool has(const std::string& name) const;
   std::string getString(const std::string name) { return properties[name]; }
   int getInt(const std::string& name) const;
   fr_Colors getColors(const std::string& name) const;
   fr_Image* getImage(const std::string& imgname) const;
};

class s9x_Skin
{
 private:
   s9x_Interface*Parent;
   std::string skinfilename;
   s9x_SkinReader*skinr;
   std::map<std::string, s9x_SkinSection*> sections;
   std::map<std::string, fr_Image*> images;	// image cache
   void load();

 public:
   s9x_Skin(s9x_Interface*parent, const std::string& SkinFile);
   virtual ~s9x_Skin();
   std::string getName() const;
   fr_Element* getElement() { return (fr_Element*)Parent; }
   std::string getFilename() const { return skinfilename; }
   bool equals(const std::string& f) { return skinfilename==f; }
   s9x_SkinSection* getSection(const std::string& name) { return sections[name]; }
   fr_Image* getImage(const std::string& imgname);
};

std::istream& operator>> (std::istream& is, s9x_SkinSection* ss);

#endif
