/* Stars -- Displays a Map of the Night Sky
    Copyright (C) September 22, 2002  Walter Brisken

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA*/

#include <math.h>
#include "configurecoords.h"

/* Protos */

void coordentrychanged(GtkWidget *widget, gpointer *d);

struct coordsconfig *newcoordsconfig(GladeXML *configxml)
{
	struct coordsconfig *cc;
/* 	GList *cl, *coordlist = 0; */
/* 	gint i; */

	cc = g_new(struct coordsconfig, 1);

	cc->coordcombo = glade_xml_get_widget(configxml, "coordcombo");
	cc->coordentry = glade_xml_get_widget(configxml, "coordentry");
	cc->coordframe = glade_xml_get_widget(configxml, "coordframe");
	cc->gridbutton = glade_xml_get_widget(configxml, "gridbutton");
	cc->equbutton = glade_xml_get_widget(configxml, "equbutton");
	cc->polesbutton = glade_xml_get_widget(configxml, "polesbutton");
	cc->gridcolor = glade_xml_get_widget(configxml, "gridcolor");
	cc->equcolor = glade_xml_get_widget(configxml, "equcolor");
	cc->polescolor = glade_xml_get_widget(configxml, "polescolor");
	cc->gridlabelcombo = glade_xml_get_widget(configxml, "gridlabelcombo");
	cc->gridlabelentry = glade_xml_get_widget(configxml, "gridlabelentry");
	cc->equlabelcombo = glade_xml_get_widget(configxml, "equlabelcombo");
	cc->equlabelentry = glade_xml_get_widget(configxml, "equlabelentry");
	cc->poleslabelbutton = glade_xml_get_widget(configxml, "poleslabelbutton");
	cc->griddegbutton = glade_xml_get_widget(configxml, "griddegbutton");
	cc->gridnumbutton = glade_xml_get_widget(configxml, "gridnumbutton");
	cc->equdegbutton = glade_xml_get_widget(configxml, "equdegbutton");
	cc->equnumbutton = glade_xml_get_widget(configxml, "equnumbutton");
	cc->griddegspin = glade_xml_get_widget(configxml, "griddegspin");
	cc->gridnumspin = glade_xml_get_widget(configxml, "gridnumspin");
	cc->equdegspin = glade_xml_get_widget(configxml, "equdegspin");
	cc->equnumspin = glade_xml_get_widget(configxml, "equnumspin");

	cc->coordlist     = GTK_COMBO(cc->coordcombo)->list;
	cc->gridlabellist = GTK_COMBO(cc->gridlabelcombo)->list;
	cc->equlabellist  = GTK_COMBO(cc->equlabelcombo)->list;

	cc->coordpropscount = coordcombofill(cc->coordcombo);
	if(cc->coordpropscount == 0)
		fprintf(stderr, "newcoordsconfig: Warning, no coords!\n");
	
	cc->oldprops = g_new(struct coordprops, cc->coordpropscount);
	cc->curprops = g_new(struct coordprops, cc->coordpropscount);

	gtk_signal_connect(GTK_OBJECT(cc->coordentry), "changed",
		GTK_SIGNAL_FUNC(coordentrychanged), cc);

	return cc;
} 

void deletecoordsconfig(struct coordsconfig *cc)
{
	if(!cc)
	{
		fprintf(stderr, "deletecoordsconfig:attempt to delete null coordsconfig\n");
		return;
	}
	if(cc->oldprops) g_free(cc->oldprops);
	if(cc->curprops) g_free(cc->curprops);
	g_free(cc);
}

void getcurcoordsslot(struct coordsconfig *cc)
{
	gchar *coordsysname;
	gint i;
	gint result = -1;

	coordsysname = gtk_editable_get_chars(GTK_EDITABLE(cc->coordentry), 0, -1);
	for(i = 0; i < cc->coordpropscount; i++)
	{
		if(strcmp(cc->curprops[i].coords->name, coordsysname) == 0)
		{
			if(result == -1) result = i;
			else fprintf(stderr, "getcurcoordsslot: dup coords found : %s\n",
				coordsysname);
		}
	}
	if(result == -1) fprintf(stderr, "getcurcoordsslot: coordsys not found : %s\n",
		coordsysname);
	g_free(coordsysname);

	if(result != -1) cc->curslot = result;
}

void coordsconfigupdate(struct coordsconfig *cc)
{
	struct coordprops *cp;
	gchar *tmp;

	cp = cc->curprops + cc->curslot;

	tmp = g_strdup_printf("%s coordinates", cp->coords->name);
	gtk_frame_set_label(GTK_FRAME(cc->coordframe), tmp);
	g_free(tmp);

	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(cc->gridbutton), cp->gridvis);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(cc->equbutton), cp->equvis);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(cc->polesbutton), cp->polesvis);

	if(cp->griddensitymode == 0) 
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(cc->griddegbutton), TRUE);
	else gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(cc->gridnumbutton), TRUE);
	
	if(cp->equdensitymode == 0) 
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(cc->equdegbutton), TRUE);
	else gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(cc->equnumbutton), TRUE);

	gtk_spin_button_set_value(GTK_SPIN_BUTTON(cc->griddegspin), cp->griddegrees);
	gtk_spin_button_set_value(GTK_SPIN_BUTTON(cc->gridnumspin), cp->gridnumber);
	gtk_spin_button_set_value(GTK_SPIN_BUTTON(cc->equdegspin), cp->equdegrees);
	gtk_spin_button_set_value(GTK_SPIN_BUTTON(cc->equnumspin), cp->equnumber);
}

void coordsconfigcollect(struct coordsconfig *cc)
{
	struct coordprops *cp;

	cp = cc->curprops + cc->curslot;
	
	cp->gridvis  = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(cc->gridbutton));
	cp->equvis   = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(cc->equbutton));
	cp->polesvis = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(cc->polesbutton));

	if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(cc->griddegbutton)))
		cp->griddensitymode = 0;
	else cp->griddensitymode = 1;
	
	if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(cc->equdegbutton)))
		cp->equdensitymode = 0;
	else cp->equdensitymode = 1;

	cp->griddegrees = 
		gtk_spin_button_get_value_as_float(GTK_SPIN_BUTTON(cc->griddegspin));
	cp->gridnumber = 
		gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(cc->gridnumspin));
	cp->equdegrees = 
		gtk_spin_button_get_value_as_float(GTK_SPIN_BUTTON(cc->equdegspin));
	cp->equnumber = 
		gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(cc->equnumspin));
}

void coordsconfigtry(struct configurator *cfg)
{
	coordsconfigcollect(cfg->coordsinfo);
	setcoordprops(cfg->v, cfg->coordsinfo->curprops);
	paint(cfg->v);
}

void coordsconfigrevert(struct configurator *cfg)
{
	gint i;

	for(i = 0; i < cfg->coordsinfo->coordpropscount; i++)
		memcpy(cfg->coordsinfo->curprops + i,
		       cfg->coordsinfo->oldprops + i,
		       sizeof(struct coordprops));
	coordsconfigupdate(cfg->coordsinfo);
}

void coordsconfigsetup(struct configurator *cfg)
{
	getcoordprops(cfg->coordsinfo->oldprops, cfg->v);
	getcoordprops(cfg->coordsinfo->curprops, cfg->v);
	getcurcoordsslot(cfg->coordsinfo);
	coordsconfigupdate(cfg->coordsinfo);
}

/* -------------------- Callbacks ------------------- */

void coordentrychanged(GtkWidget *widget, gpointer *d)
{
	struct coordsconfig *cc;

	cc = (struct coordsconfig *)d;
	
	coordsconfigcollect(cc);
	getcurcoordsslot(cc);
	coordsconfigupdate(cc);
}

