/*
    StatCvs - CVS statistics generation 
    Copyright (C) 2002  Lukasz Pekacki <lukasz@pekacki.de>
    http://statcvs.sf.net/
    
    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
    
	$RCSfile: UserPredicate.java,v $ 
	Created on $Date: 2003/04/19 21:52:28 $ 
*/
package net.sf.statcvs.model;

/**
 * Filter for Usernames
 * filters revisions that meet a given set of usernames
 * @author Lukasz Pekacki <lukasz@pekacki.de>
 * @version $Id: UserPredicate.java,v 1.9 2003/04/19 21:52:28 cyganiak Exp $
 */
public class UserPredicate implements RevisionPredicate {

	private Author author;

	/**
	 * Constructor UserPredicate.
	 * @param author the author to filter for
	 */
	public UserPredicate(Author author) {
		this.author = author;
	}

	/**
	 * Filters revisions that meet a given set of usernames
	 * @see net.sf.statcvs.model.RevisionPredicate#meets(CvsRevision)
	 */
	public boolean meets(CvsRevision rev) {
		return rev.getAuthor().equals(author);
	}
}
