/* ==================================================
 * JCommon : a general purpose class library for Java
 * ==================================================
 *
 * Project Info:  http://www.object-refinery.com/jcommon/index.html
 * Project Lead:  David Gilbert (david.gilbert@object-refinery.com);
 *
 * (C) Copyright 2000-2002, by Simba Management Limited and Contributors.
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * ---------------
 * XYDataPair.java
 * ---------------
 * (C) Copyright 2001, 2002, by Simba Management Limited.
 *
 * Original Author:  David Gilbert (for Simba Management Limited);
 * Contributor(s):   -;
 *
 * $Id: XYDataPair.java,v 1.2 2002/06/25 09:37:20 mungady Exp $
 *
 * Changes
 * -------
 * 15-Nov-2001 : Version 1 (DG);
 * 24-Jun-2002 : Removed unnecessary import (DG);
 *
 */

package com.jrefinery.data;

/**
 * Represents one (x, y) data item for an xy-series.
 */
public class XYDataPair implements Comparable {

    /** The x-value. */
    protected Number x;

    /** The y-value. */
    protected Number y;

    /**
     * Constructs a new data pair.
     *
     * @param x The x-value.
     * @param y The y-value.
     */
    public XYDataPair(Number x, Number y) {
        this.x = x;
        this.y = y;
    }

    /**
     * Constructs a new data pair.
     *
     * @param x The x-value.
     * @param y The y-value.
     */
    public XYDataPair(double x, double y) {
        this(new Double(x), new Double(y));
    }

    /**
     * Returns the x-value.
     *
     * @return The x-value.
     */
    public Number getX() {
        return this.x;
    }

    /**
     * Returns the y-value.
     *
     * @return The y-value.
     */
    public Number getY() {
        return this.y;
    }

    /**
     * Sets the y-value for this data pair.
     * <P>
     * Note that there is no corresponding method to change the x-value.
     *
     * @param y The new y-value.
     */
    public void setY(Number y) {
        this.y = y;
    }

    /**
     * Returns an integer indicating the order of this data pair object relative to another object.
     * <P>
     * For the order we consider only the x-value:  negative == "less-than", zero == "equal",
     *                                              positive == "greater-than".
     *
     * @param o1 The object being compared to.
     *
     * @return An integer indicating the order of this data pair object relative to another object.
     */
    public int compareTo(Object o1) {

        int result;

        // CASE 1 : Comparing to another TimeSeriesDataPair object
        // -------------------------------------------------------
        if (o1 instanceof XYDataPair) {
            XYDataPair datapair = (XYDataPair)o1;
            double compare = this.x.doubleValue()-datapair.getX().doubleValue();
            if (compare>0) result = 1;
            else if (compare<0) result = -1;
            else result = 0;
        }

        // CASE 2 : Comparing to a general object
        // ---------------------------------------------
        else result = 1;  // consider time periods to be ordered after general objects

        return result;

    }

}