/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.log4j.Appender;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Category;
import org.apache.log4j.DefaultCategoryFactory;
import org.apache.log4j.Hierarchy;
import org.apache.log4j.Layout;
import org.apache.log4j.Priority;
import org.apache.log4j.PropertyWatchdog;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.helpers.OptionConverter;
import org.apache.log4j.spi.CategoryFactory;
import org.apache.log4j.spi.Configurator;
import org.apache.log4j.spi.OptionHandler;

public class PropertyConfigurator
extends BasicConfigurator
implements Configurator {
    static final String CATEGORY_PREFIX = "log4j.category.";
    static final String ADDITIVITY_PREFIX = "log4j.additivity.";
    static final String ROOT_CATEGORY_PREFIX = "log4j.rootCategory";
    static final String APPENDER_PREFIX = "log4j.appender.";
    static final String RENDERER_PREFIX = "log4j.renderer.";
    static final String CATEGORY_FACTORY_KEY = "log4j.categoryFactory";
    private static final String INTERNAL_ROOT_NAME = "root";
    protected Hashtable registry = new Hashtable(11);
    protected CategoryFactory categoryFactory = new DefaultCategoryFactory();
    private static /* synthetic */ Class class$Lorg$apache$log4j$spi$CategoryFactory;
    private static /* synthetic */ Class class$Lorg$apache$log4j$Appender;
    private static /* synthetic */ Class class$Lorg$apache$log4j$Layout;

    public void doConfigure(String string, Hierarchy hierarchy) {
        Properties properties = new Properties();
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            properties.load(fileInputStream);
            fileInputStream.close();
        }
        catch (IOException iOException) {
            LogLog.error("Could not read configuration file [" + string + "].", iOException);
            LogLog.error("Ignoring configuration file [" + string + "].");
            return;
        }
        this.doConfigure(properties, hierarchy);
    }

    public static void configure(String string) {
        new PropertyConfigurator().doConfigure(string, Category.defaultHierarchy);
    }

    public static void configure(URL uRL) {
        new PropertyConfigurator().doConfigure(uRL, Category.defaultHierarchy);
    }

    public static void configure(Properties properties) {
        new PropertyConfigurator().doConfigure(properties, Category.defaultHierarchy);
    }

    public static void configureAndWatch(String string) {
        PropertyConfigurator.configureAndWatch(string, 60000L);
    }

    public static void configureAndWatch(String string, long l) {
        PropertyWatchdog propertyWatchdog = new PropertyWatchdog(string);
        propertyWatchdog.setDelay(l);
        propertyWatchdog.start();
    }

    public void doConfigure(Properties properties, Hierarchy hierarchy) {
        String string = properties.getProperty("log4j.configDebug");
        if (string != null) {
            LogLog.setInternalDebugging(OptionConverter.toBoolean(string, true));
        }
        String string2 = properties.getProperty("log4j.disableOverride");
        BasicConfigurator.overrideAsNeeded(string2);
        this.configureRootCategory(properties, hierarchy);
        this.configureCategoryFactory(properties);
        this.parseCatsAndRenderers(properties, hierarchy);
        LogLog.debug("Finished configuring.");
        this.registry.clear();
    }

    public void doConfigure(URL uRL, Hierarchy hierarchy) {
        Properties properties = new Properties();
        LogLog.debug("Reading configuration from URL " + uRL);
        try {
            properties.load(uRL.openStream());
        }
        catch (IOException iOException) {
            LogLog.error("Could not read configuration file from URL [" + uRL + "].", iOException);
            LogLog.error("Ignoring configuration file [" + uRL + "].");
            return;
        }
        this.doConfigure(properties, hierarchy);
    }

    void configureCategoryFactory(Properties properties) {
        String string = OptionConverter.findAndSubst(CATEGORY_FACTORY_KEY, properties);
        if (string != null) {
            LogLog.debug("Setting category factory to [" + string + "].");
            this.categoryFactory = (CategoryFactory)OptionConverter.instantiateByClassName(string, class$Lorg$apache$log4j$spi$CategoryFactory != null ? class$Lorg$apache$log4j$spi$CategoryFactory : (class$Lorg$apache$log4j$spi$CategoryFactory = PropertyConfigurator.class$("org.apache.log4j.spi.CategoryFactory")), this.categoryFactory);
        }
    }

    void configureOptionHandler(OptionHandler optionHandler, String string, Properties properties) {
        String[] stringArray = optionHandler.getOptionStrings();
        if (stringArray == null) {
            return;
        }
        int n = 0;
        while (n < stringArray.length) {
            String string2 = OptionConverter.findAndSubst(string + stringArray[n], properties);
            LogLog.debug("Option " + stringArray[n] + "=[" + (string2 == null ? "null" : string2) + "].");
            if (string2 != null) {
                optionHandler.setOption(stringArray[n], string2);
            }
            ++n;
        }
        optionHandler.activateOptions();
    }

    void configureRootCategory(Properties properties, Hierarchy hierarchy) {
        String string = OptionConverter.findAndSubst(ROOT_CATEGORY_PREFIX, properties);
        if (string == null) {
            LogLog.debug("Could not find root category information. Is this OK?");
        } else {
            Category category;
            Category category2 = category = hierarchy.getRoot();
            synchronized (category2) {
                this.parseCategory(properties, category, ROOT_CATEGORY_PREFIX, INTERNAL_ROOT_NAME, string);
            }
        }
    }

    protected void parseCatsAndRenderers(Properties properties, Hierarchy hierarchy) {
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string;
            String string2;
            String string3 = (String)enumeration.nextElement();
            if (string3.startsWith(CATEGORY_PREFIX)) {
                Category category;
                string2 = string3.substring(CATEGORY_PREFIX.length());
                string = OptionConverter.findAndSubst(string3, properties);
                Category category2 = category = hierarchy.getInstance(string2, this.categoryFactory);
                synchronized (category2) {
                    this.parseCategory(properties, category, string3, string2, string);
                    this.parseAdditivityForCategory(properties, category, string2);
                    continue;
                }
            }
            if (!string3.startsWith(RENDERER_PREFIX)) continue;
            string2 = string3.substring(RENDERER_PREFIX.length());
            string = OptionConverter.findAndSubst(string3, properties);
            this.addRenderer(string2, string);
        }
    }

    void parseAdditivityForCategory(Properties properties, Category category, String string) {
        String string2 = OptionConverter.findAndSubst(ADDITIVITY_PREFIX + string, properties);
        LogLog.debug("Handling log4j.additivity." + string + "=[" + string2 + "]");
        if (string2 != null && !string2.equals("")) {
            boolean bl = OptionConverter.toBoolean(string2, true);
            LogLog.debug("Setting additivity for \"" + string + "\" to " + bl);
            category.setAdditivity(bl);
        }
    }

    void parseCategory(Properties properties, Category category, String string, String string2, String string3) {
        Object object;
        LogLog.debug("Parsing for [" + string2 + "] with value=[" + string3 + "].");
        StringTokenizer stringTokenizer = new StringTokenizer(string3, ",");
        if (!string3.startsWith(",") && !string3.equals("")) {
            if (!stringTokenizer.hasMoreTokens()) {
                return;
            }
            object = stringTokenizer.nextToken();
            LogLog.debug("Priority token is [" + (String)object + "].");
            if (((String)object).equalsIgnoreCase("inherited") && !string2.equals(INTERNAL_ROOT_NAME)) {
                category.setPriority(null);
            } else {
                category.setPriority(Priority.toPriority((String)object));
            }
            LogLog.debug("Category " + string2 + " set to " + category.getPriority());
        }
        category.removeAllAppenders();
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken().trim();
            if (string4 == null || string4.equals(",")) continue;
            LogLog.debug("Parsing appender named \"" + string4 + "\".");
            object = this.parseAppender(properties, string4);
            if (object == null) continue;
            category.addAppender((Appender)object);
        }
    }

    Appender parseAppender(Properties properties, String string) {
        Appender appender = this.registryGet(string);
        if (appender != null) {
            LogLog.debug("Appender \"" + string + "\" was already parsed.");
            return appender;
        }
        String string2 = APPENDER_PREFIX + string;
        String string3 = string2 + ".layout";
        appender = (Appender)OptionConverter.instantiateByKey(properties, string2, class$Lorg$apache$log4j$Appender != null ? class$Lorg$apache$log4j$Appender : (class$Lorg$apache$log4j$Appender = PropertyConfigurator.class$("org.apache.log4j.Appender")), null);
        if (appender == null) {
            LogLog.error("Could not instantiate appender named \"" + string + "\".");
            return null;
        }
        appender.setName(string);
        if (appender instanceof OptionHandler) {
            Layout layout;
            this.configureOptionHandler((OptionHandler)((Object)appender), string2 + ".", properties);
            LogLog.debug("Parsed \"" + string + "\" options.");
            if (appender.requiresLayout() && (layout = (Layout)OptionConverter.instantiateByKey(properties, string3, class$Lorg$apache$log4j$Layout != null ? class$Lorg$apache$log4j$Layout : (class$Lorg$apache$log4j$Layout = PropertyConfigurator.class$("org.apache.log4j.Layout")), null)) != null) {
                appender.setLayout(layout);
                LogLog.debug("Parsing layout options for \"" + string + "\".");
                this.configureOptionHandler(layout, string3 + ".", properties);
                LogLog.debug("End of parsing for \"" + string + "\".");
            }
        }
        this.registryPut(appender);
        return appender;
    }

    void registryPut(Appender appender) {
        this.registry.put(appender.getName(), appender);
    }

    Appender registryGet(String string) {
        return (Appender)this.registry.get(string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

