#ifndef __NM_LINUX_A_H__
#define __NM_LINUX_A_H__

/*
Copyright (C) 1998, 1999, 2000 Wabasoft

This program is free software; you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by the Free Software
Foundation; either version 2 of the License, or (at your option) any later version. 

This program is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
PARTICULAR PURPOSE. See the GNU General Public License for more details. 

You should have received a copy of the GNU General Public License along with
this program; if not, write to the Free Software Foundation, Inc., 675 Mass Ave,
Cambridge, MA 02139, USA. 
*/

/*
Copyright (C) 2000, 2001 SMARTDATA, http://www.smartdata.ch/

More help for porting is include in the file nmport_a.c. Please read it before
porting or modify this port.

Linux port.
===========

*/

/* all the needed include */
#include <stdlib.h>
#include <string.h>

#ifndef LINUX
# error You must define the LINUX symbol as gcc parameter (-DLINUX=1)
#endif

#define FREE_ON_EXIT 1
#undef SECURE_CLASS_HEAP //#define SECURE_CLASS_HEAP 1

#ifdef SECURE_CLASS_HEAP
# define LOCK_CLASS_HEAP MemSemaphoreReserve(1);
# define UNLOCK_CLASS_HEAP MemSemaphoreRelease(1);
#else
# define LOCK_CLASS_HEAP ;
# define UNLOCK_CLASS_HEAP ;
#endif

/********************************************************************************
                                 TYPE DEFINITIONS
********************************************************************************/

/* for the types, we use the GLib library of the GTK project.
   See http://www.gtk.org for more informations                */

#ifdef USE_GLIB

/* use glib for types */

    #include <glib.h>

#else

/* we don't use glib, so we need to define g... types */

    #define guchar unsigned char
    #define gint32 int
    #define guint32 unsigned int
    #define gfloat float
    #define gint16 short
    #define guint16 unsigned short
    #define gint int
    #define guint unsigned int
    #define gchar char

    #define TRUE 1
    #define FALSE 0

#endif

// - uchar is an 8 bit unsigned value
#define uchar guchar

// - int32 is a signed 32 bit value
#define int32 gint32

// - uint32 is an unsigned 32 bit value
#define uint32 guint32

// - float32 is a signed 32 bit floating point value
#define float32 gfloat

// - int16 is a signed 16 bit value
#define int16 gint16

// - uint16 is an unsigned 16 bit value
#define uint16 guint16

/********************************************************************************
                                    TYPE CONVERTERS
********************************************************************************/

#ifdef FASTANDBIG

# define getUInt32(b) (uint32)( (uint32)((b)[0])<<24 | \
                                (uint32)((b)[1])<<16 | \
				(uint32)((b)[2])<<8  |
				(uint32)((b)[3]) )
# define getUInt16(b) (uint16)( ((b)[0]<<8)|(b)[1] )
# define getInt32(b)  (int32) ( (uint32)((b)[0])<<24 | \
                                (uint32)((b)[1])<<16 | \
				(uint32)((b)[2])<<8  |
				(uint32)((b)[3]) )
# define getInt16(b) (int16)  ( ((b)[0]<<8)|(b)[1] )

#else 

uint32 getUInt32(uchar *b);
uint16 getUInt16(uchar *b);
int32 getInt32(uchar *b);
int16 getInt16(uchar *b);

#endif  /* ifdef FASTANDBIG */

float32 getFloat32(uchar *buf);

/********************************************************************************
                                  "STRING" FUNCTIONS
********************************************************************************/

#define xstrncmp(s1, s2, n) strncmp(s1, s2, n)
#define xstrncpy(dst, src, n) strncpy(dst, src, (ULong)n)
#define xstrlen(s) strlen(s)
#define xstrcat(dst, src) strcat(dst, src)
#define xmemmove(dst, src, size) memmove(dst, src, size)
#define xmemzero(mem, len) memset(mem, len, (Byte)0)

/********************************************************************************
                            DYNAMIC ALLOCATION FUNCTIONS
********************************************************************************/

#define xmalloc(size) malloc(size)
#define xfree(p) free(p)

/******************** TO REMOVE *********************/

#include <stdio.h>


/********************************************************************
 * Elementary data types
 ********************************************************************/


// Fixed size data types
typedef char            SByte;      // 8 bits
#ifndef __TYPES__                   // (Already defined in CW11)
typedef unsigned char   Byte;
#endif

typedef short           SWord;      // 16 bits
typedef unsigned short  Word;       

typedef long            SDWord;     // 32 bits
typedef unsigned long   DWord;      


// Logical data types
#ifndef __TYPES__                   // (Already defined in CW11)
typedef unsigned char   Boolean;
#endif

typedef char            Char;       // Used for character strings
typedef unsigned char   UChar;

typedef short           Short;      // >= Byte
typedef unsigned short  UShort;

typedef short           Int;        // >= Word (use short so MPW and CW agree)
typedef unsigned short  UInt;          

typedef long            Long;       // >= DWord
typedef unsigned long   ULong;

typedef short           Err;

typedef DWord           LocalID;    // local (card relative) chunk ID



/************************************************************
 * Pointer Types
 *************************************************************/ 
typedef void*           VoidPtr;
typedef VoidPtr*        VoidHand;


// Fixed size data types
typedef SByte*          SBytePtr;
#ifndef __TYPES__                   // (Already defined in CW11)
typedef Byte*           BytePtr;
#endif

typedef SWord*          SWordPtr;
typedef Word*           WordPtr;

typedef SDWord*         SDWordPtr;
typedef DWord*          DWordPtr;


// Logical data types
typedef Boolean*        BooleanPtr;

typedef Char*           CharPtr;
typedef UChar*          UCharPtr;

typedef Short*          ShortPtr;
typedef UShort*         UShortPtr;

typedef Int*            IntPtr;
typedef UInt*           UIntPtr;

typedef Long*           LongPtr;
typedef ULong*          ULongPtr;

// Include the following typedefs if types.h wasn't read.
#ifndef __TYPES__

// Generic Pointer types used by Memory Manager
// We have to define Ptr as char* because that's what the Mac includes do.
typedef char*           Ptr;              // global pointer
typedef Ptr*            Handle;           // global handle

// Function types
typedef Long (*ProcPtr)();

#endif /* __TYPES__ */



/************************************************************
 * Common constants
 *************************************************************/
#ifndef NULL
# define NULL   0
#endif   // NULL

// Include the following typedefs if types.h wasn't read.
#ifndef __TYPES__
  #ifdef __MWERKS__
    #if !__option(bool)
      #ifndef true
        #define true         1
      #endif
      #ifndef false
        #define false        0
      #endif
    #endif
  #else
    enum {false, true};
  #endif
#endif /* __TYPES__ */

#endif /* __NM_LINUX_A_H__ */

/*
   Local Variables:
   c-file-style: "smartdata"
   End:
*/
