#ifndef __NM_LINUX_C_H__
#define __NM_LINUX_C_H__

/*
Copyright (C) 1998, 1999, 2000 Wabasoft

This program is free software; you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by the Free Software
Foundation; either version 2 of the License, or (at your option) any later version. 

This program is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
PARTICULAR PURPOSE. See the GNU General Public License for more details. 

You should have received a copy of the GNU General Public License along with
this program; if not, write to the Free Software Foundation, Inc., 675 Mass Ave,
Cambridge, MA 02139, USA. 
*/

/*

Copyright (C) 2000, 2001 SMARTDATA, http://www.smartdata.ch/

More help for porting is include in the file nmport_c.c. Please read it before
porting or modify this port.

Linux port.
===========

*/

/* default font parameters */
#define DEFAULT_FONT "helvetica"
#define DEFAULT_FONT_SIZE 10

/* usefull for some implementation, like Solaris */
#ifndef INADDR_NONE
#define INADDR_NONE ((unsigned long) -1)
#endif

void WindowDestroy(WObject obj);
void MainWinDestroy(WObject obj);
void GraphicsDestroy(WObject obj);
void ImageDestroy(WObject obj);
void CatalogDestroy(WObject obj);
void FileDestroy(WObject obj);
void SocketDestroy(WObject obj);
void SerialPortDestroy(WObject obj);

/* to have a explanation of the following structure, see the the file nmport_c.c
   and my small explanation of how to access class variable below                */
extern ClassHook classHooks[];

#define FUNC(f) extern Var f (Var stack[])

/* all the native functions */

FUNC(VmPrintLn);
FUNC(VmPrint);
FUNC(VmExec);
FUNC(VmGetTimeStamp);
FUNC(copyArray);
FUNC(VmSleep);
FUNC(VmSetDeviceAutoOff);
FUNC(VmGetUserName);
FUNC(VmGetPlatform);
FUNC(VmIsColor);
FUNC(FileGetLength);
FUNC(FileCreateDir);
FUNC(FileReadBytes);
FUNC(FileRename);
FUNC(FileCreate);
FUNC(FileWriteBytes);
FUNC(FileListDir);
FUNC(FileSeekWaba);
FUNC(FileIsDir);
FUNC(FileCloseWaba);
FUNC(FileIsOpen);
FUNC(FileDeleteWaba);
FUNC(FileExists);
FUNC(ImageCreate);
FUNC(ImageFree);
FUNC(ImageSetPixels);
FUNC(ImageUseImagePalette);
FUNC(ImageLoad);
FUNC(SoundBeep);
FUNC(SoundTone);
FUNC(TimeCreate);
FUNC(SocketCreate);
FUNC(SocketRead);
FUNC(SocketWrite);
FUNC(SocketSetReadTimeout);
FUNC(SocketClose);
FUNC(SocketIsOpen);
FUNC(WindowCreate);
FUNC(CatalogListCatalogs);
FUNC(CatalogAddRecord);
FUNC(CatalogSkipBytes);
FUNC(CatalogCreate);
FUNC(CatalogRead);
FUNC(CatalogDeleteRecord);
FUNC(CatalogSetRecordPos);
FUNC(CatalogGetRecordSize);
FUNC(CatalogResizeRecord);
FUNC(CatalogWrite);
FUNC(CatalogGetRecordCount);
FUNC(CatalogClose);
FUNC(CatalogIsOpen);
FUNC(CatalogDelete);
FUNC(GraphicsCopyRect);
FUNC(GraphicsClearClip);
FUNC(GraphicsSetFont);
FUNC(GraphicsSetDrawOp);
FUNC(GraphicsSetClip);
FUNC(GraphicsSetBackColor);
FUNC(GraphicsSetColor);
FUNC(GraphicsGetClip);
FUNC(GraphicsFillRect);
FUNC(GraphicsDrawLine);
FUNC(GraphicsTranslate);
FUNC(GraphicsDrawDots);
FUNC(GraphicsDrawChars);
FUNC(GraphicsCreate);
FUNC(GraphicsDrawCursor);
FUNC(GraphicsSetClip);
FUNC(GraphicsFree);
FUNC(GraphicsSetForeColor);
FUNC(GraphicsSetTextColor);
FUNC(GraphicsFillPolygon);
FUNC(GraphicsDrawString);
FUNC(ConvertStringToInt);
FUNC(ConvertFloatToIntBitwise);
FUNC(ConvertCharToString);
FUNC(ConvertIntToFloatBitwise);
FUNC(ConvertFloatToString);
FUNC(ConvertIntToString);
FUNC(ConvertBooleanToString);
FUNC(SoundClipPlay);
FUNC(PalmOsPrefSetPalmOsPref);
FUNC(PalmOsPrefGetPalmOsPref);
FUNC(MainWinCreate);
FUNC(MainWinExit);
FUNC(MainWinSetTimerInterval);
FUNC(SerialPortReadCheck);
FUNC(SerialPortRead);
FUNC(SerialPortWrite);
FUNC(SerialPortSetReadTimeout);
FUNC(SerialPortClose);
FUNC(SerialPortSetFlowControl);
FUNC(SerialPortIsOpen);
FUNC(SerialPortCreate);
FUNC(FontMetricsGetStringWidth);
FUNC(FontMetricsGetCharWidth);
FUNC(FontMetricsCreate);
FUNC(FontMetricsGetCharArrayWidth);

/*************************************************************************
                               class waba/fx/Rect
*************************************************************************/

// var[0] = Class
// var[1] = int x
// var[2] = int y
// var[3] = int width
// var[4] = int height

#define WOBJ_RectX(o) (objectPtr(o))[1].intValue
#define WOBJ_RectY(o) (objectPtr(o))[2].intValue
#define WOBJ_RectWidth(o) (objectPtr(o))[3].intValue
#define WOBJ_RectHeight(o) (objectPtr(o))[4].intValue

/*************************************************************************
                               class waba/ui/Control
*************************************************************************/

// var[0] = Class
// var[1] = int x
// var[2] = int y
// var[3] = int width
// var[4] = int height

#define WOBJ_ControlX(o) (objectPtr(o))[1].intValue
#define WOBJ_ControlY(o) (objectPtr(o))[2].intValue
#define WOBJ_ControlWidth(o) (objectPtr(o))[3].intValue
#define WOBJ_ControlHeight(o) (objectPtr(o))[4].intValue

/*************************************************************************
                               class waba/ui/Window
*************************************************************************/

// var[0] = Class
// var[n] = ...other locals...
// var[n + 1] = hook var - a pointer to the MainWindow
// var[n + 2] = hook var - boolean if the Window allready a pixmap or not
//

// since Window inherits from other classes, we need to calculate the
// right base offset to start with when reading/writing to variables
extern int _winHookOffset;

#define WOBJ_WindowMain(o) (objectPtr(o))[_winHookOffset + 0].refValue
#define WOBJ_WindowHookVars 1   /* number of hook var for Window */

/*************************************************************************
                               class waba/ui/MainWindow
*************************************************************************/

// var[0] = Class
// var[n] = ...other locals...
// var[n + 1] = hook var -
//

extern int _mainWinHookOffset;

#define WOBJ_MainWinTimer(o) (objectPtr(o))[_mainWinHookOffset + 0].intValue
#define WOBJ_MainWinHookVars 1   /* number of hook var for MainWindow */

/*************************************************************************
                               class waba/fx/Image
*************************************************************************/

// var[0] = Class
// var[1] = width
// var[2] = height
// var[3] = hook var - pointer to the pixmap image

#define WOBJ_ImageWidth(o) (objectPtr(o))[1].intValue
#define WOBJ_ImageHeight(o) (objectPtr(o))[2].intValue
#define WOBJ_ImagePixmap(o) (objectPtr(o))[3].refValue

/*************************************************************************
                               class waba/io/Socket
*************************************************************************/

// var[0] = Class
// var[1] = hook var - Socket Id (int32)
//

// NOTE: The SOCKET type is an unsigned 32 bit quantity - this most closely
// matches the object type
#define WOBJ_SocketFD(o) (objectPtr(o))[1].intValue

/*************************************************************************
                               class waba/fx/Font
*************************************************************************/

// var[0] = Class
// var[1] = String name
// var[2] = int size
// var[3] = int style
//

#define WOBJ_FontName(o) (objectPtr(o))[1].obj
#define WOBJ_FontStyle(o) (objectPtr(o))[2].intValue
#define WOBJ_FontSize(o) (objectPtr(o))[3].intValue 

#define Font_PLAIN 0
#define Font_BOLD 1

/*************************************************************************
                               class waba/fx/FontMetrics
*************************************************************************/

// var[0] = Class
// var[1] = Font
// var[2] = Surface
// var[3] = int ascent
// var[4] = int descent
// var[5] = int leading

#define WOBJ_FontMetricsFont(o) (objectPtr(o))[1].obj
#define WOBJ_FontMetricsSurface(o) (objectPtr(o))[2].obj
#define WOBJ_FontMetricsAscent(o) (objectPtr(o))[3].intValue
#define WOBJ_FontMetricsDescent(o) (objectPtr(o))[4].intValue
#define WOBJ_FontMetricsLeading(o) (objectPtr(o))[5].intValue

/* what type of width we can compute */
#define FM_STRINGWIDTH 1
#define FM_CHARARRAYWIDTH 2
#define FM_CHARWIDTH 3

/*************************************************************************
                               class waba/fx/Graphics
*************************************************************************/

// var[0] = Class
// var[1] = Surface
// var[2] = hook var - isValid flag
// var[3] = hook var - pointer to the main window, NULL if it's an Image
// var[4] = hook var - pointer to the Pixmap if it's an Image, NULL otherwise
// var[5] = hook var - pointer to the drawing pixmap where all draw are made
// var[6] = hook var - pointer to the used font
// var[7] = hook var - the start x of the clip region
// var[8] = hook var - the start y of the clip region
// var[9] = hook var - the width of the clip region
// var[10] = hook var - the height of the clip region
// var[11] = hook var - the operation used for the draw (AND/OR/XOR...)
// var[12] = hook var - the value of the red color used for the draw
// var[13] = hook var - the value of the green color used for the draw
// var[14] = hook var - the value of the blue color used for the draw
// var[15] = hook var - the X used for translation
// var[16] = hook var - the Y used for translation

#define WOBJ_GraphicsSurface(o) (objectPtr(o))[1].obj
#define WOBJ_GraphicsIsValid(o) (objectPtr(o))[2].intValue
#define WOBJ_GraphicsWindowMain(o) (objectPtr(o))[3].refValue
#define WOBJ_GraphicsPixmap(o) (objectPtr(o))[4].refValue
#define WOBJ_GraphicsDrawingPixmap(o) (objectPtr(o))[5].refValue
#define WOBJ_GraphicsFont(o) (objectPtr(o))[6].refValue
#define WOBJ_GraphicsClipRegionX(o) (objectPtr(o))[7].intValue
#define WOBJ_GraphicsClipRegionY(o) (objectPtr(o))[8].intValue
#define WOBJ_GraphicsClipRegionW(o) (objectPtr(o))[9].intValue
#define WOBJ_GraphicsClipRegionH(o) (objectPtr(o))[10].intValue
#define WOBJ_GraphicsDrawOp(o) (objectPtr(o))[11].intValue
#define WOBJ_GraphicsRED(o) (objectPtr(o))[12].intValue
#define WOBJ_GraphicsGREEN(o) (objectPtr(o))[13].intValue
#define WOBJ_GraphicsBLUE(o) (objectPtr(o))[14].intValue
#define WOBJ_GraphicsTransX(o) (objectPtr(o))[15].intValue
#define WOBJ_GraphicsTransY(o) (objectPtr(o))[16].intValue

/* how we can draw */
#define DRAW_OVER 1
#define DRAW_AND 2
#define DRAW_OR 3
#define DRAW_XOR 4

/* some constants giving the existing type of drawing */
#define GR_FILLRECT   0
#define GR_DRAWLINE   1
#define GR_FILLPOLY   2
#define GR_DRAWCHARS  3
#define GR_DRAWSTRING 4
#define GR_DOTS       5
#define GR_COPYRECT   6
#define GR_DRAWCURSOR 7

/* existing surface type */
#define SURF_UNKNOWN 0
#define SURF_WINDOW 1
#define SURF_IMAGE 2

/*************************************************************************
                               class waba/fx/SoundClip
*************************************************************************/

// var[0] = Class
// var[1] = path
// var[2] = loaded

#define WOBJ_SoundClipPath(o) (objectPtr(o))[1].obj
#define WOBJ_SoundClipLoaded(o) (objectPtr(o))[2].intValue

/*************************************************************************
                               class waba/io/Catalog
As linux has no catalog, this is not implemented at this time
*************************************************************************/

// var[0] = Class
// var[1] = hook var - database handle (null if no open db)
// var[2] = hook var - database oid
// var[3] = hook var - current record position
// var[4] = hook var - current record oid
// var[5] = hook var - current record memory pointer
// var[6] = hook var - current record memory allocation pointer
// var[7] = hook var - length of current record
// var[8] = hook var - current offset in record
// var[9] = hook var - 1 if record has been modified, 0 otherwise

#define WOBJ_CatalogHandle(o) (objectPtr(o))[1].refValue
#define WOBJ_CatalogOID(o) (objectPtr(o))[2].refValue
#define WOBJ_CatalogCurRecPos(o) (objectPtr(o))[3].intValue
#define WOBJ_CatalogCurRecOid(o) (objectPtr(o))[4].refValue
#define WOBJ_CatalogCurRecPtr(o) (objectPtr(o))[5].refValue
#define WOBJ_CatalogCurRecAllocPtr(o) (objectPtr(o))[6].refValue
#define WOBJ_CatalogCurRecLen(o) (objectPtr(o))[7].intValue
#define WOBJ_CatalogCurRecOffset(o) (objectPtr(o))[8].intValue
#define WOBJ_CatalogCurRecModified(o) (objectPtr(o))[9].intValue

#define Catalog_READ_ONLY 1
#define Catalog_WRITE_ONLY 2
#define Catalog_READ_WRITE 3
#define Catalog_CREATE 4

#define Catalog_CEDBTYPE 4141

/*************************************************************************
                               class waba/io/File
*************************************************************************/

// var[0] = Class
// var[1] = String name
// var[2] = int mode
// var[3] = hook var - file handle

#define WOBJ_FileName(o) (objectPtr(o))[1].obj
#define WOBJ_FileMode(o) (objectPtr(o))[2].intValue
#define WOBJ_FileHandle(o) (objectPtr(o))[3].refValue

#define File_DONT_OPEN 0
#define File_READ_ONLY 1
#define File_WRITE_ONLY 2
#define File_READ_WRITE 3
#define File_CREATE 4

/* some file operation */
#define FILE_CREATE_DIR 1
#define FILE_IS_DIR 2
#define FILE_DELETE 3
#define FILE_RENAME 4
#define FILE_EXISTS 5

/*************************************************************************
                               class waba/io/SerialPort
*************************************************************************/

// var[0] = Class
// var[1] = hook var - Handle

#define WOBJ_SerialPortHandle(o) (objectPtr(o))[1].refValue

/*************************************************************************
                               class waba/sys/Time
*************************************************************************/

// var[0] = Class
// var[1] = int year
// var[2] = int month
// var[3] = int day
// var[4] = int hour
// var[5] = int minute
// var[6] = int second
// var[7] = int millis

#define WOBJ_TimeYear(o) (objectPtr(o))[1].intValue
#define WOBJ_TimeMonth(o) (objectPtr(o))[2].intValue
#define WOBJ_TimeDay(o) (objectPtr(o))[3].intValue
#define WOBJ_TimeHour(o) (objectPtr(o))[4].intValue
#define WOBJ_TimeMinute(o) (objectPtr(o))[5].intValue
#define WOBJ_TimeSecond(o) (objectPtr(o))[6].intValue
#define WOBJ_TimeMillis(o) (objectPtr(o))[7].intValue

/*************************************************************************
                   functions implemented in ui_xxx.c
*************************************************************************/

/* for the fonts */
ui_FontType *ui_FontCreate( WObject font );
void ui_FontDelete( ui_FontType *theFont );
gint ui_TextWidth( char *theText, ui_FontType *theFont );
gint ui_CharWidth( char theChar, ui_FontType *theFont );
void ui_FontSetProperties( ui_FontType *theFont, WObject fontMetrics );
gint ui_FontGetYOffset( ui_FontType *theFont );

/* for the draw */
ui_PixmapType *ui_createDrawingPixmap( ui_MainWindowType *mw, ui_Rectangle rect );
ui_GraphicsContextType *ui_createGC( WObject gr );
void ui_deleteGC( ui_GraphicsContextType *theGC );
void ui_setTheDrawFunction( ui_GraphicsContextType *theGC, gint32 drawOp );
void ui_ClipTo( ui_GraphicsContextType *theGC, ui_Rectangle rect );
void ui_SetColor( ui_GraphicsContextType *theGC, gint red, gint green, gint blue );
void ui_DrawPixel( ui_PixmapType *drawingPixmap, ui_GraphicsContextType *theGC, gint x, gint y );
void ui_DrawLine( ui_PixmapType *drawingPixmap, ui_GraphicsContextType *theGC, gint x1, gint y1, gint x2, gint y2 );
void ui_DrawText( ui_PixmapType *drawingPixmap, ui_GraphicsContextType *theGC, gint x, gint y, char *theText, ui_FontType *theFont );
void ui_DrawFilledRect( ui_PixmapType *drawingPixmap, ui_GraphicsContextType *theGC, gint x, gint y, gint w, gint h );
void ui_GraphicsRepaint( WObject graphics, ui_PixmapType *drawingPixmap, ui_GraphicsContextType *gc );

/* for translating the key code to a waba key code */
int32 ui_TranslateKey( Word chr );

#endif /* __NM_LINUX_A_H__ */

/*
   Local Variables:
   c-file-style: "smartdata"
   End:
*/

