/*
   Copyright (C) 2000, 2001 SMARTDATA, http://www.smartdata.ch/

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

/*

    GTK Port. See http://www.gtk.org/ for more informations

*/

#include "../waba.h"

g_error sucess = {ERRT_NONE,NULL};

g_error mkerror(unsigned char type, char *msg) {
  g_error e = {type,msg};
  return e;
}

g_error prerror(g_error e) {
  if (e.type == ERRT_NONE) return sucess;
  if (!e.msg) e.msg = "?";
  printf("*** ERROR (");
  switch (e.type) {
  case ERRT_MEMORY: printf("MEMORY"); break;
  case ERRT_IO: printf("IO"); break;
  case ERRT_NETWORK: printf("NETWORK"); break;
  case ERRT_BADPARAM: printf("BADPARAM"); break;
  case ERRT_HANDLE: printf("HANDLE"); break;
  case ERRT_INTERNAL: printf("INTERNAL"); break;
  default: printf("?");
  }
  printf(") : %s\n",e.msg);
  return e;
}

/*****************************************************************************/


gint expose_event (GtkWidget *widget, GdkEventExpose *event) {
    GdkGC *theGC;
    GdkPixmap *drawingPixmap;

    theGC = gdk_gc_new( widget->window );
    drawingPixmap = gtk_object_get_data( GTK_OBJECT( widget ), "pixmap" );

    if( drawingPixmap ) {

      gdk_draw_pixmap( widget->window, theGC, drawingPixmap,
		       event->area.x, event->area.y,
		       event->area.x, event->area.y,
		       event->area.width, event->area.height );

    }

    /* release the memory */
    gdk_gc_unref( theGC );

    return TRUE;

}

gint delete_event( GtkWidget *widget,
		   GdkEvent  *event,
		   gpointer   data ) {
  struct ui_Event ui_event;
  int stay;
  
     /* If you return FALSE in the "delete_event" signal handler,
      * GTK will emit the "destroy" signal. Returning TRUE means
      * you don't want the window to be destroyed.
      * This is useful for popping up 'are you sure you want to quit?'
      * type dialogs. */

  ui_event.type = quitEvent;

  stay = !handleMainWinEvent( &ui_event );

  return( stay );

}

/* Another callback */
void destroy( GtkWidget *widget,
	      gpointer   data ) {
  struct ui_Event ui_event;
  int quit;

  ui_event.type = quitEvent;

  quit = handleMainWinEvent( &ui_event );

  gtk_main_quit();

 }

gint motion_notify_event( GtkWidget *widget, GdkEventMotion *event ) {
  int x, y;
  GdkModifierType state;
  struct ui_Event ui_event;
  int quit;

  if( event->is_hint ) {

    gdk_window_get_pointer (event->window, &x, &y, &state);

  } else {

    x = event->x;
    y = event->y;
    state = event->state;

  }
     
  ui_event.type = penMoveEvent;
  ui_event.x = x;
  ui_event.y = y;
  ui_event.code = 0;

  quit = handleMainWinEvent( &ui_event );

  return TRUE;

}

gint clicked_notify_event( GtkWidget *widget, GdkEventButton *event ) {
  int x, y;
  GdkModifierType state;
  struct ui_Event ui_event;
  int quit;

  gdk_window_get_pointer( event->window, &x, &y, &state );
  ui_event.x = x;
  ui_event.y = y;
  ui_event.code = 0;

  switch( event->type ) {
  case GDK_BUTTON_PRESS:
    ui_event.type = penDownEvent;
    break;
  case GDK_2BUTTON_PRESS:
    ui_event.type = penDownEvent;
    break;
  case GDK_3BUTTON_PRESS:
    ui_event.type = penDownEvent;
    break;
  case GDK_BUTTON_RELEASE:
    ui_event.type = penUpEvent;
    break;
  default:
    ui_event.type = penDownEvent;
    break;
  }

  quit = handleMainWinEvent( &ui_event );

  return TRUE;

}

gint key_notify_event( GtkWidget *widget, GdkEventKey *event ) {
  int x, y;
  GdkModifierType state;
  struct ui_Event ui_event;
  int quit;

  gdk_window_get_pointer( event->window, &x, &y, &state );
  ui_event.x = x;
  ui_event.y = y;
  ui_event.code = 0;

  switch( event->type ) {
  case GDK_KEY_PRESS:
    ui_event.type = keyDownEvent;
    ui_event.code = event->keyval;
    break;
  case GDK_KEY_RELEASE:
    ui_event.type = keyUpEvent;
    ui_event.code = event->keyval;
    break;
  default:
    ui_event.type = keyDownEvent;
    ui_event.code = event->keyval;
    break;
  }

  quit = handleMainWinEvent( &ui_event );

  return TRUE;

}

void *hwr_init() {
/* open the mainwindow and init the hardware */

     //BOR TODO : get the correct argc and argv
     int argc = 1;
     char **argv;
     GtkWidget *MainWindow = NULL;

     argv = malloc( 2 * sizeof( char *));
     argv[0] = malloc( sizeof( char ) * ( strlen( "waba_x86" ) + 1 ));
     strcpy( argv[0], "waba_x86" );
     argv[1] = malloc( sizeof( char ) * ( strlen( "none" ) + 1 ));
     strcpy( argv[1], "none" );

     gtk_init (&argc, &argv);
     gdk_rgb_init();

     /* create the main window */
     MainWindow = gtk_window_new (GTK_WINDOW_TOPLEVEL);

     /* set the size of the main window */
     gtk_window_set_default_size( GTK_WINDOW( MainWindow ), hwr_width, hwr_height );

     /* connect the "expose_event" to active the repaint of some portion
	of the screen */
     gtk_signal_connect_after (GTK_OBJECT (MainWindow), "expose_event",
                         GTK_SIGNAL_FUNC (expose_event), NULL);


    /* When the window is given the "delete_event" signal (this is given
      * by the window manager, usually by the "close" option, or on the
      * titlebar), we ask it to call the delete_event () function
      * as defined above. The data passed to the callback
      * function is NULL and is ignored in the callback function. */
     gtk_signal_connect (GTK_OBJECT (MainWindow), "delete_event",
                         GTK_SIGNAL_FUNC (delete_event), NULL);
     
     /* Here we connect the "destroy" event to a signal handler.  
      * This event occurs when we call gtk_widget_destroy() on the window,
      * or if we return FALSE in the "delete_event" callback. */
     gtk_signal_connect (GTK_OBJECT (MainWindow), "destroy",
                         GTK_SIGNAL_FUNC (destroy), NULL);
     

     gtk_signal_connect( GTK_OBJECT( MainWindow ), "motion_notify_event",
			 GTK_SIGNAL_FUNC( motion_notify_event ), NULL);
     gtk_signal_connect( GTK_OBJECT( MainWindow ), "button_press_event",
                       GTK_SIGNAL_FUNC( clicked_notify_event ), NULL);
     gtk_signal_connect( GTK_OBJECT( MainWindow ), "button_release_event",
                       GTK_SIGNAL_FUNC( clicked_notify_event ), NULL);
     gtk_signal_connect( GTK_OBJECT( MainWindow ), "key_press_event",
                       GTK_SIGNAL_FUNC( key_notify_event ), NULL);
     gtk_signal_connect( GTK_OBJECT( MainWindow ), "key_release_event",
                       GTK_SIGNAL_FUNC( key_notify_event ), NULL);

     gtk_widget_set_events( MainWindow,
			    GDK_POINTER_MOTION_MASK 
			    | GDK_BUTTON_PRESS_MASK 
			    | GDK_BUTTON_RELEASE_MASK
			    | GDK_KEY_PRESS_MASK
			    | GDK_KEY_RELEASE_MASK
			    | GDK_EXPOSURE_MASK );


     gtk_widget_show  (MainWindow);

     return MainWindow;

}

void hwr_release() {
  // TODO:
}

void hwr_clear() {
}

void hwr_update() {
}

void hwr_pixel(int x,int y,devcolort c) {
}

void hwr_slab(int x,int y,int l,devcolort c) {
}

void hwr_bar(int x,int y,int l,devcolort c) {
}


void hwr_rect(int x,int y,int w,int h,devcolort c) {
  if (w<=0) return;
  if (h<=0) return;
}


void hwr_frame(int x,int y,int w,int h,devcolort c) {
  hwr_slab(x,y,w,c);
  hwr_slab(x,y+h-1,w,c);
  hwr_bar(x,y+1,h-2,c);
  hwr_bar(x+w-1,y+1,h-2,c);
}

/*****************************************************************************/



/*****************************************************************************/

void input_init(void (*request_quit)(void)) {
}

void input_release() {
}

/*****************************************************************************/


void ui_GetEvent(struct ui_Event *ui_event)
{
#if 0
  static SDL_Event evt;
  static int ox=-1,oy=-1;
  static int prevsym=-1;

  for (;;) {
    SDL_WaitEvent(&evt);
    
    switch (evt.type) {
      
    case SDL_MOUSEMOTION:
      if ((evt.motion.x==ox) && (evt.motion.y==oy)) break;
      ui_event->type = penMoveEvent;
      ui_event->x = evt.motion.x;
      ui_event->y = evt.motion.y;
      ui_event->code = 0;
      return;
    
    case SDL_MOUSEBUTTONDOWN:
      ui_event->type = penDownEvent;
      ui_event->x = evt.motion.x;
      ui_event->y = evt.motion.y;
      ui_event->code = 0;
      return;
    
    case SDL_MOUSEBUTTONUP:
      ui_event->type = penUpEvent;
      ui_event->x = evt.motion.x;
      ui_event->y = evt.motion.y;
      ui_event->code = 0;
      return;
      
    case SDL_KEYDOWN:
      ui_event->type = keyDownEvent;
      ui_event->x = 0;
      ui_event->y = 0;
      
      /* Is this the special exit key? (CTRL-ALT-SLASH) */
      if (evt.key.keysym.sym==KEY_SLASH &&
	  (evt.key.keysym.mod & MOD_CTRL) &&
	  (evt.key.keysym.mod & MOD_ALT)) {
	ui_event->type = quitEvent;
      }
      
      ui_event->code = evt.key.keysym.sym;
      return;
      
    case SDL_QUIT:
      ui_event->type = quitEvent;
      return;
    }
  }
#endif
}


/*****************************************************************************/

void ui_MainLoop() {

    /************
    while (1) {
      struct ui_Event event;
      int quit;
      
      ui_GetEvent(&event);
      quit = handleMainWinEvent(&event);
      
      if (vmStatus.errNum > 0)
	drawErrorWin();
      
      if (quit)
	break;
    }
    ****************/

gtk_main ();

}

/****************************************************************************
                                   TIMEOUT RELATED
****************************************************************************/

/* function called when a timeout event come */
gint timeout_event( gpointer data ) {
    struct ui_Event ui_event;
    int16 quit;

    ui_event.type = timerEvent;
    ui_event.x = 0;        // ?????? TO UPDATE
    ui_event.y = 0;        // ?????? TO UPDATE
    ui_event.code = 0;

    /* go trough the main event handler */
    quit = handleMainWinEvent( &ui_event );

    /* OK, we have treated the event */
    return TRUE;

}

void ui_TimeoutSet( WObject win, gint nbOfMillisecond ) {
/* set the time out until the next event */
    gint aTimer;
    ui_MainWindowType *mw;

    /* get the wanted timer and the Main Window */
    aTimer = WOBJ_MainWinTimer( win );
    mw = WOBJ_WindowMain( win );

    if( aTimer != 0 ) {

	/* the timer allready exist => remove it */

	gtk_timeout_remove( aTimer );
	aTimer = 0;

    }

    if( nbOfMillisecond != 0 ) {

      /* create the timer only if we have more than 0 milliseconds */
      aTimer = gtk_timeout_add( nbOfMillisecond, timeout_event, mw );

    }

    /* put the new timer in the hook variable */
    WOBJ_MainWinTimer( win ) = aTimer;

}

/****************************************************************************
                                   FONT RELATED
****************************************************************************/

/* implementation of function for creating a Font */
ui_FontType *ui_FontCreate( WObject font ) {

ui_FontType *aFont;
gchar nameBuf[127];

    if( font == 0 ) {

        /* create a default font */

        /* compute a correct X11 font name */
	sprintf( nameBuf, "-*-%s-medium-r-*-*-%d-*-*-*-*-*-*-*",
		 DEFAULT_FONT,
		 DEFAULT_FONT_SIZE );

	/* try to create the font */
	aFont = gdk_font_load( nameBuf );

    } else {

      /* a name is gived => create with it */
	UtfString s;

	/* convert the string to an UTF string */
	s = stringToUtf( WOBJ_FontName( font ), STU_NULL_TERMINATE | STU_USE_STATIC );

	/* add * and -bold- if wanted before and after the wanted font name */
	sprintf( nameBuf, "-*-%s-%s-r-*-*-%d-*-*-*-*-*-*-*",
		 UTF2CSTR( &s ),
		 ( WOBJ_FontStyle( font ) == Font_BOLD ) ? "bold" : "medium",
		 WOBJ_FontSize( font ) - 2 );   /* - 2 seem to best match the look of Palm */

	/* load the wanted font */
	aFont = gdk_font_load( nameBuf );

	if( !aFont ) {

	  /* no font was created => try a default one */

	  /* compute a correct X11 font name */
	  sprintf( nameBuf, "-*-%s-medium-r-*-*-%d-*-*-*-*-*-*-*",
		   DEFAULT_FONT,
		   DEFAULT_FONT_SIZE );

	  /* try to create the font */
	  aFont = gdk_font_load( nameBuf );

	}
    }

    /* return the newly created font */
    return aFont;

}

void ui_FontDelete( ui_FontType * theFont ) {
/* delete the no more used font */

    gdk_font_unref( theFont );

}

gint ui_TextWidth( char *theText, ui_FontType *theFont ) {
/* return the width of the given text in the given font */

  return gdk_string_width( theFont, theText );

}

gint ui_CharWidth( char theChar, ui_FontType *theFont ) {
/* return the width of the given char in the given font */

  return gdk_char_width( theFont, theChar );

}

void ui_FontSetProperties( ui_FontType *theFont, WObject fontMetrics ) {
/* set the ascent/descent/leading of the given font */

  WOBJ_FontMetricsAscent(fontMetrics) = theFont->ascent;
  WOBJ_FontMetricsDescent(fontMetrics) = theFont->descent;
  WOBJ_FontMetricsLeading(fontMetrics) = 0; /* don't know if it's OK... */

}

gint ui_FontGetYOffset( ui_FontType *theFont ) {
/* return the ascent of the given font, because in GTK the position
   for drawing a text is the base line */

  if( theFont ) {

    return theFont->ascent;

  } else {

    return 0;

  }
}

/****************************************************************************
                                   GRAPHICS RELATED
****************************************************************************/

ui_PixmapType *ui_createDrawingPixmap( ui_MainWindowType *mw, ui_Rectangle rect ) {
/* create a pixmap for drawing depending of the given main window mw and the given rect */
  ui_PixmapType *drawingPixmap;

  /* we try to get pixmap from main window */
  drawingPixmap = gtk_object_get_data( GTK_OBJECT( mw ), "pixmap" );

  if( drawingPixmap == NULL ) {

    /* no drawingPixmap already defined => create one */

    /* create a pixmap from main window */
    drawingPixmap = gdk_pixmap_new( mw->window, rect.width, rect.height, -1 );

    /* give the pixmap to the main window */
    gtk_object_set_data( GTK_OBJECT( mw ), "pixmap", drawingPixmap );

  }

  /* return the new created pixmap */
  return drawingPixmap;

}

ui_GraphicsContextType *ui_createGC( WObject gr ) {
/* create the graphic context for the given graphics object */
  ui_MainWindowType *widget;
  ui_GraphicsContextType *theGC;
  gint surfaceType;
  ui_PixmapType *drawingPixmap;

  /* get the type of the surface to draw */
  surfaceType = SurfaceGetType( WOBJ_GraphicsSurface( gr ));

  /* initialisation depending on the surface to draw */
  if ( surfaceType == SURF_WINDOW ) {

    /* SURF_WINDOW surface type */

    /* get the WindowMain */
    widget = WOBJ_GraphicsWindowMain( gr );

    /* create a new Graphics Context from the window widget */
    theGC = gdk_gc_new( widget->window );

  } else if ( surfaceType == SURF_IMAGE ) {

      /* SURF_IMAGE */

      /* get the pixmap from the var hooks */
      drawingPixmap = WOBJ_GraphicsPixmap( gr );

      /* create a new Graphics Context from the drawingPixmap */
      theGC = gdk_gc_new( drawingPixmap );

  }

  /* return the newly created Graphics Context */
  return theGC;

}

void ui_deleteGC( ui_GraphicsContextType *theGC ) {
/* delete the given Graphics Context */

    /* release the graphics context */
    gdk_gc_unref( theGC );

}

void ui_setTheDrawFunction( ui_GraphicsContextType *theGC, gint32 drawOp ) {
/* set the drawing function on the given GC depending on the given drawOp */

    /* make the setup of the drawing function we want */
    /* as WABA define black as 1 and white as 0 for drawing operations, */
    /* the corresponding GDK function are not the same :                */
    /*     DRAW_AND => GDK_OR                                           */
    /*     DRAW_OR  => GDK_AND                                          */
    /*     DRAW_XOR => GDK_EQUIV                                        */

    switch( drawOp ) {

    case DRAW_OVER:
      gdk_gc_set_function( theGC, GDK_COPY );
      break;

    case DRAW_AND:
      gdk_gc_set_function( theGC, GDK_OR );
      break;

    case DRAW_OR:
      gdk_gc_set_function( theGC, GDK_AND );
      break;

    case DRAW_XOR:
      gdk_gc_set_function( theGC, GDK_EQUIV );
      break;

    default:
      /* same as DRAW_OVER */
      gdk_gc_set_function( theGC, GDK_COPY );
 
    }
}

void ui_ClipTo( ui_GraphicsContextType *theGC, ui_Rectangle rect ){
/* set the clip to the given rectangle */

    /* limit the draw to the given area */
    gdk_gc_set_clip_origin ( theGC, 0, 0 );
    gdk_gc_set_clip_rectangle( theGC, &rect  );

}

void ui_SetColor( ui_GraphicsContextType *theGC, gint red, gint green, gint blue ) {
/* set the color of the given gc to the given red/green/blue */

  GdkColor theColor;

  /* multiply by 0x101, because WABA has color in range 0x00 .. 0xFF and GTK in  */
  /* range 0x0000 .. 0xFFFF => to have 0xFFFF, we need to multiply 0xFF by 0x101 */
  theColor.red = 0x101 * red;
  theColor.green = 0x101 * green;
  theColor.blue = 0x101 * blue;

  /* allocate the color from the system color map */
  if( gdk_colormap_alloc_color( gdk_colormap_get_system(), &theColor, FALSE, FALSE ) ) {

    /* color allocated, so we can set the foreground color */
    gdk_gc_set_foreground( theGC, &theColor );

  }
}

void ui_DrawPixel( ui_PixmapType *drawingPixmap, ui_GraphicsContextType *theGC, gint x, gint y ){
/* draw a pixel at the given x,y position */

  gdk_draw_point( drawingPixmap, theGC, x, y );

}

void ui_DrawLine( ui_PixmapType *drawingPixmap, ui_GraphicsContextType *theGC, gint x1, gint y1, gint x2, gint y2 ) {
/* draw a line on gc fro x1,y1 to x2,y2 */

  gdk_draw_line( drawingPixmap, theGC, x1, y1, x2, y2 );

}

void ui_DrawText( ui_PixmapType *drawingPixmap, ui_GraphicsContextType *theGC, gint x, gint y, char *theText, ui_FontType *theFont ) {
/* draw theText with theFont at x,y on gc */

  gdk_draw_string( drawingPixmap, theFont, theGC, x, y, theText );

}

void ui_DrawFilledRect( ui_PixmapType *drawingPixmap, ui_GraphicsContextType *theGC, gint x, gint y, gint w, gint h ) {
/* draw a fillect rectangle at x,y and size w,h in gc */

  gdk_draw_rectangle( drawingPixmap, theGC, TRUE, x, y, w, h );

}

void ui_GraphicsRepaint( WObject graphics, ui_PixmapType *drawingPixmap, ui_GraphicsContextType *theGC ) {
/* force the repaint of the given Graphics Context in the given graphics */
  ui_MainWindowType *widget;

  /* get the WindowMain */
  widget = WOBJ_GraphicsWindowMain( graphics );


  if( widget != NULL ) {

    /* we are on a widget to draw */

    /* draw the pixmap */
    gdk_draw_pixmap( widget->window, theGC, drawingPixmap,
		     0, 0, 0, 0,
		     widget->allocation.width, widget->allocation.height );

    /* give the pixmap to the main window */
    gtk_object_set_data( GTK_OBJECT( widget ), "pixmap", drawingPixmap );

  }
}

/****************************************************************************
                                   KEYS RELATED
****************************************************************************/

int32 ui_TranslateKey( Word chr ){
/* translate the code from chr to the corresponding code in "WABA key space" */

  int32 key;

    key = 0;
    switch (chr) {
      // NOTE: these should go somewhere:
      //		nextFieldChr
      //		prevFieldChr
      //		linefeedChr
      case GDK_Page_Up:   key = WABA_KEY_PAGE_UP;   break;
      case GDK_Page_Down: key = WABA_KEY_PAGE_DOWN; break;
      case GDK_Home:      key = WABA_KEY_HOME;      break;
      case GDK_End:       key = WABA_KEY_END;       break;
      case GDK_Up:        key = WABA_KEY_UP;        break;
      case GDK_Down:      key = WABA_KEY_DOWN;      break;
      case GDK_Left:      key = WABA_KEY_LEFT;      break;
      case GDK_Right:     key = WABA_KEY_RIGHT;     break;
      case GDK_Insert:    key = WABA_KEY_INSERT;    break;
      case GDK_Return:
      case GDK_KP_Enter:  key = WABA_KEY_ENTER;     break;
      case GDK_Tab:       key = WABA_KEY_TAB;       break;
      case GDK_BackSpace: key = WABA_KEY_BACKSPACE; break;
      case GDK_Escape:    key = WABA_KEY_ESCAPE;    break;
      case GDK_Delete:    key = WABA_KEY_DELETE;    break;
      case GDK_Menu:      key = WABA_KEY_MENU;      break;
      case GDK_Alt_L:
      case GDK_Alt_R:     key = WABA_KEY_COMMAND;   break;

    }
    if (!key) {
      if (chr <= 255) {
	key = chr;
      }
    }

    return key;

}

/*****************************************************************************/
/* The End */



/*
   Local Variables:
   c-file-style: "smartdata"
   End:
*/
