/*
   Copyright (C) 2000, 2001 SMARTDATA, http://www.smartdata.ch/

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

/*

    PicoGUI Port. See http://pgui.sourceforge.net/ for more informations

*/

#include "../waba.h"

g_error sucess = {ERRT_NONE,NULL};

g_error mkerror(unsigned char type, char *msg) {
  g_error e = {type,msg};
  return e;
}

g_error prerror(g_error e) {
  if (e.type == ERRT_NONE) return sucess;
  if (!e.msg) e.msg = "?";
  printf("*** ERROR (");
  switch (e.type) {
  case ERRT_MEMORY: printf("MEMORY"); break;
  case ERRT_IO: printf("IO"); break;
  case ERRT_NETWORK: printf("NETWORK"); break;
  case ERRT_BADPARAM: printf("BADPARAM"); break;
  case ERRT_HANDLE: printf("HANDLE"); break;
  case ERRT_INTERNAL: printf("INTERNAL"); break;
  default: printf("?");
  }
  printf(") : %s\n",e.msg);
  return e;
}

/*****************************************************************************/

int evtDrawMainWindow( struct pgEvent *evt ) {
/* handling of the repaint event */

  DPUTS( "EVT: repaint ???" );

  return 0;

}

int evtMouse( struct pgEvent *evt ) {
/* handling of the mouse events */
  int x, y;
  struct ui_Event ui_event;
  int quit;

  ui_event.x = evt->e.pntr.x;
  ui_event.y = evt->e.pntr.y;
  ui_event.code = 0;

  switch( evt->type ) {
  case PG_WE_PNTR_DOWN:
    ui_event.type = penDownEvent;
    break;
  case PG_WE_PNTR_UP:
    ui_event.type = penUpEvent;
    break;
  case PG_WE_PNTR_MOVE:
    ui_event.type = penMoveEvent;
    break;
  default:
    ui_event.type = penDownEvent;
    break;
  }

  quit = handleMainWinEvent( &ui_event );

  return TRUE;

}

int evtKeyDown( struct pgEvent *evt ) {
/* handling of the key down event */

  DPUTS( "EVT: key down" );

  return 0;

}

int evtKeyUp( struct pgEvent *evt ) {
/* handling of the key up event */

  DPUTS( "EVT: key up" );

  return 0;

}

void * hwr_init() {
  // TODO: we should open the mainwindow here
  // Its geometry is hard-coded for now (hwr_width x hwr_height)

  pghandle MainWindow;
  pgcontext *gc;

  //BOR TODO : get the correct argc and argv
  int argc = 1;
  char **argv;

  argv = malloc( 2 * sizeof( char *));
  argv[0] = malloc( sizeof( char ) * ( strlen( "waba_x86" ) + 1 ));
  strcpy( argv[0], "waba_x86" );
  argv[1] = malloc( sizeof( char ) * ( strlen( "none" ) + 1 ));
  strcpy( argv[1], "none" );

  /* init the liaison to the PicoGUI server */
  pgInit(argc,argv);
  pgRegisterApp(PG_APP_NORMAL,"WabaPGUI",0);

  /* create the main context */
  MainWindow = pgNewWidget( PG_WIDGET_CANVAS, 0, 0 );
  gc = xmalloc( sizeof( pgcontext ));
  *gc = pgNewCanvasContext( PGDEFAULT, PGFX_IMMEDIATE );

  /* TODO: set the main window size */

  /*********** connect the events : */

  /* - for repainting */
  pgBind( PGDEFAULT, PG_WE_BUILD, &evtDrawMainWindow, NULL );

  /* - for the mouse down */
  pgBind( PGDEFAULT, PG_WE_PNTR_DOWN, &evtMouse, NULL );

  /* - for the mouse up */
  pgBind( PGDEFAULT, PG_WE_PNTR_UP, &evtMouse, NULL );

  /* - for the mouse down */
  pgBind( PGDEFAULT, PG_WE_PNTR_MOVE, &evtMouse, NULL );

  /* - for a key press */
  pgBind( PGDEFAULT, PG_WE_KBD_KEYDOWN, &evtKeyDown, NULL );

  /* - for a key release */
  pgBind( PGDEFAULT, PG_WE_KBD_KEYUP, &evtKeyUp, NULL );

  return gc;

}

void hwr_release() {
  // TODO:
}

void hwr_clear() {
}

void hwr_update() {
}

void hwr_pixel(int x,int y,devcolort c) {
}

void hwr_slab(int x,int y,int l,devcolort c) {
}

void hwr_bar(int x,int y,int l,devcolort c) {
}


void hwr_rect(int x,int y,int w,int h,devcolort c) {
  if (w<=0) return;
  if (h<=0) return;
}


void hwr_frame(int x,int y,int w,int h,devcolort c) {
  hwr_slab(x,y,w,c);
  hwr_slab(x,y+h-1,w,c);
  hwr_bar(x,y+1,h-2,c);
  hwr_bar(x+w-1,y+1,h-2,c);
}

/*****************************************************************************/



/*****************************************************************************/

void input_init(void (*request_quit)(void)) {
}

void input_release() {
}

/*****************************************************************************/


void ui_GetEvent(struct ui_Event *ui_event) {
}


/*****************************************************************************/

void ui_MainLoop() {
/* run the main loop */

  pgEventLoop();

}

/****************************************************************************
                                   TIMEOUT RELATED
****************************************************************************/

void timeout_event( void ) {
/* function called when a timeout event come */

    struct ui_Event ui_event;
    int16 quit;
    printf( "*********** TIMEOUT **************\n" );
    /* remove the timeout event */
    pgSetIdle( 0, NULL );

    /* prepare the event to send to MainWindow */
    ui_event.type = timerEvent;
    ui_event.x = 0;        // ?????? TO UPDATE
    ui_event.y = 0;        // ?????? TO UPDATE
    ui_event.code = 0;

    /* go trough the main event handler */
    quit = handleMainWinEvent( &ui_event );

}

void ui_TimeoutSet( WObject win, gint nbOfMillisecond ) {
/* set the time out until the next event */
/* no use of the win parameter, because we don't need to memorize the timer */

/* TO REMOVE : */
DPUTS( "MainWinSetTimerInterval : please remove the limitation to more than 100 ms" );
if(( nbOfMillisecond != 0 ) && (nbOfMillisecond < 200 )) { nbOfMillisecond = 200; };

    printf( "**** Set timer of %ld\n", nbOfMillisecond );

    /* remove the maybe existing timer */
    pgSetIdle( 0, NULL );

    if( nbOfMillisecond != 0 ) {

      /* create the timer only if we have more than 0 milliseconds */
      pgSetIdle( nbOfMillisecond, &timeout_event );

    }


}

/****************************************************************************
                                   FONT RELATED
****************************************************************************/

/* implementation of function for creating a PicoGUI Font */
ui_FontType *ui_FontCreate( WObject font ) {

ui_FontType *aFont;

    /* create the pghandle for returning it */
    aFont = xmalloc( sizeof( ui_FontType ));

    if( font == 0 ) {

      /* create a default font */
      *aFont = pgNewFont( DEFAULT_FONT, DEFAULT_FONT_SIZE, PG_FSTYLE_FLUSH | PG_FSTYLE_DEFAULT );

    } else {

	// a name is gived => create with it
	UtfString s;
	gchar nameBuf[127];

	/* convert the string to an UTF string */
	s = stringToUtf( WOBJ_FontName( font ), STU_NULL_TERMINATE | STU_USE_STATIC );

	*aFont = pgNewFont( UTF2CSTR( &s ),
			    WOBJ_FontSize( font ) - 2,   /* - 2 seem to best match the look of Palm */
			    ( WOBJ_FontStyle( font ) == Font_BOLD )
			        ? PG_FSTYLE_FLUSH | PG_FSTYLE_BOLD : PG_FSTYLE_FLUSH | PG_FSTYLE_DEFAULT );

	if( *aFont == 0 ) {

	  // bad => create a default font
	  *aFont = pgNewFont( DEFAULT_FONT, DEFAULT_FONT_SIZE, PG_FSTYLE_FLUSH | PG_FSTYLE_DEFAULT );

	}
    }

    return aFont;

}

void ui_FontDelete( ui_FontType * theFont ) {
/* delete the no more used font */

    pgDelete( *theFont );
    xfree( theFont );

}

gint ui_TextWidth( char *theText, ui_FontType *theFont ) {
/* return the width of the given text in the given font */

gint32 w_pgui, h_pgui;

    /* for releasing the pgNewString() handle */
    pgEnterContext();

    /* get the wanted size */
    pgSizeText( &w_pgui, &h_pgui, *theFont, pgNewString( theText ));

    /* release the no more used handle */
    pgLeaveContext();

    /* return the wanted width */
    return  w_pgui;

}

gint ui_CharWidth( char theChar, ui_FontType *theFont ) {
/* return the width of the given char in the given font */
/* use ui_TextWidth */
  char tmp[2];

  /* copy the char to get width */
  tmp[0] = theChar;
  tmp[1] = 0;

  return ui_TextWidth( tmp, theFont );

}

void ui_FontSetProperties( ui_FontType *theFont, WObject fontMetrics ) {
/* set the ascent/descent/leading of the given font */

  DPUTS( "ui_FontSetProperties to update" );
  WOBJ_FontMetricsAscent(fontMetrics) = 10;
  WOBJ_FontMetricsDescent(fontMetrics) = 10;
  WOBJ_FontMetricsLeading(fontMetrics) = 0; /* don't know if it's OK... */

}

gint ui_FontGetYOffset( ui_FontType *theFont ) {
/* just return a constant offset, because the used point for drawing
   the text is the upper left, and we just add a small space */

  return Y_OFFSET_DRAW_TEXT;

}

/****************************************************************************
                                   GRAPHICS RELATED
****************************************************************************/

ui_PixmapType *ui_createDrawingPixmap( ui_MainWindowType *mw, ui_Rectangle rect ) {
/* create a pixmap for drawing depending of the given main window mw and the given rect */

  DPUTS( "ui_createDrawingPixmap: not implemented now" );

  return NULL;

}

ui_GraphicsContextType *ui_createGC( WObject gr ) {
/* create the graphic context for the given graphics object */

/* as in PicoGUI, this is directly the Main Window, we just return it */

  gint surfaceType;

  /* get the type of the surface to draw */
  surfaceType = SurfaceGetType( WOBJ_GraphicsSurface( gr ));

  /* initialisation depending on the surface to draw */
  if ( surfaceType == SURF_WINDOW ) {

      return WOBJ_GraphicsWindowMain( gr );

  } else {

    DPUTS( "ui_CreateGC: not implemented for SURF_IMAGE" );
    return NULL;

  }
}

void ui_deleteGC( ui_GraphicsContextType *theGC ) {
/* delete the given Graphics Context */

  /* nothing to do as the PicoGUI Graphics context is used during all
     the life of the application */

}

void ui_setTheDrawFunction( ui_GraphicsContextType *theGC, gint32 drawOp ) {
/* set the drawing function on the given widget depending on the given drawOp */

    /* make the setup of the drawing function we want */
    /* as WABA define black as 1 and white as 0 for drawing operations, */
    /* the corresponding PIcoGUI function are not the same :            */
    /*     DRAW_AND => PG_LGOP_OR                                       */
    /*     DRAW_OR  => PG_LGOP_AND                                      */
    /*     DRAW_XOR => PG_LGOP_INVERT                                   */

  switch( drawOp ) {

  case DRAW_AND:
    pgSetLgop( *theGC, PG_LGOP_OR );
    break;

  case DRAW_OR:
    pgSetLgop( *theGC, PG_LGOP_AND );
    break;

  case DRAW_XOR:
    pgSetLgop( *theGC, PG_LGOP_INVERT_XOR );
    break;

  default:
    pgSetLgop( *theGC, PG_LGOP_NONE );
    break;

  }

  DPUTS( "??? setTheDrawFunction not implemented" );

}

void ui_ClipTo( ui_GraphicsContextType *theGC, ui_Rectangle rect ){
/* set the clip to the given rectangle */

  DPUTS( "??? ui_ClipTo not implemented" );

}

void ui_SetColor( ui_GraphicsContextType *theGC, gint red, gint green, gint blue ) {
/* set the color of the given gc to the given red/green/blue */

  gint32 theColor;    /* to manipulate the color information */

    /* compute the color to use */
    theColor = 0x10000 * red + 0x100 * green + blue;

    /* use the color */
    pgSetColor( *theGC, theColor );

}

void ui_DrawPixel( ui_PixmapType *drawingPixmap, ui_GraphicsContextType *theGC, gint x, gint y ){
/* draw a pixel at the given x,y position */

  pgPixel( *theGC, x, y );

}

void ui_DrawLine( ui_PixmapType *drawingPixmap, ui_GraphicsContextType *theGC, gint x1, gint y1, gint x2, gint y2 ) {
/* draw a line on gc fro x1,y1 to x2,y2 */
/* don't need to use drawingPixmap */

    pgLine( *theGC, x1, y1, x2, y2 );

}

void ui_DrawText( ui_PixmapType *drawingPixmap, ui_GraphicsContextType *theGC, gint x, gint y, char *theText, ui_FontType *theFont ) {
/* draw theText with theFont at x,y on gc */
/* don't need to use drawingPixmap */

    DPUTS ("ui_DrawText: see if we need to use enter/leave Context" );
    DPUTS ("ui_DrawText: need to re-activate font selection" );
    pgSetFont( *theGC, *theFont );
    pgText( *theGC, x, y, pgNewString( theText ));

}

void ui_DrawFilledRect( ui_PixmapType *drawingPixmap, ui_GraphicsContextType *theGC, gint x, gint y, gint w, gint h ) {
/* draw a fillect rectangle at x,y and size w,h in gc */
/* don't need to use drawingPixmap */

  pgRect( *theGC, x, y, w, h );

}

void ui_GraphicsRepaint( WObject graphics, ui_PixmapType *drawingPixmap, ui_GraphicsContextType *theGC ) {
/* force the repaint of the gc */

/* simple in PicoGUI, no need to use graphics and/or drawingPixmap */

  /* force PicoGUI to repaint */
  pgContextUpdate( *theGC );

}

/****************************************************************************
                                   KEYS RELATED
****************************************************************************/

int32 ui_TranslateKey( Word chr ){
/* translate the code from chr to the corresponding code in "WABA key space" */

  int32 key;

    key = 0;

    DPUTS( "ui_TranslateKey: update please" );
    switch (chr) {
    }

    if (!key) {
      if (chr <= 255) {
	key = chr;
      }
    }

    return key;

}

/*****************************************************************************/
/* The End */



/*
   Local Variables:
   c-file-style: "smartdata"
   End:
*/
