/*
   Copyright (C) 1997-2001 Id Software, Inc.

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

   See the GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

 */

#include "../g_local.h"
#include "ai_local.h"


//==========================================
// AI_InitAIWeapons
//
// AIWeapons are the way the AI uses to analize
// weapon types, for choosing and fire them
//==========================================
void AI_InitAIWeapons( void )
{
	//clear all
	memset( &AIWeapons, 0, sizeof( ai_weapon_t )*WEAP_TOTAL );


	//WEAP_GUNBLADE
	AIWeapons[WEAP_GUNBLADE].aimType = AI_AIMSTYLE_INSTANTHIT;
	AIWeapons[WEAP_GUNBLADE].RangeWeight[AIWEAP_LONG_RANGE] = 0.1f;
	AIWeapons[WEAP_GUNBLADE].RangeWeight[AIWEAP_MEDIUM_RANGE] = 0.2f;
	AIWeapons[WEAP_GUNBLADE].RangeWeight[AIWEAP_SHORT_RANGE] = 0.3f;
	AIWeapons[WEAP_GUNBLADE].RangeWeight[AIWEAP_MELEE_RANGE] = 0.2f;
	AIWeapons[WEAP_GUNBLADE].weaponItem = game.items[WEAP_GUNBLADE];
	AIWeapons[WEAP_GUNBLADE].ammoItem = game.items[AMMO_CELLS];
	AIWeapons[WEAP_GUNBLADE].ammoWeakItem = game.items[AMMO_WEAK_GUNBLADE];

	//WEAP_SHOCKWAVE
	AIWeapons[WEAP_SHOCKWAVE].aimType = AI_AIMSTYLE_PREDICTION_EXPLOSIVE;
	AIWeapons[WEAP_SHOCKWAVE].RangeWeight[AIWEAP_LONG_RANGE] = 0.1f;
	AIWeapons[WEAP_SHOCKWAVE].RangeWeight[AIWEAP_MEDIUM_RANGE] = 0.3f;
	AIWeapons[WEAP_SHOCKWAVE].RangeWeight[AIWEAP_SHORT_RANGE] = 0.5f;
	AIWeapons[WEAP_SHOCKWAVE].RangeWeight[AIWEAP_MELEE_RANGE] = 0.6f;
	AIWeapons[WEAP_SHOCKWAVE].weaponItem = game.items[WEAP_SHOCKWAVE];
	AIWeapons[WEAP_SHOCKWAVE].ammoItem = game.items[AMMO_WAVES];
	AIWeapons[WEAP_SHOCKWAVE].ammoWeakItem = game.items[AMMO_WEAK_WAVES];

	//ROCKETLAUNCHER
	AIWeapons[WEAP_ROCKETLAUNCHER].aimType = AI_AIMSTYLE_PREDICTION_EXPLOSIVE;
	AIWeapons[WEAP_ROCKETLAUNCHER].RangeWeight[AIWEAP_LONG_RANGE] = 0.3f;
	AIWeapons[WEAP_ROCKETLAUNCHER].RangeWeight[AIWEAP_MEDIUM_RANGE] = 0.6f;
	AIWeapons[WEAP_ROCKETLAUNCHER].RangeWeight[AIWEAP_SHORT_RANGE] = 0.9f;
	AIWeapons[WEAP_ROCKETLAUNCHER].RangeWeight[AIWEAP_MELEE_RANGE] = 0.6f;
	AIWeapons[WEAP_ROCKETLAUNCHER].weaponItem = game.items[WEAP_ROCKETLAUNCHER];
	AIWeapons[WEAP_ROCKETLAUNCHER].ammoItem = game.items[AMMO_ROCKETS];
	AIWeapons[WEAP_ROCKETLAUNCHER].ammoWeakItem = game.items[AMMO_WEAK_ROCKETS];

	//WEAP_GRENADELAUNCHER
	AIWeapons[WEAP_GRENADELAUNCHER].aimType = AI_AIMSTYLE_DROP;
	AIWeapons[WEAP_GRENADELAUNCHER].RangeWeight[AIWEAP_LONG_RANGE] = 0.0f;
	AIWeapons[WEAP_GRENADELAUNCHER].RangeWeight[AIWEAP_MEDIUM_RANGE] = 0.1f;
	AIWeapons[WEAP_GRENADELAUNCHER].RangeWeight[AIWEAP_SHORT_RANGE] = 0.4f;
	AIWeapons[WEAP_GRENADELAUNCHER].RangeWeight[AIWEAP_MELEE_RANGE] = 0.3f;
	AIWeapons[WEAP_GRENADELAUNCHER].weaponItem = game.items[WEAP_GRENADELAUNCHER];
	AIWeapons[WEAP_GRENADELAUNCHER].ammoItem = game.items[AMMO_GRENADES];
	AIWeapons[WEAP_GRENADELAUNCHER].ammoWeakItem = game.items[AMMO_WEAK_GRENADES];

	//WEAP_PLASMAGUN
	AIWeapons[WEAP_PLASMAGUN].aimType = AI_AIMSTYLE_PREDICTION;
	AIWeapons[WEAP_PLASMAGUN].RangeWeight[AIWEAP_LONG_RANGE] = 0.1f;
	AIWeapons[WEAP_PLASMAGUN].RangeWeight[AIWEAP_MEDIUM_RANGE] = 0.6f;
	AIWeapons[WEAP_PLASMAGUN].RangeWeight[AIWEAP_SHORT_RANGE] = 0.7f;
	AIWeapons[WEAP_PLASMAGUN].RangeWeight[AIWEAP_MELEE_RANGE] = 0.4f;
	AIWeapons[WEAP_PLASMAGUN].weaponItem = game.items[WEAP_PLASMAGUN];
	AIWeapons[WEAP_PLASMAGUN].ammoItem = game.items[AMMO_PLASMA];
	AIWeapons[WEAP_PLASMAGUN].ammoWeakItem = game.items[AMMO_WEAK_PLASMA];

	//WEAP_RIOTGUN
	AIWeapons[WEAP_RIOTGUN].aimType = AI_AIMSTYLE_INSTANTHIT;
	AIWeapons[WEAP_RIOTGUN].RangeWeight[AIWEAP_LONG_RANGE] = 0.1f;
	AIWeapons[WEAP_RIOTGUN].RangeWeight[AIWEAP_MEDIUM_RANGE] = 0.5f;
	AIWeapons[WEAP_RIOTGUN].RangeWeight[AIWEAP_SHORT_RANGE] = 0.8f;
	AIWeapons[WEAP_RIOTGUN].RangeWeight[AIWEAP_MELEE_RANGE] = 0.5f;
	AIWeapons[WEAP_RIOTGUN].weaponItem = game.items[WEAP_RIOTGUN];
	AIWeapons[WEAP_RIOTGUN].ammoItem = game.items[AMMO_SHELLS];
	AIWeapons[WEAP_RIOTGUN].ammoWeakItem = game.items[AMMO_WEAK_SHELLS];

	//WEAP_ELECTROBOLT
	AIWeapons[WEAP_ELECTROBOLT].aimType = AI_AIMSTYLE_INSTANTHIT;
	AIWeapons[WEAP_ELECTROBOLT].RangeWeight[AIWEAP_LONG_RANGE] = 0.9f;
	AIWeapons[WEAP_ELECTROBOLT].RangeWeight[AIWEAP_MEDIUM_RANGE] = 0.7f;
	AIWeapons[WEAP_ELECTROBOLT].RangeWeight[AIWEAP_SHORT_RANGE] = 0.4f;
	AIWeapons[WEAP_ELECTROBOLT].RangeWeight[AIWEAP_MELEE_RANGE] = 0.3f;
	AIWeapons[WEAP_ELECTROBOLT].weaponItem = game.items[WEAP_ELECTROBOLT];
	AIWeapons[WEAP_ELECTROBOLT].ammoItem = game.items[AMMO_BOLTS];
	AIWeapons[WEAP_ELECTROBOLT].ammoWeakItem = game.items[AMMO_WEAK_BOLTS];

	//WEAP_LASERGUN
	AIWeapons[WEAP_LASERGUN].aimType = AI_AIMSTYLE_INSTANTHIT;
	AIWeapons[WEAP_LASERGUN].RangeWeight[AIWEAP_LONG_RANGE] = 0.0f;
	AIWeapons[WEAP_LASERGUN].RangeWeight[AIWEAP_MEDIUM_RANGE] = 0.0f;
	AIWeapons[WEAP_LASERGUN].RangeWeight[AIWEAP_SHORT_RANGE] = 0.7f;
	AIWeapons[WEAP_LASERGUN].RangeWeight[AIWEAP_MELEE_RANGE] = 0.8f;
	AIWeapons[WEAP_LASERGUN].weaponItem = game.items[WEAP_LASERGUN];
	AIWeapons[WEAP_LASERGUN].ammoItem = game.items[AMMO_LASERS];
	AIWeapons[WEAP_LASERGUN].ammoWeakItem = game.items[AMMO_WEAK_LASERS];

	//WEAP_INSTAGUN
	AIWeapons[WEAP_INSTAGUN].aimType = AI_AIMSTYLE_INSTANTHIT;
	AIWeapons[WEAP_INSTAGUN].RangeWeight[AIWEAP_LONG_RANGE] = 0.9f;
	AIWeapons[WEAP_INSTAGUN].RangeWeight[AIWEAP_MEDIUM_RANGE] = 0.9f;
	AIWeapons[WEAP_INSTAGUN].RangeWeight[AIWEAP_SHORT_RANGE] = 0.9f;
	AIWeapons[WEAP_INSTAGUN].RangeWeight[AIWEAP_MELEE_RANGE] = 0.9f;
	AIWeapons[WEAP_INSTAGUN].weaponItem = game.items[WEAP_INSTAGUN];
	AIWeapons[WEAP_INSTAGUN].ammoItem = game.items[AMMO_INSTAS];
	AIWeapons[WEAP_INSTAGUN].ammoWeakItem = game.items[AMMO_WEAK_INSTAS];

}
