/******************************************/
/* Wmufo - Mini SETI@Home monitor         */
/******************************************/

/******************************************/
/* This program is free software; you can redistribute it and/or
/* modify it under the terms of the GNU General Public License
/* as published by the Free Software Foundation; either version 2
/* of the License, or (at your option) any later version.
/* 
/* This program is distributed in the hope that it will be useful,
/* but WITHOUT ANY WARRANTY; without even the implied warranty of
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/* GNU General Public License for more details.
/* 
/* You should have received a copy of the GNU General Public License
/* along with this program; if not, write to the Free Software
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
/******************************************/

#ifndef __seti_h__
#define __seti_h__

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <signal.h>
#include <pwd.h>
#include <dirent.h>
#include <sys/types.h>
#include <sys/wait.h>

#include <glibtop.h>
#include <glibtop/procstate.h>

/******************************************/
/* Defines                                */
/******************************************/

#define SETI_STATE_ERROR	0
#define SETI_STATE_NORMAL	1
#define SETI_STATE_UPLOAD	2
#define SETI_STATE_CONNECT	3
#define SETI_STATE_DOWNLOAD	4

#define SETI_FILE_USERINFO	"user_info.sah"	/* User statistics                      */
#define SETI_FILE_STATE		"state.sah"	/* State of setiathome workunit         */
#define SETI_FILE_PID		"pid.sah"	/* Pid of setiathome workunit           */
#define SETI_FILE_WTEMP		"wtemp.sah"	/* Exists if downloading new workunit   */
#define SETI_FILE_RESULT	"result.sah"	/* Exists if finished workunit          */

extern int debug;

/******************************************/
/* Structures                             */
/******************************************/

typedef struct {
	int state;
	pid_t pid;
	char status;
	float progress;
	long cpuunit;
	long cputotal;
	int nwus;
	int nresults;
} seti_data;

/******************************************/
/* Functions                              */
/******************************************/

int read_stats(const char *, seti_data *);
pid_t get_pid(const char *, seti_data *);
char get_status(const pid_t);
void read_workunit_stats(const char *, seti_data *);
void read_user_stats(const char *, seti_data *);

#endif
