/* $Id: choose_folder.h,v 1.4 2001/07/10 03:22:58 fesnel Exp $ */
/*******************************************************************************
 *   This program is part of the XFMail email client.                          *
 *                                                                             *
 *   Copyright : (C) 1995-1998 Gennady B. Sorokopud (gena@NetVision.net.il)    *
 *               (C) 1995 Ugen. J. S. Antsilevich (ugen@latte.worldbank.org)   *
 *               (C) 1998-2001 by the Archimedes Project                       *
 *                   http://sourceforge.net/projects/archimedes                *
 *                                                                             *
 *             --------------------------------------------                    *
 *                                                                             *
 *   This program is free software; you can redistribute it and/or modify      *
 *   it under the terms of the GNU General Public License as published by      *
 *   the Free Software Foundation; either version 2 of the License, or         *
 *   (at your option) any later version.                                       *
 *                                                                             *
 *   This program is distributed in the hope that it will be useful,           *
 *   but WITHOUT ANY WARRANTY, without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
 *   GNU General Public License for more details.                              *
 *                                                                             *
 *   You should have received a copy of the GNU General Public License         *
 *   along with this program; if not, write to the Free Software               *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston MA 02111-1307, USA.  *
 *                                                                             *
 *   Additional Permission granted:                                            *
 *                                                                             *
 *   This program is designed to use the XForms library, so we consider        *
 *   permission to link to that non-GPL-compatible library is implicit.        *
 *   However, in case this is not considered so, we explicitly state:          *
 *                                                                             *
 *   "As a special exception, the Archimedes Project, with the permission      *
 *    of all earlier copyright holders, formally gives permission to link      *
 *    this program with the XForms library, and distribute the resulting       *
 *    executable without the source code for XForms in the source              *
 *    distribution".                                                           *
 *                                                                             *
 ******************************************************************************/

#ifndef CHOOSE_FOLDER_H
    #define CHOOSE_FOLDER_H

    #include <fl_edit.h>
    #include <dialogs.h>

extern struct _mail_folder *choose_folder();
extern struct _mail_folder *pup_choose_folder(FL_FORM *form);
extern struct _mail_folder *create_folder(char *name, int ftype);
extern struct _mail_folder *create_subfolder(struct _mail_folder *pfolder, char *name);
extern void about(int op);
extern void help(int chapter);
typedef void (*addr_dbl_cb)(struct _mail_addr *addr, int type, int data);
    #define TO_TYPE  1
    #define CC_TYPE  2
    #define BCC_TYPE 3
    #define NN_TYPE  4
    #define FCC_TYPE 5
extern struct _mail_addr *addr_book(int *addr_type, addr_dbl_cb callback, int data);
extern struct _mail_addr *find_alias(char *name);

#ifdef HAVE_LDAP
extern struct _mail_addr *find_ldap_expansion(char * name);
#endif

extern struct _mail_addr *expand_addr_list(struct _mail_msg *msg, struct _mail_addr *addr);
extern void mailrc_import_aliases(char *fname);
extern void pine_import_aliases(char *fname);
extern int mod_addr(struct _mail_addr *oldadr, int *type);
extern int close_abook(FL_FORM *form, void *data);
extern void add_msg_addr(struct _mail_msg *msg);
extern void addr_book_set_placement(int x, int y);
extern void set_el_size();
extern void restore_fonts();
extern void restore_charsets();
extern void sign_edit();
extern void folder_conf(struct _mail_folder *folder);
extern void message_conf(struct _mail_msg *msg);
extern void rules_conf();
extern void search_msgs();
extern void log_win();
extern void xfm_log_close_fd();
extern void xfm_log_str(char * str);
extern struct _mime_msg *compose_attachment(struct _mime_msg *omime);
extern void PGP_Timer_Call(FL_OBJECT *obj, long param);
extern void load_signatures();
extern void free_signatures();
extern void keymap_conf();
extern int load_keymap();

/* init forms */

extern void choose_init();
extern void choose_free();
extern void pop_account_init();
extern void pop_account_free();
extern void search_init();
extern void search_free();
extern void inc_init();
extern void xfm_log_init();
extern void xfm_log_free();

#endif
