/* $Id: faces.cpp,v 1.4 2001/09/29 18:02:54 cfreeze Exp $ */
/*******************************************************************************
 *   This program is part of the XFMail email client.                          *
 *                                                                             *
 *   Copyright : (C) 1995-1998 Gennady B. Sorokopud (gena@NetVision.net.il)    *
 *               (C) 1995 Ugen. J. S. Antsilevich (ugen@latte.worldbank.org)   *
 *               (C) 1998-2001 by the Archimedes Project                       *
 *                   http://sourceforge.net/projects/archimedes                *
 *                                                                             *
 *             --------------------------------------------                    *
 *                                                                             *
 *   This program is free software; you can redistribute it and/or modify      *
 *   it under the terms of the GNU General Public License as published by      *
 *   the Free Software Foundation; either version 2 of the License, or         *
 *   (at your option) any later version.                                       *
 *                                                                             *
 *   This program is distributed in the hope that it will be useful,           *
 *   but WITHOUT ANY WARRANTY, without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
 *   GNU General Public License for more details.                              *
 *                                                                             *
 *   You should have received a copy of the GNU General Public License         *
 *   along with this program; if not, write to the Free Software               *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston MA 02111-1307, USA.  *
 *                                                                             *
 *   Additional Permission granted:                                            *
 *                                                                             *
 *   This program is designed to use the XForms library, so we consider        *
 *   permission to link to that non-GPL-compatible library is implicit.        *
 *   However, in case this is not considered so, we explicitly state:          *
 *                                                                             *
 *   "As a special exception, the Archimedes Project, with the permission      *
 *    of all earlier copyright holders, formally gives permission to link      *
 *    this program with the XForms library, and distribute the resulting       *
 *    executable without the source code for XForms in the source              *
 *    distribution".                                                           *
 *                                                                             *
 ******************************************************************************/


#include <config.h>
#include <fmail.h>
#include <umail.h>
#include <choose_folder.h>
#include <cfgfile.h>
#include "configform.h"

#ifdef FACES
    #include <compface.h>
#endif

#define ATT_XPM
#include <pixmaps.h>

#ifndef HAVE_XREADBITMAPFILEDATE
extern int XReadBitmapFileData(const char *, unsigned int *,
                               unsigned int *, unsigned char **, int *,
                               int *);
#endif

extern cfgfile Config;
static FD_config_faces *face_obj;
static int ready = 0;
static char face[400] = { 0x00};
int xbmfirst;

int addr_to_path(struct _mail_addr *ad, char *fpath, int n);

#ifdef FACES
unsigned char bitswaptbl[256] = {
    0x00, 0x80, 0x40, 0xc0, 0x20, 0xa0, 0x60, 0xe0,
    0x10, 0x90, 0x50, 0xd0, 0x30, 0xb0, 0x70, 0xf0,
    0x08, 0x88, 0x48, 0xc8, 0x28, 0xa8, 0x68, 0xe8,
    0x18, 0x98, 0x58, 0xd8, 0x38, 0xb8, 0x78, 0xf8,
    0x04, 0x84, 0x44, 0xc4, 0x24, 0xa4, 0x64, 0xe4,
    0x14, 0x94, 0x54, 0xd4, 0x34, 0xb4, 0x74, 0xf4,
    0x0c, 0x8c, 0x4c, 0xcc, 0x2c, 0xac, 0x6c, 0xec,
    0x1c, 0x9c, 0x5c, 0xdc, 0x3c, 0xbc, 0x7c, 0xfc,
    0x02, 0x82, 0x42, 0xc2, 0x22, 0xa2, 0x62, 0xe2,
    0x12, 0x92, 0x52, 0xd2, 0x32, 0xb2, 0x72, 0xf2,
    0x0a, 0x8a, 0x4a, 0xca, 0x2a, 0xaa, 0x6a, 0xea,
    0x1a, 0x9a, 0x5a, 0xda, 0x3a, 0xba, 0x7a, 0xfa,
    0x06, 0x86, 0x46, 0xc6, 0x26, 0xa6, 0x66, 0xe6,
    0x16, 0x96, 0x56, 0xd6, 0x36, 0xb6, 0x76, 0xf6,
    0x0e, 0x8e, 0x4e, 0xce, 0x2e, 0xae, 0x6e, 0xee,
    0x1e, 0x9e, 0x5e, 0xde, 0x3e, 0xbe, 0x7e, 0xfe,
    0x01, 0x81, 0x41, 0xc1, 0x21, 0xa1, 0x61, 0xe1,
    0x11, 0x91, 0x51, 0xd1, 0x31, 0xb1, 0x71, 0xf1,
    0x09, 0x89, 0x49, 0xc9, 0x29, 0xa9, 0x69, 0xe9,
    0x19, 0x99, 0x59, 0xd9, 0x39, 0xb9, 0x79, 0xf9,
    0x05, 0x85, 0x45, 0xc5, 0x25, 0xa5, 0x65, 0xe5,
    0x15, 0x95, 0x55, 0xd5, 0x35, 0xb5, 0x75, 0xf5,
    0x0d, 0x8d, 0x4d, 0xcd, 0x2d, 0xad, 0x6d, 0xed,
    0x1d, 0x9d, 0x5d, 0xdd, 0x3d, 0xbd, 0x7d, 0xfd,
    0x03, 0x83, 0x43, 0xc3, 0x23, 0xa3, 0x63, 0xe3,
    0x13, 0x93, 0x53, 0xd3, 0x33, 0xb3, 0x73, 0xf3,
    0x0b, 0x8b, 0x4b, 0xcb, 0x2b, 0xab, 0x6b, 0xeb,
    0x1b, 0x9b, 0x5b, 0xdb, 0x3b, 0xbb, 0x7b, 0xfb,
    0x07, 0x87, 0x47, 0xc7, 0x27, 0xa7, 0x67, 0xe7,
    0x17, 0x97, 0x57, 0xd7, 0x37, 0xb7, 0x77, 0xf7,
    0x0f, 0x8f, 0x4f, 0xcf, 0x2f, 0xaf, 0x6f, 0xef,
    0x1f, 0x9f, 0x5f, 0xdf, 0x3f, 0xbf, 0x7f, 0xff,
};

char *xbm_to_face() {
    char file[255];
    char en[10];
    char buf[4096];
    char *p;
    unsigned char *bitmap_data;
    int x, y;
    unsigned int w, h;

    if(face[0] != '\0')
        return face;

    strcpy(file, Config.getCString("myface", ""));
    if(strlen(file) < 2)
        return NULL;

    if(XReadBitmapFileData(file, &w, &h, &bitmap_data, &x, &y) !=
       BitmapSuccess) {
        display_msg(MSG_WARN, "xbmtoface", "Failed to read bitmap file %s",
                    file);
        return NULL;
    }

    if((w != 48) || (h != 48)) {
        display_msg(MSG_WARN, "xbmtoface",
                    " Heigth and width of face image must be 48");
        XFree((char *) bitmap_data);
        return NULL;
    }

    buf[0] = '\0';
    for(x = 0; x < (48 * 48 / 8); x += 2) {
        if(((x + 2) % 3) == 0)
            sprintf(en, "0x%02X%02X,\n", bitswaptbl[bitmap_data[x]],
                    bitswaptbl[bitmap_data[x + 1]]);
        else
            sprintf(en, "0x%02X%02X,", bitswaptbl[bitmap_data[x]],
                    bitswaptbl[bitmap_data[x + 1]]);
        strcat(buf, en);
    }

    XFree((char *) bitmap_data);
    switch(compface(buf)) {
        case -2:
            display_msg(MSG_WARN, "compface", "internal error");
            return NULL;
            break;

        case -1:
            display_msg(MSG_WARN, "compface", "bad face data");
            return NULL;
            break;

        case 1:
            display_msg(MSG_WARN, "compface", "ignoring trailing garbage");
            break;
    }

    if((strlen(buf) < 2) || (strlen(buf) > 400))
        return NULL;

    if((p = strrchr(buf, '\n')) != NULL)
        *p = '\0';

    p = buf;
    while(*p == ' ')
        p++;

    strcpy(face, p);
    return face;
}

char *get_msg_face(struct _mail_msg *msg) {
    static char bitmap_data[1024];
    struct _head_field *hf;
    char buf[4096];
    int i, j;

    if(!(hf = find_field(msg, FACEFIELD)))
        return NULL;

    if(!hf->f_line)
        return NULL;

    strcpy(buf, hf->f_line);

    switch(uncompface(buf)) {
        case -2:
            display_msg(MSG_WARN, "uncompface", "internal error");
            return NULL;
            break;

        case -1:
            display_msg(MSG_WARN, "uncompface", "bad face data");
            return NULL;
            break;

        case 1:
            display_msg(MSG_WARN, "uncompface", "ignoring trailing garbage");
            break;
    }

    i = j = 0;
    while(buf[i]) {
        int c1, c2;
        if(sscanf(buf + i, " 0x%2x%2x , ", &c1, &c2) != 2)
            break;
        while(buf[i++] != ',');
        if(c1 > 255 || c2 > 255)
            return NULL;
        bitmap_data[j++] = bitswaptbl[c1];
        bitmap_data[j++] = bitswaptbl[c2];
    }

    if(j != (48 * 48 / 8)) {
        display_msg(MSG_WARN, "uncompface",
                    "face data was %d long, not 48*48/8 = %d\n", j,
                    48 * 48 / 8);
        return NULL;
    }

    return bitmap_data;

}

void update_faces(struct _mail_msg *msg) {
    char *face, *p;
    char buf[255];
    char fpath[128];
    char bfpath[128];
    Pixmap bitmap;
    struct stat sb;

    if(!Config.getInt("faceupdate", 0))
        return;
    if(!msg)
        return;

    if(!find_field(msg, FACEFIELD))
        return;

    if(addr_to_path(msg->header->From, fpath, 127) == -1)
        return;

    strcpy(bfpath,
           Config.getCString("facepath", "/usr/local/faces"));
    if(strchr(fpath, '/'))
        snprintf(buf, sizeof(buf), "%s/%s/face.xbm", bfpath, fpath);
    else
        snprintf(buf, sizeof(buf), "%s/MISC/%s/face.xbm", bfpath, fpath);

    if(access(buf, R_OK) == 0)
        return;

    if(!(face = get_msg_face(msg)))
        return;

    p = strrchr(buf, '/');
    *p = '\0';
    if(stat(buf, &sb) == -1) {
        if(errno != ENOENT)
            return;
    } else {
        *p = '/';
        if(!(sb.st_mode & S_IFDIR))
            return;
        goto saveface;
    }
    *p = '/';

    p = buf + strlen(bfpath) + 1;
    while((p = strchr(p, '/')) != NULL) {
        *p = '\0';
        if(mkdir(buf, 00775) == -1) {
            if(errno != EEXIST) {
                display_msg(MSG_LOG, "save face file",
                            "failed to create %s", buf);
                return;
            }
        }
        chmod(buf, 00775);
        *p = '/';
        p++;
    }

    saveface:
    bitmap = 0;
    if(
      (bitmap =
       XCreateBitmapFromData(fl_display,
                             main_form ? main_form->window : fl_root,
                             face, 48, 48)) == None) {
        display_msg(MSG_WARN, "update", "Faled to create bitmap");
        return;
    }

    if(XWriteBitmapFile(fl_display, buf, bitmap, 48, 48, -1, -1) !=
       BitmapSuccess) {
        display_msg(MSG_WARN, "update", "Faled to save %s", buf);
        XFreePixmap(fl_display, bitmap);
        return;
    }
    chmod(buf, 00664);

    XFreePixmap(fl_display, bitmap);
    return;
}

#endif

int check_pixmap(char *path, char *res) {
    char buf[255];

    snprintf(buf, sizeof(buf), "%s/face.xpm", path);
    if(access(buf, R_OK) == 0) {
        strcpy(res, buf);
        return 1;
    }

    return 0;
}

int check_bitmap(char *path, char *res) {
    char buf[255];

    snprintf(buf, sizeof(buf), "%s/face.xbm", path);
    if(access(buf, R_OK) == 0) {
        strcpy(res, buf);
        return 1;
    }

    return 0;
}

int check_pics(char *path) {
    if(xbmfirst) {
        if(check_bitmap(path, path))
            return FACE_XBM;

        if(check_pixmap(path, path))
            return FACE_XPM;
    } else {
        if(check_pixmap(path, path))
            return FACE_XPM;

        if(check_bitmap(path, path))
            return FACE_XBM;
    }

    return 0;
}

char *check_fpath(char *bfpath, char *fpath, int *ftype) {
    static char facef[255];
    char buf[255];
    char *p;

    if(strlen(fpath) > 246)
        return NULL;

    strcpy(buf, fpath);

    snprintf(facef, sizeof(facef), "%s/%s", bfpath, buf);
    if((*ftype = check_pics(facef)) != 0)
        return facef;

    while((p = strrchr(buf, '/'))) {
        *p = '\0';

        snprintf(facef, sizeof(facef), "%s/%s/unknown", bfpath, buf);
        if((*ftype = check_pics(facef)) != 0)
            return facef;

    }
    if(strlen(buf) > 1) {
        snprintf(facef, sizeof(facef), "%s/MISC/%s", bfpath, buf);
        if((*ftype = check_pics(facef)) != 0)
            return facef;
    }

    return NULL;
}

int addr_to_path(struct _mail_addr *addr, char *fpath, int n) {
    char *ad;
    char *p, *p1;

    ad = get_addr_addr(addr);

    fpath[0] = '\0';
    p = strrchr(ad, '@');
    if(p) {

        for(p1 = p; *p1; p1++)
            *p1 = tolower(*p1);

        *p = '\0';
        p++;

        if((strlen(p) < 2) || (strlen(p) > 127))
            return -1;

        while((p1 = strrchr(p, '.')) != NULL) {
            *p1 = '\0';
            p1++;
            if(*p1 == '\0')
                continue;
            if((strlen(fpath) + strlen(p1) + 3) >= n)
                break;

            strcat(fpath, p1);
            strcat(fpath, "/");
        }

        if((strlen(fpath) + strlen(p) + 3) < n) {
            strcat(fpath, p);
            strcat(fpath, "/");
        }

    }

    if((strlen(fpath) + strlen(ad) + 3) < n)
        strcat(fpath, ad);

    return 0;
}

char *find_face(struct _mail_addr *addr, int *ftype) {
    char *p, *p1;
    char fpath[128];
    char bfpath[255];

    strcpy(bfpath,
           Config.getCString("facepath", "/usr/local/faces"));
    if(!addr)
        return NULL;

    xbmfirst = Config.getInt("preferxbm", 0);
    if(addr_to_path(addr, fpath, 127) == -1)
        return NULL;

    p = strtok(bfpath, ":");
    if((p1 = check_fpath(p ? p : bfpath, fpath, ftype)) != NULL)
        return p1;

    while((p = strtok(NULL, ":")) != NULL) {
        if(strlen(p) > 127)
            continue;

        if((p1 = check_fpath(p, fpath, ftype)) != NULL)
            return p1;
    }

    return NULL;
}

void Faces_Path_Call(FL_OBJECT * obj, long param) {
}

void Faces_Use_Call(FL_OBJECT * obj, long param) {
}

void Faces_Myface_Call(FL_OBJECT * obj, long param) {
#ifdef  FACES
    char *ffile;

    ffile = (char *) fl_get_input(obj);

    Config.set("myface", ffile);
    face[0] = '\0';
    if(!xbm_to_face()) {
        Config.set("myface", "");
        fl_set_input(face_obj->Faces_Myface, "");
        fl_hide_object(face_obj->Face_Bitmap);
        return;
    }

    fl_show_object(face_obj->Face_Bitmap);
    fl_set_input(face_obj->Faces_Myface, ffile);
    fl_set_bitmap_file(face_obj->Face_Bitmap, ffile);

    return;
#endif
}

void Face_File_Choose_Call(FL_OBJECT * obj, long param) {
#ifdef  FACES
    char *ffile;

    fl_set_fselector_title("Choose your face file");
    ffile = (char *) fl_show_fselector("My Face", "", "*.xbm", "");
    if(!ffile)
        return;

    Config.set("myface", ffile);
    face[0] = '\0';
    if(!xbm_to_face()) {
        Config.set("myface", "");
        fl_set_input(face_obj->Faces_Myface, "");
        fl_hide_object(face_obj->Face_Bitmap);
        return;
    }

    fl_show_object(face_obj->Face_Bitmap);
    fl_set_input(face_obj->Faces_Myface, ffile);
    fl_set_bitmap_file(face_obj->Face_Bitmap, ffile);

    return;
#endif
}

void Faces_Update_Call(FL_OBJECT * obj, long param) {
    if(fl_get_button(obj))
        fl_show_message("Warning!",
                        "Make sure you have write permission in your",
                        "picons database directory");

}

void faces_conf(int set_default, FD_config_faces * form) {
    face_obj = form;

#ifdef  FACES
    fl_set_input(face_obj->Faces_Path,
                 Config.getCStringDefault("facepath", "/usr/local/faces", 
						 set_default));
    fl_set_button(face_obj->Faces_Use,
                  Config.getIntDefault("usefaces", 0, set_default));
    fl_set_button(face_obj->Faces_Bmp,
                  Config.getIntDefault("preferxbm", 0, set_default));
    fl_set_button(face_obj->Faces_Update,
                  Config.getIntDefault("faceupdate", 0, set_default));
    fl_set_pixmapbutton_data(face_obj->Face_File_Choose, save_xpm);
    face_obj->Face_File_Choose->u_vdata =
    const_cast < char *>("Select face image");
    fl_set_object_posthandler(face_obj->Face_File_Choose, post_handler);
    face[0] = '\0';
    if(set_default || !xbm_to_face()) {
        Config.set("myface", "");
        fl_set_input(face_obj->Faces_Myface, "");
        fl_hide_object(face_obj->Face_Bitmap);
    } else {
        fl_set_input(face_obj->Faces_Myface,
                     Config.getCStringDefault("myface", "", set_default));
        fl_set_bitmap_file(face_obj->Face_Bitmap,
                           Config.getCStringDefault("myface", "", set_default));
    }
#else
    fl_set_input(face_obj->Faces_Path,"UNAVAILABLE NOT COMPILED IN");
#endif
}

void handle_faces_input(FD_config_faces * form) {
    face_obj = form;

#ifdef  FACES
    Config.set("facepath", (char *) fl_get_input(face_obj->Faces_Path));
    Config.set("myface", (char *) fl_get_input(face_obj->Faces_Myface));
    Config.set("usefaces", fl_get_button(face_obj->Faces_Use));
    Config.set("preferxbm", fl_get_button(face_obj->Faces_Bmp));
    Config.set("faceupdate", fl_get_button(face_obj->Faces_Update)); 
	ready = 0;
    return;
#endif
}
