/*
 * xmmplayer - mplayer plugin for xmms
 * Copyright (C) 2003 Hyriand - See COPYING
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#include "config.h"

#include <glib.h>
#include <string.h>

typedef struct
{
  gchar *id, *format;
} format_pair;

format_pair format_table[] = {
  {"IV32", "Intel Video 3.2"},
  {"IV41", "Intel Video 4.1"},
  {"IV50", "Intel Video 5.0"},
  {"0x10000001", "MPEG-PS"},
  {"SVQ3", "Sorensen Video 3"},
  {"MP42", "MPEG 4.2"},
  {"MP43", "MPEG 4.3"},
  {"WMV1", "Window Media Video 1"},
  {"DIV3", "DivX Video 3"},
  {"DIVX", "DivX Video 4"},
  {"DX50", "DivX Video 5"},
  {NULL, NULL},
};

gchar *
videoformat (gchar * format)
{
  int i = 0;
  while (format_table[i].id)
    {
      if (strcmp (format, format_table[i].id) == 0)
	return g_strdup (format_table[i].format);
      i++;
    }
  return g_strdup (format);
}
