#include <sys/wait.h>
#include <signal.h>
#include <stdio.h>
#include <unistd.h>
#include "thread.h"


Thread::Thread(int synchronous, int realtime)
{
	this->synchronous = synchronous; 
	this->realtime = realtime;  
	tid = (pthread_t)-1;
	thread_running = 0;
}

Thread::~Thread()
{
}

void* Thread::entrypoint(void *parameters)
{
//printf("Thread::entrypoint 1\n");
	Thread *pt = (Thread*)parameters;
//printf("Thread::entrypoint 2\n");
// allow thread to be cancelled in the middle of something
	pthread_setcanceltype(PTHREAD_CANCEL_ASYNCHRONOUS, 0);
//printf("Thread::entrypoint 3\n");
	pt->run();
//printf("Thread::entrypoint 4\n");
	pt->thread_running = 0;
//printf("Thread::entrypoint 5\n");
	return NULL;
}

void Thread::start()
{
//printf("Thread::start 1\n");
	pthread_attr_t  attr;
	struct sched_param param;
//printf("Thread::start 2\n");

	pthread_attr_init(&attr);
//printf("Thread::start 3\n");

	thread_running = 1;
// caused SEGFLT when reading from files
	if(!synchronous) pthread_attr_setdetachstate(&attr, PTHREAD_CREATE_DETACHED);
//printf("Thread::start 4\n");

	if(realtime)
	{
		if(pthread_attr_setschedpolicy(&attr, SCHED_RR) < 0)
			printf("Couldn't set realtime thread.\n");
		param.sched_priority = 50;
		if(pthread_attr_setschedparam(&attr, &param) < 0)
			printf("Couldn't set realtime thread.\n");;
	}
//printf("Thread::start 5\n");

	pthread_create(&tid, &attr, Thread::entrypoint, this);
//printf("Thread::start 6\n");
}

int Thread::end(pthread_t tid)           // need to join after this if synchronous
{
	if(tid > 0) pthread_cancel(tid);
	return 0;
}

int Thread::end()           // need to join after this if synchronous
{
	cancel();
	return 0;
}

int Thread::cancel()
{
	if(tid > 0) pthread_cancel(tid);
	if(!synchronous) tid = (pthread_t)-1;
	return 0;
}

int Thread::join()   // join this thread
{
	int result = 0;
	if(tid > 0) result = pthread_join(tid, 0); 

// Caused by tid == -1
	if(result) 
	{
//		printf("Thread::join tid = %d\n", tid);
//		perror("Thread::join");
	}
	tid = (pthread_t)-1;
	return 0;
}

int Thread::enable_cancel()
{
	pthread_setcancelstate(PTHREAD_CANCEL_ENABLE, NULL);
	return 0;
}

int Thread::disable_cancel()
{
	pthread_setcancelstate(PTHREAD_CANCEL_DISABLE, NULL);
	return 0;
}

int Thread::exit_thread()
{
 	pthread_exit(0);
	if(!synchronous) tid = (pthread_t)-1;
	return 0;
}


int Thread::suspend_thread()
{
	if(tid > 0) pthread_kill(tid, SIGSTOP);
	return 0;
}

int Thread::continue_thread()
{
	if(tid > 0) pthread_kill(tid, SIGCONT);
	return 0;
}

int Thread::running()
{
	return thread_running;
}

int Thread::set_synchronous(int value)
{
	this->synchronous = value;
	return 0;
}

int Thread::set_realtime(int value)
{
	this->realtime = value;
	return 0;
}

int Thread::get_synchronous()
{
	return synchronous;
}

int Thread::calculate_realtime()
{
//printf("Thread::calculate_realtime %d %d\n", getpid(), sched_getscheduler(0));
	return (sched_getscheduler(0) == SCHED_RR);
}

int Thread::get_realtime()
{
	return realtime;
}

int Thread::get_tid()
{
	return tid;
}

