/* ------------------------------------------------------------------------
 * $Id: HandlerBase.hh,v 1.1 2001/08/16 11:32:21 elm Exp $
 *
 * This file is part of 3Dwm: The Three-Dimensional User Environment.
 *
 * 3Dwm: The Three-Dimensional User Environment:
 *	<http://www.3dwm.org>
 *
 * Chalmers Medialab
 * 	<http://www.medialab.chalmers.se>
 * 
 * This C++ SAX implementation (Simple API for XML) is derived from
 * David Megginson's original Java SAX that can be found on 
 * http://www.megginson.com/SAX/.
 * ------------------------------------------------------------------------
 * File created 2001-08-13 by Niklas Elmqvist.
 *
 * Copyright (c) 2001 Niklas Elmqvist <elm@3dwm.org>.
 * ------------------------------------------------------------------------
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * ------------------------------------------------------------------------ 
 */

#ifndef _SAXHandlerBase_hh_
#define _SAXHandlerBase_hh_

// -- Local Includes
#include "Celsius/SAX/EntityResolver.hh"
#include "Celsius/SAX/DTDHandler.hh"
#include "Celsius/SAX/DocumentHandler.hh"
#include "Celsius/SAX/ErrorHandler.hh"

namespace SAX {
    
    // -- Class Declarations
    
    /**
     * Default base class for handlers. 
     **/
    class HandlerBase : public EntityResolver,
			public DTDHandler,
			public DocumentHandler,
			public ErrorHandler {
    public:
	
	/**
	 * Constructor.
	 **/
	HandlerBase() { }
	
	/**
	 * Destructor.
	 **/
	virtual ~HandlerBase() { }
	
	/**
	 * Resolve an external entity. Always return null, so that the
	 * parser will use the system identifier provided in the XML
	 * document.
	 *
	 * @param publicId public identifer, empty if none is available.
	 * @param systemId system identifer, empty if none is available.
	 **/
	virtual InputSource *resolveEntity(const std::string &publicId,
					   const std::string &systemId) {
	    return 0; 
	}

	/**
	 * Receive notification of a notation declaration. By default,
	 * do nothing.
	 *
	 * @param name notation name.
	 * @param publicId notation's public identifier.
	 * @param systemId notation's system identifier.
	 **/ 
	virtual void notationDecl(const std::string &name,
				  const std::string &publicId,
				  const std::string &systemId) { }

	/**
	 * Receive notification of an unparsed entity declaration
	 * event. By default, do nothing.
	 *
	 * @param name notation name.
	 * @param publicId notation's public identifier.
	 * @param systemId notation's system identifier.
	 * @param notationName name of the associated notation.
	 **/
	virtual void unparsedEntityDecl(const std::string &name,
					const std::string &publicId,
					const std::string &systemId,
					const std::string &notationName) { }
	
	/**
	 * Receive an object for locating the origin of SAX document
	 * events. By default, do nothing, subclasses may override to
	 * store locator.
	 *
	 * @param object that can return the location of any SAX
	 *        document event.
	 **/
	virtual void setDocumentLocator(const Locator &locator) { }

	/**
	 * Receive notification of the beginning of a document. By
	 * default, do nothing. 
	 **/
	virtual void startDocument() { }

	/**
	 * Receive notification of the end of a document. By default,
	 * do nothing.
	 **/
	virtual void endDocument() { }

	/**
	 * Receive notification of the beginning of an element. By
	 * default, do nothing.
	 *
	 * @param name element type name.
	 * @param atts attributes attached to the element, if any.
	 **/
	virtual void startElement(const std::string &name,
				  const AttributeList &atts) { }

	/**
	 * Receive notification of the end of an element. By default,
	 * do nothing.
	 *
	 * @param name element type name.
	 **/
	virtual void endElement(const std::string &name) { }
	
	/**
	 * Receive notification of character data. By default, do
	 * nothing.
	 *
	 * @param ch characters from the XML document.
	 **/
	virtual void characters(const std::string &ch) { }

	/**
	 * Receive notification of ignorable whitespace in element
	 * content. By default, do nothing.
	 *
	 * @param ch characters from the XML document.
	 **/
	virtual void ignorableWhitespace(const std::string &ch) { }

	/**
	 * Receive notification of a processing instruction. By
	 * default, do nothing.
	 *
	 * @param target processing instruction target.
	 * @param data processing instruction data, or null if
	 *             none was supplied.
	 **/
	virtual void processingInstruction(const std::string &target,
					   const std::string &data) { }

	/**
	 * Receive notification of a warning. By default, do nothing.
	 *
	 * @param e warning information encapsulated in a SAX parse
	 *          exception.
	 **/
	virtual void warning(const ParseException &e) { }

	/**
	 * Receive notification of a recoverable error. By default, do
	 * nothing.
	 *
	 * @param e error information encapsulated in a SAX parse
	 *          exception.
	 **/
	virtual void error(const ParseException &e) { }

	/**
	 * Receive notification of a fatal error. The default
	 * implementation throws a SAXParseException.
	 *
	 * @param e error information encapsulated in a SAX parse
	 *          exception.
	 **/
	virtual void fatalError(const ParseException &e) {
	    throw ParseException(e.what(), e.getPublicId(),
				 e.getSystemId(), e.getLineNumber(),
				 e.getColumnNumber());
	}
    };
    
};

#endif /* HandlerBase.hh */
