/* ------------------------------------------------------------------------
 * $Id: Parser.hh,v 1.1 2001/08/16 11:32:21 elm Exp $
 *
 * This file is part of 3Dwm: The Three-Dimensional User Environment.
 *
 * 3Dwm: The Three-Dimensional User Environment:
 *	<http://www.3dwm.org>
 *
 * Chalmers Medialab
 * 	<http://www.medialab.chalmers.se>
 * 
 * This C++ SAX implementation (Simple API for XML) is derived from
 * David Megginson's original Java SAX that can be found on 
 * http://www.megginson.com/SAX/.
 * ------------------------------------------------------------------------
 * File created 2001-08-14 by Niklas Elmqvist.
 *
 * Copyright (c) 2001 Niklas Elmqvist <elm@3dwm.org>.
 * ------------------------------------------------------------------------
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * ------------------------------------------------------------------------ 
 */

#ifndef _SAXParser_hh_
#define _SAXParser_hh_

// -- System Includes
#include <string>

namespace SAX {

    // -- Forward Declarations
    class DTDHandler;
    class ErrorHandler;
    class EntityResolver;
    class DocumentHandler;
    class InputSource;

    // -- Class Declarations

    /**
     * Basic interface for SAX (Simple API for XML) parsers.
     **/
    class Parser {
    public:
	
	/**
	 * Constructor.
	 **/
	Parser() { }

	/**
	 * Destructor.
	 **/
	virtual ~Parser() { }

	/**
	 * Allow an application to register a custom entity resolver.
	 *
	 * @param resolver pointer to object for resolving entities.
	 **/
	virtual void setEntityResolver(EntityResolver *resolver) = 0;

	/**
	 * Allow an application to register a DTD event handler. 
	 *
	 * @param handler pointer DTD handler.
	 **/
	virtual void setDTDHandler(DTDHandler *handler) = 0;

	/**
	 * Allow an application to register a document event handler. 
	 *
	 * @param handler pointer to document handler.
	 **/ 
	virtual void setDocumentHandler(DocumentHandler *handler) = 0;
	
	/**
	 * Allow an application to register an error event handler. 
	 *
	 * @param pointer to error handler.
	 **/
	virtual void setErrorHandler(ErrorHandler *handler) = 0; 

	/**
	 * Parse an XML document. Applications may not invoke this
	 * method while a parse is in progress (they should create a
	 * new Parser instead for each additional XML document). Once
	 * a parse is complete, an application may reuse the same
	 * Parser object, possibly with a different input source.
	 *
	 * @param input source for the top-level of the XML document. 
	 **/
	virtual void parse(InputSource &source) = 0;
	
	/**
	 * Parse an XML document from a system identifier (URI). This
	 * method is a shortcut for the common case of reading a
	 * document from a system identifier.
	 * 
	 * @note Only file names are supported in this implementation!
	 * @param systemId system identifier (URI).
	 **/ 
	virtual void parse(const std::string &systemId) = 0;
    };

};

#endif /* Parser.hh */
