/* ------------------------------------------------------------------------
 * ImageImpl.hh
 *
 * This file is part of 3Dwm: The Three-Dimensional User Environment.
 *
 * 3Dwm: The Three-Dimensional User Environment:
 *	<http://www.3dwm.org>
 *
 * Chalmers Medialab
 * 	<http://www.medialab.chalmers.se>
 * 
 * ------------------------------------------------------------------------
 * File created 2000-09-19 by Steve Houston.
 *
 * Copyright (c) 2000 Niklas Elmqvist <elm@3dwm.org>.
 * Copyright (c) 2000 Steve Houston <shouston@programmer.net>.
 * ------------------------------------------------------------------------
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * ------------------------------------------------------------------------
 */

#ifndef _ImageImpl_hh_
#define _ImageImpl_hh_

// -- System includes
#include <png.h>
#include <GL/gl.h>

// -- 3Dwm includes
#include "Nobel/CORBA.hh"
#include "Nobel/Image.hh"
#include "Nobel/TextureGenerator.hh"
#include "Nobel/Geometry.hh"
#include "Nobel/Renderer.hh"

// -- Forward Declarations
class Mutex;

// -- Class Declarations

/**
 * C++ implementation of the image interface.
 **/
class ImageImpl : public virtual POA_Nobel::Image,
		  public virtual PortableServer::RefCountServantBase {
    
public:
    
    // IDL Methods
    virtual void loadRaw(const Nobel::BinaryData &, CORBA::Long width,
			 CORBA::Long height, Nobel::PixelType pixelFormat);
    virtual void free();
    virtual CORBA::Long getWidth() { return _width; }
    virtual CORBA::Long getHeight() { return _height; }

protected:

    /**
     * Constructor.
     **/
    ImageImpl();

    /**
     * Destructor.
     **/
    virtual ~ImageImpl();

    Mutex _mutex;
    Nobel::BinaryData _binData;
    CORBA::Long       _width;
    CORBA::Long       _height;
    Nobel::PixelType  _pixelType;
};

/**
 * C++ implementation of the texture interface.
 **/
class TextureImpl : public virtual POA_Nobel::Texture,
		    public ImageImpl {

public:
    
    /**
     * Constructor.
     **/
    TextureImpl();

    /**
     * Destructor.
     **/
    virtual ~TextureImpl();

    // Overridden superclass methods
    virtual void free();

    // IDL Methods
    virtual void setName(Nobel::Tag name);
    virtual Nobel::Tag getName();
    virtual CORBA::Long getFormat() { return (CORBA::Long) _texFormat; }
    virtual CORBA::Boolean isReady();
    virtual void apply(Nobel::Renderer_ptr r); 
    virtual CORBA::Boolean init(Nobel::Renderer_ptr r);

protected:
    
    CORBA::Long _texName;
    int _texFormat;
    CORBA::Boolean _isReady; 
};

/**
 * C++ implementation of the procedural texture interface.
 **/
class ProceduralTextureImpl : public virtual POA_Nobel::ProceduralTexture,
			      public TextureImpl {
public:
    
    /**
     * Constructor.
     **/
    ProceduralTextureImpl();

    /**
     * Destructor.
     **/
    virtual ~ProceduralTextureImpl();

    // IDL functions
    void apply(Nobel::Renderer_ptr r);
    CORBA::Boolean init(Nobel::Renderer_ptr r);
    void setTextureGenerator(Nobel::TextureGenerator_ptr texGen);
private:
    Nobel::TextureGenerator_var _texGen;
};

#endif /* ImageImpl.hh */
