/* ------------------------------------------------------------------------
 * $Id: PrimitiveKitImpl.hh,v 1.2 2001/08/02 14:22:08 elm Exp $
 *
 * This file is part of 3Dwm: The Three-Dimensional User Environment.
 *
 * 3Dwm: The Three-Dimensional User Environment:
 *	<http://www.3dwm.org>
 *
 * Chalmers Medialab
 * 	<http://www.medialab.chalmers.se>
 * 
 * ------------------------------------------------------------------------
 * File created 2001-08-01 by Niklas Elmqvist.
 *
 * Copyright (c) 2001 Niklas Elmqvist <elm@3dwm.org>.
 * ------------------------------------------------------------------------
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * ------------------------------------------------------------------------
 */

#ifndef _PrimitiveKitImpl_hh_
#define _PrimitiveKitImpl_hh_

// -- 3Dwm Includes
#include "Nobel/CORBA.hh"
#include "Nobel/PrimitiveKit.hh"
#include "Polhem/KitImpl.hh"

// -- Class Declarations

class PrimitiveKitImpl : public virtual POA_Nobel::PrimitiveKit,
			 public KitImpl {
public:
    
    /**
     * Constructor.
     **/
    PrimitiveKitImpl() { }
    
    /**
     * Destructor.
     **/
    virtual ~PrimitiveKitImpl() { }

    // IDL functions
    virtual char *name() {
	return CORBA::string_dup("PrimitiveKit"); 
    }
    
    virtual char *description() {
	return CORBA::string_dup("Primitive kit."); 
    }
    
    virtual Nobel::Primitive_ptr createCuboid();
    virtual Nobel::Primitive_ptr createCone(CORBA::Long segments);
    virtual Nobel::Primitive_ptr createSphere(CORBA::Long latSegments,
					      CORBA::Long longSegments);
    virtual Nobel::Primitive_ptr createCylinder(CORBA::Long segments);
    virtual Nobel::Primitive_ptr createPlane();
    virtual Nobel::Primitive_ptr createTorus(CORBA::Long slices,
					     CORBA::Long segments);
    
private:
    
    // No copy constructor for kits
    PrimitiveKitImpl(const PrimitiveKitImpl &kit);
};

#endif /* PrimitiveKitImpl.hh */
