/* ------------------------------------------------------------------------
 * ServerHandleImpl.hh
 *
 * This file is part of 3Dwm: The Three-Dimensional User Environment.
 *
 * 3Dwm: The Three-Dimensional User Environment:
 *	<http://www.3dwm.org>
 *
 * Chalmers Medialab
 * 	<http://www.medialab.chalmers.se>
 * 
 * ------------------------------------------------------------------------
 * File created 2000-10-24 by Niklas Elmqvist.
 *
 * Copyright (c) 2000 Niklas Elmqvist <elm@3dwm.org>.
 * ------------------------------------------------------------------------
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * ------------------------------------------------------------------------
 */

#ifndef _ServerHandleImpl_hh_
#define _ServerHandleImpl_hh_

// -- System Includes
#include <string>
#include <map>

// -- 3Dwm Includes
#include "Nobel/CORBA.hh"
#include "Nobel/Server.hh"

// -- Forward Declarations
class KitImpl;
class NodeImpl;
class ServerImpl;

// -- Class Declarations
class ServerHandleImpl : public virtual POA_Nobel::ServerHandle,
			 public virtual PortableServer::RefCountServantBase {

public:

    /**
     * Constructor.
     **/
    ServerHandleImpl(NodeImpl *root);

    /**
     * Destructor.
     **/
    ~ServerHandleImpl();

    // IDL functions
    virtual Nobel::Kit_ptr resolve(const char* name);
    virtual void shutdown();
    virtual Nobel::Node_ptr root();
    
    /**
     * Is the server handle alive? If not, the super-context will
     * deallocate it.
     **/
    bool isAlive() {
	return _alive;
    }
    
private:

    bool _alive;

    // Client scene graph root
    NodeImpl *_root;

    // Kit container (associative map)
    typedef std::map<std::string, KitImpl *> KitMap;
    KitMap _kits;
};

#endif /* ServerHandleImpl.hh */
