/* ------------------------------------------------------------------------
 * $Id: ShapeImpl.hh,v 1.14 2001/08/28 13:18:50 elm Exp $
 *
 * This file is part of 3Dwm: The Three-Dimensional User Environment.
 *
 * 3Dwm: The Three-Dimensional User Environment:
 *	<http://www.3dwm.org>
 *
 * Chalmers Medialab
 * 	<http://www.medialab.chalmers.se>
 * 
 * ------------------------------------------------------------------------
 * File created 2000-08-16 by Niklas Elmqvist.
 *
 * Copyright (c) 2000, 2001 Niklas Elmqvist <elm@3dwm.org>.
 * Copyright (c) 2000 Steve Houston <shouston@programmer.net>.
 * ------------------------------------------------------------------------
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * ------------------------------------------------------------------------
 */

#ifndef _ShapeImpl_hh_
#define _ShapeImpl_hh_

// -- System Includes
#include <list>

// -- 3Dwm Includes
#include "Nobel/CORBA.hh"
#include "Nobel/Shape.hh"
#include "Polhem/Tagged.hh"
#include "Polhem/NodeImpl.hh"

// -- Forward Declarations
class TransformImpl;
class VolumeImpl;

// -- Class Declarations

/**
 * C++ implementation of the shape interface.
 **/
class ShapeImpl : public virtual POA_Nobel::Shape,
		  public NodeImpl {
    
public:

    /**
     * Constructor.
     **/
    ShapeImpl();
    
    /**
     * Destructor.
     **/
    virtual ~ShapeImpl();
    
    // IDL functions
    virtual Nobel::Transform_ptr transformation();
    virtual void render(Nobel::Renderer_ptr r);
    virtual void pick(Nobel::Picker_ptr p);    
    virtual Nobel::Volume_ptr getBoundingVolume();
    virtual Nobel::Tag addGeometry(Nobel::Geometry_ptr g);
    virtual void removeGeometry(Nobel::Tag t);
    virtual Nobel::Appearance_ptr getAppearance();
    virtual void setAppearance(Nobel::Appearance_ptr app);
    
protected:

    virtual void recomputeBoundingVolume();

private:
    bool _dirty;
    TransformImpl *_transform;
    Nobel::Appearance_var _appearance;
    typedef Tagged<Nobel::Geometry_var, Nobel::Tag> geo_t;
    std::list<geo_t> _geolist;
    VolumeImpl *_bounds;
};

#endif /* ShapeImpl.hh */
