/* ------------------------------------------------------------------------
 * $Id: SolidContainerImpl.hh,v 1.1 2001/08/22 12:23:20 elm Exp $
 *
 * This file is part of 3Dwm: The Three-Dimensional User Environment.
 *
 * 3Dwm: The Three-Dimensional User Environment:
 *	<http://www.3dwm.org>
 *
 * Chalmers Medialab
 * 	<http://www.medialab.chalmers.se>
 * 
 * ------------------------------------------------------------------------
 * File created 2001-07-12 by Niklas Elmqvist.
 *
 * Copyright (c) 2001 Niklas Elmqvist <elm@3dwm.org>.
 * ------------------------------------------------------------------------
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * ------------------------------------------------------------------------
 */

#ifndef _SolidContainerImpl_hh_
#define _SolidContainerImpl_hh_

// -- System Includes
#include <vector>

// -- 3Dwm Includes
#include "Nobel/CORBA.hh"
#include "Nobel/SolidContainer.hh"
#include "Polhem/SolidCache.hh"
#include "Polhem/NodeImpl.hh"

// -- Forward Declarations
struct TriMeshShape;
class VolumeImpl;
class SolidEvaluator;

// -- Class Declarations

/**
 * Solid event listener. Resides inside the solid container and
 * listens to change events emitted from the solid nodes. All changed
 * nodes will be invalidated in the solid cache and thus recomputed
 * during the next solid evaluation pass.
 **/
class SolidListener : public virtual POA_Nobel::Listener,
		      public virtual PortableServer::RefCountServantBase {
public:

    /**
     * Constructor.
     *
     * @param cache pointer to solid cache to use.
     **/
    SolidListener(SolidCache *cache) : _cache(cache) { }
    
    /**
     * Destructor.
     **/
    virtual ~SolidListener();

    /**
     * Set the solid tree that the solid listener should listen to.
     * This will make the listener attach itself to the topmost tree
     * node and listen to change events that may invalidate nodes in
     * the solid cache.
     *
     * @param tree pointer to solid node to use as tree root.
     **/
    void setTree(Nobel::Solid::Node_ptr tree);

    // IDL functions
    virtual void receive(const Nobel::Event &e);
private:
    Nobel::Solid::Node_var _tree;
    SolidCache *_cache;
};

/**
 * C++ implementation of the solid container interface.
 **/
class SolidContainerImpl : public virtual POA_Nobel::SolidContainer,
			   public NodeImpl {
public:
    
    /**
     * Constructor.
     **/
    SolidContainerImpl();
    
    /**
     * Destructor.
     **/
    virtual ~SolidContainerImpl();

    // IDL functions
    virtual void render(Nobel::Renderer_ptr r);
    virtual void pick(Nobel::Picker_ptr p);    
    virtual Nobel::Volume_ptr getBoundingVolume();
    virtual void setTree(Nobel::Solid::Node_ptr tree);
    virtual Nobel::Solid::Node_ptr getTree();
    virtual void evaluate();
    
protected:
    
    virtual void recomputeBoundingVolume();
    
private:
    void clearMeshList();

    Nobel::Solid::Node_var _tree;
    VolumeImpl *_bounds;
    vector<TriMeshShape> _mesh_list;
    SolidCache _cache;
    SolidListener *_listener;
    SolidEvaluator *_evaluator;
};

#endif /* SolidContainerImpl.hh */
