/* ------------------------------------------------------------------------
 * $Id: Defines.hh,v 1.1 2001/06/28 09:01:42 elm Exp $
 *
 * This file is part of 3Dwm: The Three-Dimensional User Environment.
 *
 * 3Dwm: The Three-Dimensional User Environment:
 *	<http://www.3dwm.org>
 *
 * Chalmers Medialab
 * 	<http://www.medialab.chalmers.se>
 * 
 * ------------------------------------------------------------------------
 * File created 2001-06-12 by Niklas Elmqvist.
 *
 * Copyright (c) 2001 Niklas Elmqvist <elm@3dwm.org>.
 * ------------------------------------------------------------------------
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * ------------------------------------------------------------------------
 */

#ifndef _Defines_hh_
#define _Defines_hh_

// -- Defines

/* These defines are included by the Zorn parser and lexer, both which
 * are automatically generated using bison and flex, respectively.
 * Since the names of the functions in these tools are fixed, it is
 * normally not possible to link several parsers and lexers. However,
 * the following hack, which involves redefining the names of the
 * functions using the preprocessor, fixes this problem.
 **/
#define yymaxdepth	zorn_maxdepth
#define yyparse		zorn_parse
#define yylex		zorn_lex
#define yyerror		zorn_error
#define yylval		zorn_lval
#define yychar  	zorn_char
#define yydebug		zorn_debug
#define yypact		zorn_pact
#define yyr1		zorn_r1
#define yyr2    	zorn_r2
#define yydef   	zorn_def
#define yychk   	zorn_chk
#define yypgo   	zorn_pgo
#define yyact   	zorn_act
#define yyexca		zorn_exca
#define yyerrflag	zorn_errflag
#define yynerrs		zorn_nerrs
#define yyps		zorn_ps
#define yypv		zorn_pv
#define yys     	zorn_s
#define yy_yys		zorn_yys
#define yystate		zorn_state
#define yytmp		zorn_tmp
#define yyv		zorn_v
#define yy_yyv		zorn_yyv
#define yyval		zorn_val
#define yylval		zorn_lval
#define yylloc		zorn_lloc
#define yyreds		zorn_reds
#define yytoks		zorn_toks
#define yylhs		zorn_yylhs
#define yylen		zorn_yylen
#define yydefred	zorn_yydefred
#define yydgoto		zorn_yydgoto
#define yysindex	zorn_yysindex
#define yyrindex	zorn_yyrindex
#define yygindex	zorn_yygindex
#define yytable		zorn_yytable
#define yycheck		zorn_yycheck

#endif /* Defines.hh */
