/* ------------------------------------------------------------------------
 * $Id: StandardLibrary.hh,v 1.2 2001/06/20 12:32:11 elm Exp $
 *
 * This file is part of 3Dwm: The Three-Dimensional User Environment.
 *
 * 3Dwm: The Three-Dimensional User Environment:
 *	<http://www.3dwm.org>
 *
 * Chalmers Medialab
 * 	<http://www.medialab.chalmers.se>
 * 
 * ------------------------------------------------------------------------
 * File created 2001-06-18 by Niklas Elmqvist.
 *
 * Copyright (c) 2001 Niklas Elmqvist <elm@3dwm.org>.
 * ------------------------------------------------------------------------
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * ------------------------------------------------------------------------
 */

#ifndef _StandardLibrary_hh_
#define _StandardLibrary_hh_

// -- System Includes
#include <map>

// -- Zorn Includes
#include "FunctionObject.hh"

namespace Zorn {

    // -- Class Declarations

    /**
     * Zorn standard library class.
     **/
    class StandardLibrary : public FunctionObject {
    public:
	StandardLibrary();
	virtual ~StandardLibrary();
	Value execute(const std::string &id, const ValueList &vs,
		      Store *store);
    
	virtual int getParamCount(const std::string &id);

	virtual std::vector<std::string> getFunctionNames() const;

	typedef Value (StandardLibrary::*FunctionMethod)
	    (const ValueList &vs, Store *store);
	
    private:

	// -- Zorn Standard library functions -----------------

	Value exists(const ValueList &vs, Store *store);

	Value dump(const ValueList &vs, Store *store);

	Value undefine(const ValueList &vs, Store *store);
	Value define(const ValueList &vs, Store *store);

	Value sqrt(const ValueList &vs, Store *store);
	Value abs(const ValueList &vs, Store *store);
	Value exp(const ValueList &vs, Store *store);
	Value pi(const ValueList &vs, Store *store);
	
	Value print(const ValueList &vs, Store *store);
	Value println(const ValueList &vs, Store *store);
    
	std::map<std::string, FunctionMethod> _functions;
	std::map<std::string, int> _paramCount;
    };

};

#endif /* StandardLibrary.hh */
