/* ------------------------------------------------------------------------
 * DynamicLibrary.cc
 *
 * This file is part of 3Dwm: The Three-Dimensional User Environment.
 *
 * 3Dwm: The Three-Dimensional User Environment:
 *	<http://www.3dwm.org>
 *
 * Chalmers Medialab
 * 	<http://www.medialab.chalmers.se>
 * 
 * ------------------------------------------------------------------------
 * File created 2000-06-19 by Niklas Elmqvist.
 *
 * Copyright (c) 2000 Niklas Elmqvist <elm@3dwm.org>.
 * ------------------------------------------------------------------------
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * ------------------------------------------------------------------------
 */

// -- System Includes
#include <dlfcn.h>

// -- Local Includes
#include "DynamicLibrary.hh"

using namespace std;

// -- Code Segment

void DynamicLibrary::open(const string &library, bool now)
{
    _name = library;
    
    // Attempt to open the dynamic library
    // The parameter "now" governs whether or not we attempt to resolve all
    // symbols now, or do so on-demand.
    _handle = dlopen(_name.c_str(), now ? RTLD_NOW : RTLD_LAZY);
}
    
void DynamicLibrary::close()
{
    // Make sure we do not try to close an empty handle
    if (_handle) dlclose(_handle);
}

void *DynamicLibrary::resolve(const string &symbol)
{
    // Resolve the symbol
    void *ptr = dlsym(_handle, symbol.c_str());
    return ptr;
}
