/* ------------------------------------------------------------------------
 * $Id: Platform.cc,v 1.3 2001/06/20 12:32:13 elm Exp $
 *
 * This file is part of 3Dwm: The Three-Dimensional User Environment.
 *
 * 3Dwm: The Three-Dimensional User Environment:
 *	<http://www.3dwm.org>
 *
 * Chalmers Medialab
 * 	<http://www.medialab.chalmers.se>
 * 
 * ------------------------------------------------------------------------
 * File created 2000-11-17 by Antony Suter.
 *
 * Copyright (c) 2000 Antony Suter <antony@mira.net>.
 * Copyright (c) 2001 Niklas Elmqvist <elm@3dwm.org>.
 * Copyright (c) 2001 Steve Houston <shouston@programmer.net>.
 * ------------------------------------------------------------------------
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * ------------------------------------------------------------------------
 */

// -- 3Dwm Includes
#include "Polhem/Platform.hh"

// -- Code 

#if defined(PLATFORM_GGI)
#  include "GGIPlatform.cc"

GGIPlatform *Platform::t = 0;

#elif defined(PLATFORM_SDL)
#  include "SDLPlatform.cc"

SDLPlatform *Platform::t = 0;

#elif defined(PLATFORM_SDL_FBCON)
#  include "SDLfbconPlatform.cc"

SDLfbconPlatform *Platform::t = 0;

#elif defined(PLATFORM_JUGGLER)
#  include "JugglerPlatform.cc"

JugglerPlatform *Platform::t = 0;

#else
#  warning "no console type defined"
#endif

// Reaper struct (takes care of deallocating the implementation when done)
Platform::Reaper Platform::reaper;
