/* ------------------------------------------------------------------------
 * ServerHandleImpl.cc
 *
 * This file is part of 3Dwm: The Three-Dimensional User Environment.
 *
 * 3Dwm: The Three-Dimensional User Environment:
 *	<http://www.3dwm.org>
 *
 * Chalmers Medialab
 * 	<http://www.medialab.chalmers.se>
 * 
 * ------------------------------------------------------------------------
 * File created 2000-10-24 by Niklas Elmqvist.
 *
 * Copyright (c) 2000 Niklas Elmqvist <elm@3dwm.org>.
 * Copyright (c) 2001 Steve Houston <steve@3dwm.org>.
 * ------------------------------------------------------------------------
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * ------------------------------------------------------------------------
 */

// -- 3Dwm Includes
#include "Celsius/Mutex.hh"
#include "Polhem/NodeImpl.hh"
#include "Polhem/SolidKitImpl.hh"
#include "Polhem/NodeKitImpl.hh"
#include "Polhem/GeometryKitImpl.hh"
#include "Polhem/PrimitiveKitImpl.hh"
#include "Polhem/ServerHandleImpl.hh"
#include "Polhem/TextureKitImpl.hh"

using namespace Nobel;

// -- Code Segment

ServerHandleImpl::ServerHandleImpl(NodeImpl *root)
    : _alive(true), _root(root)
{
    // Create the kits (we should use a plugin architecture here later)
    _kits[GeometryKit::_PD_repoId] = new GeometryKitImpl();
    _kits[NodeKit::_PD_repoId] = new NodeKitImpl();
    _kits[SolidKit::_PD_repoId] = new SolidKitImpl();
    _kits[PrimitiveKit::_PD_repoId] = new PrimitiveKitImpl();
    _kits[TextureKit::_PD_repoId] = new TextureKitImpl();
}

ServerHandleImpl::~ServerHandleImpl()
{
    // Deallocate all kits
    for (KitMap::iterator i = _kits.begin(); i != _kits.end(); i++) {
	KitImpl *kit = i->second;
	deactivate(kit);
	delete kit;
    }
    // @@@How to clear out the local scene graph root?
}

Kit_ptr ServerHandleImpl::resolve(const char* name)
{
    // @@@ Need to add an exception here 
    KitMap::iterator i = _kits.find(name);
    if (i != _kits.end()) 
	return i->second->_this();
    return Kit::_nil();
}

void ServerHandleImpl::shutdown()
{
    _alive = false;
}

Node_ptr ServerHandleImpl::root()
{
    return _root->_this();
}
