/* ------------------------------------------------------------------------
 * $Id: SolidKitImpl.cc,v 1.4 2001/08/22 12:23:20 elm Exp $
 *
 * This file is part of 3Dwm: The Three-Dimensional User Environment.
 *
 * 3Dwm: The Three-Dimensional User Environment:
 *	<http://www.3dwm.org>
 *
 * Chalmers Medialab
 * 	<http://www.medialab.chalmers.se>
 * 
 * ------------------------------------------------------------------------
 * File created 2001-07-12 by Niklas Elmqvist.
 *
 * Copyright (c) 2001 Niklas Elmqvist <elm@3dwm.org>.
 * ------------------------------------------------------------------------
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * ------------------------------------------------------------------------
 */

// -- 3Dwm Includes
#include "Celsius/Mutex.hh"
#include "Polhem/Solid.hh"
#include "Polhem/SolidContainerImpl.hh"
#include "Polhem/SolidKitImpl.hh"

// @@@ temporary!
//#include "Nobel/TriangleGeometry.hh"

using namespace Nobel;

// -- Code Segment

SolidContainer_ptr SolidKitImpl::createContainer()
{
    // Create and activate the scene graph node
    SolidContainerImpl *node = activate(new SolidContainerImpl());
    return node->_this();
}

Solid::Binary_ptr SolidKitImpl::createUnion(Solid::Node_ptr left,
					    Solid::Node_ptr right)
{
    // Create and initialize the union
    SolidImpl::Binary *node = activate(new SolidImpl::Union());
    node->left(left);
    node->right(right);
    return node->_this();
}

Solid::Binary_ptr SolidKitImpl::createIntersection(Solid::Node_ptr left,
						   Solid::Node_ptr right)
{
    // Create and initialize the intersection
    SolidImpl::Binary *node = activate(new SolidImpl::Intersection());
    node->left(left);
    node->right(right);
    return node->_this();
}

Solid::Binary_ptr SolidKitImpl::createSubtraction(Solid::Node_ptr left,
						  Solid::Node_ptr right)
{
    // Create and initialize the subtraction
    SolidImpl::Binary *node = activate(new SolidImpl::Subtraction());
    node->left(left);
    node->right(right);
    return node->_this();
}

Solid::Unary_ptr SolidKitImpl::createComplement(Solid::Node_ptr body)
{
    // Create and initialize the complement
    SolidImpl::Unary *node = activate(new SolidImpl::Complement());
    node->body(body);
    return node->_this();
}

Solid::Geometry_ptr SolidKitImpl::createGeometry(TriangleGeometry_ptr geo)
{
    // Create and return the geometry container
    SolidImpl::Geometry *node = activate(new SolidImpl::Geometry(geo));
    return node->_this();
}

Solid::Primitive_ptr SolidKitImpl::createPrimitive(Primitive_ptr prim)
{
    // Create and return the primitive container
    SolidImpl::Primitive *node = activate(new SolidImpl::Primitive(prim));
    return node->_this();
}

Solid::Transform_ptr SolidKitImpl::createTransform(Solid::Node_ptr body)
{
    // Create, initialize and return the transform
    SolidImpl::Transform *node = activate(new SolidImpl::Transform());
    node->body(body);
    return node->_this();
}

Solid::Appearance_ptr SolidKitImpl::createAppearance(Appearance_ptr app)
{
    // Create and return the appearance container
    SolidImpl::Appearance *node = activate(new SolidImpl::Appearance(app));
    return node->_this();
}
