# Part of the A-A-P recipe executive: Testing of :child

# Copyright (C) 2002-2003 Stichting NLnet Labs
# Permission to copy and use this file is specified in the file COPYING.
# If this file is missing you can find it here: http://www.a-a-p.org/COPYING

import sys, os, stat, shutil, string

def runaap(args):
    return os.system("%s ..%sMain.py %s" % (sys.argv[1], os.sep, args))

os.chdir("rectest")

# Create two recipes, where the first one uses the other one with ":child".
# Check that the right files are created.
# Then run it again and check that the signatures were remembered.
testdir = "rectest"
rec1 = "rectest.aap"
rec2 = testdir + "/rectest.aap"
aapout = "rectest.aap.out"
inp = "rectest.in"
out = "rectest.out"
inp2 = testdir + "/rectest.in"
out2 = testdir + "/rectest.out"
inp_contents = "input file one\n"
inp_contents_a = "alternate input file one\n"
inp2_contents = "input file two\n"
inp2_contents_a = "alternate input file two\n"

def cleanup():
    for n in [ rec1, aapout, inp, out ]:
        try:
            os.remove(n)
        except:
            pass
    try:
	shutil.rmtree(testdir)
    except:
	pass

cleanup()
os.mkdir(testdir)

f = open(rec1, "w")
f.write("""
all: %s %s
%s: %s
    :copy {force} $source $target
:child %s
""" % (out, out2, out, inp, rec2))
f.close()

f = open(rec2, "w")
f.write("""
%s: %s
    :copy {force} $source $target
""" % (out, inp))
f.close()

f = open(inp, "w")
f.write(inp_contents)
f.close()

f = open(inp2, "w")
f.write(inp2_contents)
f.close()

def check_contents(fname, expected):
    f = open(fname)
    actual = f.read()
    f.close()
    if actual != expected:
	print ('File contents wrong for "%s": "%s" instead of "%s"'
						   % (fname, actual, expected))

def check_result(msg, copies, out_contents, out2_contents):
    """Check the messages for the two copy commands."""
    failed = 0

    # Count the number of copy commands executed.
    n = 0
    i = 0
    while 1:
	i = string.find(msg, " Copied ", i)
	if i < 0:
	    break
	n = n + 1
	i = i + 5

    if n != copies:
	if copies == 0:
	    print "Aap did copy a file unexpectedly"
	elif n == 0:
	    print "Aap did not copy any file"
	else:
	    print "Aap copied %d file(s), expected %d" % (n, copies)
	print msg
	return 1

    # Check the output files being correctly created or changed execpectedly.
    check_contents(out, out_contents)
    check_contents(out2, out2_contents)

    return failed

# The first time running should result in two files being copied.
res = runaap("-f %s > %s" % (rec1, aapout))
failed = res + check_result(open(aapout).read(), 2,
						   inp_contents, inp2_contents)

if not failed:
    # The second time running should result in no file copy at all.
    res = runaap("-f %s > %s" % (rec1, aapout))
    failed = res + check_result(open(aapout).read(), 0,
						   inp_contents, inp2_contents)

if not failed:
    # Change one input file, only one file should be copied.
    f = open(inp, "w")
    f.write(inp_contents_a)
    f.close()
    res = runaap("-f %s > %s" % (rec1, aapout))
    failed = res + check_result(open(aapout).read(), 1,
						 inp_contents_a, inp2_contents)

if not failed:
    # Change another input file, only one file should be copied.
    f = open(inp2, "w")
    f.write(inp2_contents_a)
    f.close()
    res = runaap("-f %s > %s" % (rec1, aapout))
    failed = res + check_result(open(aapout).read(), 1,
					       inp_contents_a, inp2_contents_a)

cleanup()

sys.exit(failed)


# vim: set sw=4 et sts=4 tw=79 fo+=l:
